/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslExceptionKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import com.intellij.ui.dsl.gridLayout.impl.RowBaselineData;
import com.intellij.ui.scale.JBUIScale;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "", "<init>", "()V", "rowBaselineData", "", "", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "Lcom/intellij/ui/dsl/gridLayout/impl/RowBaselineData;", "reset", "", "registerBaseline", "layoutCellData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "baseline", "get", "verticalAlign", "getOrCreate", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nGridImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridImpl.kt\ncom/intellij/ui/dsl/gridLayout/impl/BaselineData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,705:1\n1#2:706\n383#3,7:707\n383#3,7:714\n*S KotlinDebug\n*F\n+ 1 GridImpl.kt\ncom/intellij/ui/dsl/gridLayout/impl/BaselineData\n*L\n673#1:707,7\n674#1:714,7\n*E\n"})
final class BaselineData {
    @NotNull
    private final Map<Integer, Map<VerticalAlign, RowBaselineData>> rowBaselineData = new LinkedHashMap();

    public final void reset() {
        this.rowBaselineData.clear();
    }

    public final void registerBaseline(@NotNull LayoutCellData layoutCellData, int baseline) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Gaps constraintsGaps = layoutCellData.getScaledGaps();
        Gaps constraintsVisualPaddings = layoutCellData.getScaledVisualPaddings();
        UiDslExceptionKt.checkTrue(GridImplKt.access$isSupportedBaseline(layoutCellData.getCell().getConstraints()));
        RowBaselineData rowBaselineData = this.getOrCreate(layoutCellData);
        rowBaselineData.setMaxAboveBaseline(Math.max(rowBaselineData.getMaxAboveBaseline(), baseline + JBUIScale.scale((int)layoutCellData.getUnscaledRowGaps().getTop()) + constraintsGaps.getTop() - constraintsVisualPaddings.getTop()));
        rowBaselineData.setMaxBelowBaseline(Math.max(rowBaselineData.getMaxBelowBaseline(), layoutCellData.getPreferredSize().height - baseline + JBUIScale.scale((int)layoutCellData.getUnscaledRowGaps().getBottom()) + constraintsGaps.getBottom() - constraintsVisualPaddings.getBottom()));
    }

    @Nullable
    public final RowBaselineData get(@NotNull VerticalAlign verticalAlign) {
        Map<VerticalAlign, RowBaselineData> map;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
            UiDslExceptionKt.checkTrue(this.rowBaselineData.size() <= 1);
            for (Map.Entry<Integer, Map<VerticalAlign, RowBaselineData>> it : this.rowBaselineData.entrySet()) {
                boolean bl = false;
                Map<VerticalAlign, RowBaselineData> map2 = it.getValue();
                if (map2 == null) continue;
                map = map2;
                break block1;
            }
            map = null;
        }
        return map != null ? (RowBaselineData)map.get((Object)verticalAlign) : null;
    }

    @Nullable
    public final RowBaselineData get(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints = layoutCellData.getCell().getConstraints();
        Map<VerticalAlign, RowBaselineData> map = this.rowBaselineData.get(constraints.getY());
        return map != null ? map.get((Object)constraints.getVerticalAlign()) : null;
    }

    private final RowBaselineData getOrCreate(LayoutCellData layoutCellData) {
        Object object;
        Map mapByAlign;
        Object object2;
        Map $this$getOrPut$iv;
        Constraints constraints = layoutCellData.getCell().getConstraints();
        Map<Integer, Map<VerticalAlign, RowBaselineData>> map = this.rowBaselineData;
        Object key$iv = constraints.getY();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new EnumMap(VerticalAlign.class);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = mapByAlign = (Map)object2;
        key$iv = constraints.getVerticalAlign();
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            RowBaselineData answer$iv = new RowBaselineData(0, 0, 3, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RowBaselineData)object;
    }
}

