/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010*\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010*\u001a\u00020.H\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u000201H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00103\u001a\u000201H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u000207H\u0016J\b\u0010:\u001a\u000207H\u0016J\u0010\u0010;\u001a\u00020\u00162\u0006\u00109\u001a\u000207H\u0016J\b\u0010<\u001a\u000207H\u0016J\u0011\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020?H\u0096\u0002J\n\u0010@\u001a\u0004\u0018\u00010?H\u0016J\n\u0010A\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010B\u001a\u00020\u00162\u0006\u0010>\u001a\u00020?H\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020\u00162\u0006\u0010F\u001a\u00020DH\u0016J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020HH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010\u00022\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010L\u001a\u000207H\u0016J\b\u0010M\u001a\u00020\u0016H\u0016J\u0010\u0010N\u001a\u00020\u00162\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00162\u0006\u0010O\u001a\u00020PH\u0016J\u0015\u0010R\u001a\n\u0012\u0004\u0012\u00020T\u0018\u00010SH\u0016\u00a2\u0006\u0002\u0010UJ\b\u0010V\u001a\u00020\u000eH\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010X\u001a\u0002072\u0006\u0010\"\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006Y"}, d2={"Lcom/intellij/ui/tabs/impl/AccessibleTabPage;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/Accessible;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "parent", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "tabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;Lcom/intellij/ui/tabs/TabInfo;)V", "component", "Ljavax/swing/JComponent;", "tabIndex", "", "getTabIndex", "()I", "tabLabel", "Lcom/intellij/ui/tabs/impl/TabLabel;", "getTabLabel", "()Lcom/intellij/ui/tabs/impl/TabLabel;", "initAccessibleContext", "", "getAccessibleContext", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "getAccessibleIndexInParent", "getAccessibleChildrenCount", "getAccessibleChild", "i", "getLocale", "Ljava/util/Locale;", "getAccessibleComponent", "getAccessibleAction", "getBackground", "Ljava/awt/Color;", "setBackground", "c", "getForeground", "setForeground", "getCursor", "Ljava/awt/Cursor;", "setCursor", "getFont", "Ljava/awt/Font;", "setFont", "f", "getFontMetrics", "Ljava/awt/FontMetrics;", "isEnabled", "", "setEnabled", "b", "isVisible", "setVisible", "isShowing", "contains", "p", "Ljava/awt/Point;", "getLocationOnScreen", "getLocation", "setLocation", "getBounds", "Ljava/awt/Rectangle;", "setBounds", "r", "getSize", "Ljava/awt/Dimension;", "setSize", "d", "getAccessibleAt", "isFocusTraversable", "requestFocus", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "removeFocusListener", "getAccessibleIcon", "", "Ljavax/accessibility/AccessibleIcon;", "()[Ljavax/accessibility/AccessibleIcon;", "getAccessibleActionCount", "getAccessibleActionDescription", "doAccessibleAction", "intellij.platform.ide"})
final class AccessibleTabPage
extends AccessibleContext
implements Accessible,
AccessibleComponent,
AccessibleAction {
    @NotNull
    private final JBTabsImpl parent;
    @NotNull
    private final TabInfo tabInfo;
    @NotNull
    private final JComponent component;

    public AccessibleTabPage(@NotNull JBTabsImpl parent, @NotNull TabInfo tabInfo) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
        this.parent = parent;
        this.tabInfo = tabInfo;
        this.component = this.tabInfo.getComponent();
        this.setAccessibleParent(this.parent);
        this.initAccessibleContext();
    }

    private final int getTabIndex() {
        return this.parent.getIndexOf(this.tabInfo);
    }

    private final TabLabel getTabLabel() {
        return this.parent.getTabLabel(this.tabInfo);
    }

    public final void initAccessibleContext() {
        AccessibleContext ac;
        if (this.component instanceof Accessible && (ac = ((Accessible)((Object)this.component)).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        return this;
    }

    @Override
    @Nullable
    public String getAccessibleName() {
        TabLabel label2;
        String name = this.accessibleName;
        if (name == null) {
            name = (String)this.parent.getClientProperty("AccessibleName");
        }
        if (name == null && (label2 = this.getTabLabel()) != null) {
            name = label2.getAccessibleContext().getAccessibleName();
        }
        if (name == null) {
            name = super.getAccessibleName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getAccessibleDescription() {
        TabLabel label2;
        String description = this.accessibleDescription;
        if (description == null) {
            description = (String)this.parent.getClientProperty("AccessibleDescription");
        }
        if (description == null && (label2 = this.getTabLabel()) != null) {
            description = label2.getAccessibleContext().getAccessibleDescription();
        }
        if (description == null) {
            description = super.getAccessibleDescription();
        }
        return description;
    }

    @Override
    @NotNull
    public AccessibleRole getAccessibleRole() {
        AccessibleRole accessibleRole = AccessibleRole.PAGE_TAB;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PAGE_TAB");
        return accessibleRole;
    }

    @Override
    @NotNull
    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = this.parent.getAccessibleContext().getAccessibleStateSet();
        states.add(AccessibleState.SELECTABLE);
        TabInfo info = this.parent.getSelectedInfo();
        if (Intrinsics.areEqual((Object)info, (Object)this.tabInfo)) {
            states.add(AccessibleState.SELECTED);
        }
        Intrinsics.checkNotNull((Object)states);
        return states;
    }

    @Override
    public int getAccessibleIndexInParent() {
        int n = this.parent.getAccessibleContext().getAccessibleChildrenCount();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this.parent.getAccessibleContext().getAccessibleChild(i), (Object)this)) continue;
            return i;
        }
        return this.getTabIndex();
    }

    @Override
    public int getAccessibleChildrenCount() {
        return Intrinsics.areEqual((Object)this.parent.getSelectedInfo(), (Object)this.tabInfo) && this.component instanceof Accessible ? 1 : 0;
    }

    @Override
    @Nullable
    public Accessible getAccessibleChild(int i) {
        return Intrinsics.areEqual((Object)this.parent.getSelectedInfo(), (Object)this.tabInfo) && this.component instanceof Accessible ? (Accessible)((Object)this.component) : null;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = this.parent.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
        return locale;
    }

    @Override
    @NotNull
    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    @Override
    @NotNull
    public AccessibleAction getAccessibleAction() {
        return this;
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = this.parent.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        return color;
    }

    @Override
    public void setBackground(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.parent.setBackground(c);
    }

    @Override
    @NotNull
    public Color getForeground() {
        Color color = this.parent.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
        return color;
    }

    @Override
    public void setForeground(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.parent.setForeground(c);
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        Cursor cursor = this.parent.getCursor();
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getCursor(...)");
        return cursor;
    }

    @Override
    public void setCursor(@NotNull Cursor c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.parent.setCursor(c);
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = this.parent.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.parent.setFont(f);
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        FontMetrics fontMetrics = this.parent.getFontMetrics(f);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        return fontMetrics;
    }

    @Override
    public boolean isEnabled() {
        return this.tabInfo.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.tabInfo.setEnabled(b);
    }

    @Override
    public boolean isVisible() {
        return !this.tabInfo.isHidden();
    }

    @Override
    public void setVisible(boolean b) {
        this.tabInfo.setHidden(!b);
    }

    @Override
    public boolean isShowing() {
        return this.parent.isShowing();
    }

    @Override
    public boolean contains(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(p);
    }

    @Override
    @Nullable
    public Point getLocationOnScreen() {
        Point parentLocation = this.parent.getLocationOnScreen();
        Point point = this.getLocation();
        if (point == null) {
            return null;
        }
        Point componentLocation = point;
        componentLocation.translate(parentLocation.x, parentLocation.y);
        return componentLocation;
    }

    @Override
    @Nullable
    public Point getLocation() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return null;
        }
        Rectangle r = rectangle;
        return new Point(r.x, r.y);
    }

    @Override
    public void setLocation(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        TabLabel tabLabel = this.getTabLabel();
        return tabLabel != null ? tabLabel.getBounds() : null;
    }

    @Override
    public void setBounds(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
    }

    @Override
    @Nullable
    public Dimension getSize() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return null;
        }
        Rectangle r = rectangle;
        return new Dimension(r.width, r.height);
    }

    @Override
    public void setSize(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
    }

    @Override
    @Nullable
    public Accessible getAccessibleAt(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.component instanceof Accessible ? (Accessible)((Object)this.component) : null;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void addFocusListener(@NotNull FocusListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    @Override
    public void removeFocusListener(@NotNull FocusListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    @Override
    @Nullable
    public AccessibleIcon[] getAccessibleIcon() {
        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[1];
        Icon icon = this.tabInfo.getIcon();
        ImageIcon imageIcon = icon instanceof ImageIcon ? (ImageIcon)icon : null;
        AccessibleContext accessibleContext = imageIcon != null ? imageIcon.getAccessibleContext() : null;
        if ((accessibleContext instanceof AccessibleIcon ? (AccessibleIcon)((Object)accessibleContext) : null) == null) {
            return null;
        }
        accessibleIconArray[0] = accessibleIconArray[0];
        return accessibleIconArray;
    }

    @Override
    public int getAccessibleActionCount() {
        return 1;
    }

    @Override
    @Nullable
    public String getAccessibleActionDescription(int i) {
        return i == 0 ? "Activate" : null;
    }

    @Override
    public boolean doAccessibleAction(int i) {
        if (i != 0) {
            return false;
        }
        this.parent.select(this.tabInfo, true);
        return true;
    }
}

