/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class KeymapTextContext {
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";

    @Nls
    @NotNull
    public String getShortcutText(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapTextContext.$$$reportNull$$$0(0);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            String string = KeyMapBundle.message("no.shortcut", new Object[0]);
            if (string == null) {
                KeymapTextContext.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getShortcutText((Shortcut)shortcut);
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapTextContext.$$$reportNull$$$0(3);
        }
        Object s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = this.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (!acceleratorText.isEmpty()) {
                s = acceleratorText;
            }
            if (!(acceleratorText = this.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).isEmpty()) {
                s = (String)s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            s = this.getMouseShortcutText((MouseShortcut)shortcut);
        } else if (shortcut instanceof KeyboardModifierGestureShortcut) {
            KeyboardModifierGestureShortcut gestureShortcut = (KeyboardModifierGestureShortcut)shortcut;
            s = gestureShortcut.getType() == KeyboardGestureAction.ModifierType.dblClick ? KeyMapBundle.message("press.release.and.hold", new Object[0]) : KeyMapBundle.message("hold", new Object[0]);
            s = (String)s + " " + this.getKeystrokeText(gestureShortcut.getStroke());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut.getClass().getCanonicalName());
        }
        String string = s;
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapTextContext.$$$reportNull$$$0(5);
        }
        if (shortcut instanceof PressureShortcut) {
            String string = shortcut.toString();
            if (string == null) {
                KeymapTextContext.$$$reportNull$$$0(6);
            }
            return string;
        }
        return this.getMouseShortcutText(shortcut.getButton(), shortcut.getModifiers(), shortcut.getClickCount());
    }

    @Nls
    @NotNull
    private String getMouseShortcutText(int button2, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        String resource;
        if (button2 == 143) {
            resource = "mouse.wheel.rotate.up.shortcut.text";
        } else if (button2 == 142) {
            resource = "mouse.wheel.rotate.down.shortcut.text";
        } else if (clickCount < 2) {
            resource = "mouse.click.shortcut.text";
        } else if (clickCount < 3) {
            resource = "mouse.double.click.shortcut.text";
        } else {
            throw new IllegalStateException("unknown clickCount: " + clickCount);
        }
        String string = KeyMapBundle.message(resource, this.getModifiersText(KeymapTextContext.mapNewModifiers(modifiers), true), button2);
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(7);
        }
        return string;
    }

    @JdkConstants.InputEventMask
    static int mapNewModifiers(@JdkConstants.InputEventMask int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    @NotNull
    @NlsSafe
    public String getKeystrokeText(KeyStroke accelerator) {
        if (accelerator == null) {
            return "";
        }
        if (this.isNativeMacShortcuts()) {
            String string = MacKeymapUtil.getKeyStrokeText(accelerator);
            if (string == null) {
                KeymapTextContext.$$$reportNull$$$0(8);
            }
            return string;
        }
        Object acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = this.getModifiersText(modifiers, true);
        }
        int code = accelerator.getKeyCode();
        acceleratorText = (String)acceleratorText + (this.isSimplifiedMacShortcuts() ? this.getSimplifiedMacKeyText(code) : this.getKeyText(code));
        String string = ((String)acceleratorText).trim();
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getKeyText(int code) {
        String string = switch (code) {
            case 192 -> "`";
            case 108 -> ",";
            case 110 -> ".";
            case 47 -> "/";
            case 92 -> "\\";
            case 46 -> ".";
            case 59 -> ";";
            case 93 -> "]";
            case 91 -> "[";
            case 61 -> "=";
            default -> {
                String result;
                String v1 = result = this.isNativeMacShortcuts() ? MacKeymapUtil.getKeyText(code) : KeyEvent.getKeyText(code);
                if (CANCEL_KEY_TEXT.equals(result)) {
                    yield BREAK_KEY_TEXT;
                }
                yield result;
            }
        };
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(10);
        }
        return string;
    }

    private boolean isNativeMacShortcuts() {
        return ClientSystemInfo.isMac() && !this.isSimplifiedMacShortcuts();
    }

    public boolean isSimplifiedMacShortcuts() {
        return ClientSystemInfo.isMac() && AdvancedSettings.getInstanceIfCreated() != null && AdvancedSettings.getBoolean((String)"ide.macos.disable.native.shortcut.symbols");
    }

    @NotNull
    String getModifiersText(@JdkConstants.InputEventMask int modifiers, boolean addPlus) {
        if (this.isNativeMacShortcuts()) {
            String string = MacKeymapUtil.getModifiersText(modifiers);
            if (string == null) {
                KeymapTextContext.$$$reportNull$$$0(11);
            }
            return string;
        }
        String keyModifiersText = this.isSimplifiedMacShortcuts() ? KeymapTextContext.getSimplifiedMacKeyModifiersText(modifiers) : KeyEvent.getKeyModifiersText(modifiers);
        Object object = !keyModifiersText.isEmpty() && addPlus ? keyModifiersText + "+" : keyModifiersText;
        if (object == null) {
            KeymapTextContext.$$$reportNull$$$0(12);
        }
        return object;
    }

    private static String getSimplifiedMacKeyModifiersText(int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("Cmd+");
        }
        if ((modifiers & 2) != 0) {
            buf.append("Ctrl+");
        }
        if ((modifiers & 8) != 0) {
            buf.append("Alt+");
        }
        if ((modifiers & 1) != 0) {
            buf.append("Shift+");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append("Alt Graph+");
        }
        if ((modifiers & 0x10) != 0) {
            buf.append("Button1+");
        }
        if (!buf.isEmpty()) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private String getSimplifiedMacKeyText(int code) {
        return switch (code) {
            case 10 -> "Enter";
            case 8 -> "Backspace";
            case 9 -> "Tab";
            case 3 -> CANCEL_KEY_TEXT;
            case 12 -> "Clear";
            case 65312 -> "Compose";
            case 19 -> "Pause";
            case 20 -> "Caps Lock";
            case 27 -> "Escape";
            case 32 -> "Space";
            case 33 -> "Page Up";
            case 34 -> "Page Down";
            case 35 -> "End";
            case 36 -> "Home";
            case 37 -> "Left";
            case 38 -> "Up";
            case 39 -> "Right";
            case 40 -> "Down";
            case 65368 -> "Begin";
            case 16 -> "Shift";
            case 17 -> "Control";
            case 18 -> "Alt";
            case 157 -> "Meta";
            case 65406 -> "Alt Graph";
            case 106 -> "NumPad *";
            case 107 -> "NumPad +";
            case 108 -> "NumPad ,";
            case 109 -> "NumPad -";
            case 110 -> "NumPad .";
            case 111 -> "NumPad /";
            case 127 -> "Delete";
            case 144 -> "Num Lock";
            case 145 -> "Scroll Lock";
            case 524 -> "Windows";
            case 525 -> "Context Menu";
            case 112 -> "F1";
            case 113 -> "F2";
            case 114 -> "F3";
            case 115 -> "F4";
            case 116 -> "F5";
            case 117 -> "F6";
            case 118 -> "F7";
            case 119 -> "F8";
            case 120 -> "F9";
            case 121 -> "F10";
            case 122 -> "F11";
            case 123 -> "F12";
            case 61440 -> "F13";
            case 61441 -> "F14";
            case 61442 -> "F15";
            case 61443 -> "F16";
            case 61444 -> "F17";
            case 61445 -> "F18";
            case 61446 -> "F19";
            case 61447 -> "F20";
            case 61448 -> "F21";
            case 61449 -> "F22";
            case 61450 -> "F23";
            case 61451 -> "F24";
            case 154 -> "Print Screen";
            case 155 -> "Insert";
            case 156 -> "Help";
            case 224 -> "Up";
            case 225 -> "Down";
            case 226 -> "Left";
            case 227 -> "Right";
            default -> this.getKeyText(code);
        };
    }

    @NotNull
    public MouseShortcut parseMouseShortcut(@NotNull String keystrokeString) throws InvalidDataException {
        if (keystrokeString == null) {
            KeymapTextContext.$$$reportNull$$$0(13);
        }
        if (keystrokeString.startsWith("Force touch")) {
            return new PressureShortcut(2.0);
        }
        int button2 = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (token.startsWith("button") && token.length() > 6) {
                try {
                    button2 = Integer.parseInt(token.substring(6));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("unparsable token: " + token);
                }
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        return new MouseShortcut(button2, modifiers, clickCount);
    }

    @NotNull
    public String getMouseShortcutString(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapTextContext.$$$reportNull$$$0(14);
        }
        if (shortcut instanceof PressureShortcut) {
            return "Force touch";
        }
        StringBuilder buffer = new StringBuilder();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        buffer.append("button").append(shortcut.getButton()).append(' ');
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        String string = buffer.toString().trim();
        if (string == null) {
            KeymapTextContext.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 7, 8, 9, 10, 11, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/KeymapTextContext";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystrokeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/KeymapTextContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeystrokeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseMouseShortcut";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 7, 8, 9, 10, 11, 12, 15 -> new IllegalStateException(string);
        };
    }
}

