/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class Messages {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    @Deprecated
    public static final String OK_BUTTON = "OK";
    @Deprecated
    public static final String CANCEL_BUTTON = "Cancel";
    private static final Logger LOG = Logger.getInstance(Messages.class);

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int lines) {
        if (comp == null) {
            Messages.$$$reportNull$$$0(0);
        }
        return Messages.wrapToScrollPaneIfNeeded(comp, columns, lines, 4);
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int maxLines, int lines) {
        if (comp == null) {
            Messages.$$$reportNull$$$0(1);
        }
        float fontSize = comp.getFont().getSize2D();
        Dimension maxDim = new Dimension((int)(fontSize * (float)columns), (int)(fontSize * (float)maxLines));
        Dimension prefDim = comp.getPreferredSize();
        if (prefDim.width <= maxDim.width && prefDim.height <= maxDim.height) {
            JComponent jComponent = comp;
            if (jComponent == null) {
                Messages.$$$reportNull$$$0(2);
            }
            return jComponent;
        }
        JScrollPane scrollPane2 = ScrollPaneFactory.createScrollPane(comp);
        scrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setHorizontalScrollBarPolicy(30);
        int barWidth = UIUtil.getScrollBarWidth();
        Dimension preferredSize = new Dimension(Math.min(prefDim.width, maxDim.width) + barWidth, Math.min(prefDim.height, maxDim.height) + barWidth);
        if (prefDim.width > maxDim.width) {
            preferredSize.height = Math.max(preferredSize.height, (int)((float)lines * fontSize) + barWidth);
        }
        scrollPane2.setPreferredSize(preferredSize);
        JScrollPane jScrollPane = scrollPane2;
        if (jScrollPane == null) {
            Messages.$$$reportNull$$$0(3);
        }
        return jScrollPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, @NlsContexts.DialogMessage String message) {
        JTextPane pane = Messages.configureMessagePaneUi(messageComponent, message, null);
        if ("text/html".equals(pane.getContentType())) {
            pane.addHyperlinkListener((HyperlinkListener)((Object)BrowserHyperlinkListener.INSTANCE));
        }
        JTextPane jTextPane = pane;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(4);
        }
        return jTextPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(@NotNull JTextPane messageComponent, @NlsContexts.DialogMessage @Nullable String message, @Nullable UIUtil.FontSize fontSize) {
        if (messageComponent == null) {
            Messages.$$$reportNull$$$0(5);
        }
        UIUtil.FontSize fixedFontSize = fontSize == null ? UIUtil.FontSize.NORMAL : fontSize;
        messageComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize));
        if (BasicHTML.isHTMLString(message)) {
            messageComponent.setEditorKit(HTMLEditorKitBuilder.simple());
        }
        messageComponent.setText(message);
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setBackground(UIUtil.getOptionPaneBackground());
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(6);
        }
        return jTextPane;
    }

    public static void installHyperlinkSupport(JTextPane messageComponent) {
        Messages.configureMessagePaneUi(messageComponent, "<html></html>");
    }

    @Nls
    public static String getOkButton() {
        return CommonBundle.getOkButtonText();
    }

    public static String getYesButton() {
        return CommonBundle.getYesButtonText();
    }

    public static String getNoButton() {
        return CommonBundle.getNoButtonText();
    }

    @Nls
    public static String getCancelButton() {
        return CommonBundle.getCancelButtonText();
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon = UIUtil.getErrorIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon = UIUtil.getInformationIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon = UIUtil.getWarningIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon = UIUtil.getQuestionIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(10);
        }
        return icon;
    }

    public static int showDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            Messages.$$$reportNull$$$0(11);
        }
        return Messages.showDialog(project, message, title, options, defaultOptionIndex, icon, null);
    }

    @NotNull
    public static Runnable createMessageDialogRemover(@Nullable Project project) {
        Window projectWindow = project == null ? null : WindowManager.getInstance().suggestParentWindow(project);
        Runnable runnable = () -> SwingUtilities.invokeLater(() -> Messages.makeCurrentMessageDialogGoAway(projectWindow == null ? Window.getWindows() : projectWindow.getOwnedWindows()));
        if (runnable == null) {
            Messages.$$$reportNull$$$0(12);
        }
        return runnable;
    }

    private static void makeCurrentMessageDialogGoAway(Window @NotNull [] checkWindows) {
        if (checkWindows == null) {
            Messages.$$$reportNull$$$0(13);
        }
        for (Window w : checkWindows) {
            JButton cancelButton;
            JDialog dialog;
            JDialog jDialog = dialog = w instanceof JDialog ? (JDialog)w : null;
            if (dialog == null || !dialog.isModal() || (cancelButton = (JButton)UIUtil.uiTraverser((Component)dialog.getRootPane()).filter(JButton.class).filter(b -> CommonBundle.getCancelButtonText().equals(b.getText())).first()) == null) continue;
            cancelButton.doClick();
        }
    }

    public static int showDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(14);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(15);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, false, null);
    }

    @Deprecated(forRemoval=true)
    public static int showDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(16);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(17);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, (DoNotAskOption)doNotAskOption, false, null);
    }

    public static int showIdeaMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(18);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, true, null);
    }

    @Deprecated(forRemoval=true)
    public static int showIdeaMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(19);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, (DoNotAskOption)doNotAskOption, true, null);
    }

    @Deprecated(forRemoval=true)
    public static boolean canShowMacSheetPanel() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public static boolean isMacSheetEmulation() {
        return false;
    }

    public static int showDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable String moreInfo, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(20);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(21);
        }
        return MessagesService.getInstance().showMoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon);
    }

    public static int showDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(22);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(23);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(24);
        }
        return MessagesService.getInstance().showMessageDialog(null, parent, message, title, options, defaultOptionIndex, -1, icon, null, false, null);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(25);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(26);
        }
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, false, null);
    }

    @Deprecated(forRemoval=true)
    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(27);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(28);
        }
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, (DoNotAskOption)doNotAskOption, false, null);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, @Nullable String invocationPlace) {
        if (title == null) {
            Messages.$$$reportNull$$$0(29);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(30);
        }
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, false, null, invocationPlace, new ExitActionType[0]);
    }

    @Deprecated(forRemoval=true)
    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, @Nullable String invocationPlace) {
        if (title == null) {
            Messages.$$$reportNull$$$0(31);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(32);
        }
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, (DoNotAskOption)doNotAskOption, false, null, invocationPlace, new ExitActionType[0]);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(33);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, -1, icon, doNotAskOption);
    }

    @Deprecated(forRemoval=true)
    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(34);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, -1, icon, doNotAskOption);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            Messages.$$$reportNull$$$0(35);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, icon, null);
    }

    public static void showMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(36);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, icon);
    }

    public static void showMessageDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(37);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(38);
        }
        Messages.showDialog(parent, message, title, new String[]{Messages.getOkButton()}, 0, icon);
    }

    public static void showMessageDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(39);
        }
        Messages.showDialog(message, title, new String[]{Messages.getOkButton()}, 0, icon);
    }

    @Deprecated
    public static int showConfirmationDialog(@NotNull JComponent parent, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yesText, @NlsContexts.Button @NotNull String noText) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(40);
        }
        if (message == null) {
            Messages.$$$reportNull$$$0(41);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(42);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(43);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(44);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(yesText)).noText(noText)).ask((Component)parent) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yesText, @NlsContexts.Button @NotNull String noText, @Nullable Icon icon) {
        if (message == null) {
            Messages.$$$reportNull$$$0(45);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(46);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(47);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(48);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(yesText)).noText(noText)).icon(icon)).ask(project) ? 0 : 1;
    }

    @Deprecated(forRemoval=true)
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yesText, @NlsContexts.Button @NotNull String noText, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(49);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(50);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(51);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).doNotAsk(doNotAskOption)).yesText(yesText)).noText(noText)).ask(project) ? 0 : 1;
    }

    @Deprecated(forRemoval=true)
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yesText, @NlsContexts.Button @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(52);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(53);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(54);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).yesText(yesText)).noText(noText)).ask(project) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(55);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).ask(project) ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(56);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).doNotAsk(doNotAskOption)).ask(project) ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(57);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).ask(project) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(58);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(59);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).ask(parent) ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @Nls @NotNull String yesText, @NlsContexts.Button @Nls @NotNull String noText, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(60);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(61);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(62);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(yesText)).noText(noText)).icon(icon)).doNotAsk(doNotAskOption)).guessWindowAndAsk() ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @Nls @NotNull String yesText, @NlsContexts.Button @Nls @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(63);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(64);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(65);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(yesText)).noText(noText)).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).guessWindowAndAsk() ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String yesText, @NlsContexts.Button String noText, @Nullable Icon icon) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(yesText)).noText(noText)).icon(icon)).guessWindowAndAsk() ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(66);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).guessWindowAndAsk() ? 0 : 1;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (message == null) {
            Messages.$$$reportNull$$$0(67);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(68);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(69);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(70);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).doNotAsk(doNotAskOption)).ask(project) ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (message == null) {
            Messages.$$$reportNull$$$0(71);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(72);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(73);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(74);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).ask(project) ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(75);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(76);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(77);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).ask(project) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon) {
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).icon(icon)).ask(project) ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(78);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(79);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(80);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(81);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).ask(parent) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(82);
        }
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).icon(icon)).ask(parent) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon) {
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).icon(icon)).guessWindowAndAsk() ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String okText, @NlsContexts.Button String cancelText, Icon icon) {
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).guessWindowAndAsk() ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(83);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(84);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(85);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).doNotAsk(doNotAskOption)).guessWindowAndAsk() ? 0 : 2;
    }

    @Deprecated(forRemoval=true)
    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String okText, @NlsContexts.Button @NotNull String cancelText, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(86);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(87);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(88);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)message).yesText(okText)).noText(cancelText)).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).guessWindowAndAsk() ? 0 : 2;
    }

    public static int showCheckboxOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, (? super Integer exitCode, ? super JCheckBox cb) -> exitCode == -1 ? 2 : exitCode + (cb.isSelected() ? 1 : 0));
    }

    public static int showCheckboxMessageDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, @Nullable BiFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (options == null) {
            Messages.$$$reportNull$$$0(89);
        }
        return MessagesService.getInstance().showTwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
    }

    public static int showCheckboxMessageDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NlsContexts.Button @NotNull [] options, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, @Nullable PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (options == null) {
            Messages.$$$reportNull$$$0(90);
        }
        return Messages.showCheckboxMessageDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
    }

    public static int showTwoStepConfirmationDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{Messages.getOkButton()}, checkboxText, true, -1, -1, icon, null);
    }

    public static void showErrorDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(91);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@Nullable Component component, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(92);
        }
        MessagesService.getInstance().showMessageDialog(null, component, message, title, new String[]{Messages.getOkButton()}, 0, 0, Messages.getErrorIcon(), null, false, null);
    }

    public static void showErrorDialog(@NotNull Component component, @NlsContexts.DialogMessage String message) {
        if (component == null) {
            Messages.$$$reportNull$$$0(93);
        }
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{Messages.getOkButton()}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(94);
        }
        Messages.showErrorDialog((Component)null, message, title);
    }

    public static void showWarningDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(95);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NotNull Component component, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (component == null) {
            Messages.$$$reportNull$$$0(96);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(97);
        }
        Messages.showDialog(component, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(98);
        }
        Messages.showDialog(message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yes, @NlsContexts.Button @NotNull String no, @NlsContexts.Button @NotNull String cancel, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(99);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(100);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(101);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(102);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon)).show(project);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).icon(icon)).show(project);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yes, @NlsContexts.Button @NotNull String no, @NlsContexts.Button @NotNull String cancel, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(103);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(104);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(105);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(106);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(107);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon)).show(parent);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(108);
        }
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).icon(icon)).show(parent);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yes, @NlsContexts.Button @NotNull String no, @NlsContexts.Button @NotNull String cancel, Icon icon, @Nullable DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(109);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(110);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(111);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(112);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon)).doNotAsk(doNotAskOption)).guessWindowAndAsk();
    }

    @Deprecated(forRemoval=true)
    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yes, @NlsContexts.Button @NotNull String no, @NlsContexts.Button @NotNull String cancel, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(113);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(114);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(115);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(116);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon)).doNotAsk((DoNotAskOption)doNotAskOption)).guessWindowAndAsk();
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String yes, @NlsContexts.Button String no, @NlsContexts.Button String cancel, Icon icon) {
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon)).guessWindowAndAsk();
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).icon(icon)).guessWindowAndAsk();
    }

    @Nullable
    public static String showPasswordDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        return Messages.showPasswordDialog(null, message, title, null, null);
    }

    @Nullable
    public static String showPasswordDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        return Messages.showPasswordDialog(project, message, title, icon, null);
    }

    @Nullable
    public static String showPasswordDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showPasswordDialog(project, message, title, icon, validator);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        return Messages.showInputDialog(project, message, title, icon, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(117);
        }
        return Messages.showInputDialog(parent, message, title, icon, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        return Messages.showInputDialog(message, title, icon, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection) {
        return Messages.showInputDialog(project, message, title, icon, initialValue, validator, selection, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection, @NlsContexts.DetailedDescription @Nullable String comment) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon, initialValue, validator, selection, comment);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NotNull Component parentComponent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection, @NlsContexts.DetailedDescription @Nullable String comment) {
        if (parentComponent == null) {
            Messages.$$$reportNull$$$0(118);
        }
        return MessagesService.getInstance().showInputDialog(null, parentComponent, message, title, icon, initialValue, validator, selection, comment);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(119);
        }
        return MessagesService.getInstance().showInputDialog(null, parent, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialog(null, null, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showMultilineInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable @NonNls String initialValue, @Nullable Icon icon, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showMultilineInputDialog(project, message, title, initialValue, icon, validator);
    }

    @NotNull
    public static Pair<String, Boolean> showInputDialogWithCheckBox(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
        Pair pair = MessagesService.getInstance().showInputDialogWithCheckBox(message, title, checkboxText, checked, checkboxEnabled, icon, initialValue, validator);
        if (pair == null) {
            Messages.$$$reportNull$$$0(120);
        }
        return pair;
    }

    @Nullable
    public static String showEditableChooseDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, String[] values, String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showEditableChooseDialog(message, title, icon, values, initialValue, validator);
    }

    @Deprecated
    public static int showChooseDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String[] values, String initialValue, @Nullable Icon icon) {
        return MessagesService.getInstance().showChooseDialog(null, null, message, title, values, initialValue, icon);
    }

    @Deprecated
    public static int showChooseDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon, String[] values, String initialValue) {
        return MessagesService.getInstance().showChooseDialog(project, null, message, title, values, initialValue, icon);
    }

    public static void showInfoMessage(Component component, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(121);
        }
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(122);
        }
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(123);
        }
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(JTextField textField, @NlsContexts.DialogTitle String title, @NonNls String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        MessagesService.getInstance().showTextAreaDialog(textField, title, dimensionServiceKey, parser, lineJoiner);
    }

    public static void showTextAreaDialog(JTextField textField, @NlsContexts.DialogTitle String title, @NonNls String dimensionServiceKey) {
        Messages.showTextAreaDialog(textField, title, dimensionServiceKey, (Function<? super String, ? extends List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<? super List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10, 12, 120 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageComponent";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkWindows";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 63: 
            case 66: 
            case 68: 
            case 72: 
            case 75: 
            case 79: 
            case 83: 
            case 86: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 104: 
            case 109: 
            case 113: 
            case 121: 
            case 122: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 22: 
            case 37: 
            case 40: 
            case 58: 
            case 78: 
            case 82: 
            case 103: 
            case 108: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 41: 
            case 45: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 43: 
            case 47: 
            case 50: 
            case 53: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 44: 
            case 48: 
            case 51: 
            case 54: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
            case 69: 
            case 73: 
            case 76: 
            case 80: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 70: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelText";
                break;
            }
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 100: 
            case 105: 
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yes";
                break;
            }
            case 101: 
            case 106: 
            case 111: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "no";
                break;
            }
            case 102: 
            case 107: 
            case 112: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancel";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToScrollPaneIfNeeded";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "configureMessagePaneUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessageDialogRemover";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialogWithCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapToScrollPaneIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 120: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureMessagePaneUi";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeCurrentMessageDialogGoAway";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showIdeaMessageDialog";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "showConfirmationDialog";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "showOkCancelDialog";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "showCheckboxMessageDialog";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "showWarningDialog";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoCancelDialog";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "showInfoMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 12, 120 -> new IllegalStateException(string);
        };
    }

    public static class InputDialog
    extends MessageDialog {
        public static final int INPUT_DIALOG_COLUMNS = 30;
        protected JTextComponent myField;
        private final InputValidator myValidator;
        private final @NlsContexts.DetailedDescription String myComment;

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator, String @NlsContexts.Button @NotNull [] options, int defaultOption, @NlsContexts.DetailedDescription @Nullable String comment) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(0);
            }
            super(project, true);
            this.myComment = comment;
            this.myValidator = validator;
            this._init(title, message, options, defaultOption, -1, icon, (DoNotAskOption)null, null);
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator, String @NlsContexts.Button @NotNull [] options, int defaultOption) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(1);
            }
            this(project, message, title, icon, initialValue, validator, options, defaultOption, null);
        }

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
            this(project, message, title, icon, initialValue, validator, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0);
        }

        public InputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
            if (parent == null) {
                InputDialog.$$$reportNull$$$0(2);
            }
            super(null, parent, message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, -1, 0, icon, null, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NonNls String initialValue, @Nullable InputValidator validator) {
            super(null, null, message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0, -1, icon, null, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        private void enableOkAction() {
            this.getOKAction().setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myField.getText().trim()));
        }

        @Override
        protected Action @NotNull [] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                ExitActionType exitType;
                String option = this.myOptions[i];
                final int exitCode = i;
                ExitActionType exitActionType = exitType = this.myExitActionTypes.length > i ? this.myExitActionTypes[i] : ExitActionType.UNDEFINED;
                if (i == 0) {
                    actions[0] = this.getOKAction();
                    actions[0].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(@NotNull DocumentEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            String text = myField.getText().trim();
                            actions[exitCode].setEnabled(myValidator == null || myValidator.checkInput(text));
                            if (myValidator instanceof InputValidatorEx) {
                                this.setErrorText(((InputValidatorEx)myValidator).getErrorText(text), myField);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/ui/Messages$InputDialog$1", "textChanged"));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode, exitType);
                    }
                };
            }
            if (actions == null) {
                InputDialog.$$$reportNull$$$0(3);
            }
            return actions;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myField.getText().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel2 = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            panel2.add((Component)messagePanel, "Center");
            if (this.myComment != null) {
                return UI.PanelFactory.panel(panel2).withComment(this.myComment).createPanel();
            }
            return panel2;
        }

        @Override
        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "South");
            JPanel jPanel = messagePanel;
            if (jPanel == null) {
                InputDialog.$$$reportNull$$$0(4);
            }
            return jPanel;
        }

        protected JComponent createScrollableTextComponent() {
            return this.myField;
        }

        protected JComponent createTextComponent() {
            JComponent textComponent;
            if (BasicHTML.isHTMLString(this.myMessage)) {
                textComponent = this.createMessageComponent(this.myMessage);
            } else {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setUI(new MultiLineLabelUI());
                textComponent = textLabel;
            }
            textComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 20));
            return textComponent;
        }

        public JTextComponent getTextField() {
            return this.myField;
        }

        protected JTextComponent createTextFieldComponent() {
            JTextField field = new JTextField(30);
            field.setMargin((Insets)JBInsets.create((int)0, (int)5));
            return field;
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        @NlsSafe
        public String getInputString() {
            return this.getExitCode() == 0 ? this.myField.getText().trim() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessagePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static @interface YesNoCancelResult {
    }

    public static @interface OkCancelResult {
    }

    public static @interface YesNoResult {
    }
}

