/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DimensionService", storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED)})
@Service(value={Service.Level.APP})
public final class DimensionService
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DimensionService.class);
    private final Map<String, Point> myKeyToLocation = new LinkedHashMap<String, Point>();
    private final Map<String, Dimension> myKeToSize = new LinkedHashMap<String, Dimension>();
    private final ObjectIntMap<String> myKeyToExtendedState = new ObjectIntHashMap();
    @NonNls
    private static final String EXTENDED_STATE = "extendedState";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String ELEMENT_LOCATION = "location";
    @NonNls
    private static final String ELEMENT_SIZE = "size";
    @NonNls
    private static final String ATTRIBUTE_X = "x";
    @NonNls
    private static final String ATTRIBUTE_Y = "y";
    @NonNls
    private static final String ATTRIBUTE_WIDTH = "width";
    @NonNls
    private static final String ATTRIBUTE_HEIGHT = "height";

    public static DimensionService getInstance() {
        return (DimensionService)((Object)ApplicationManager.getApplication().getService(DimensionService.class));
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public synchronized Point getLocation(String key) {
        return this.getLocation(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Point getLocation(@NotNull String key, @Nullable Project project) {
        Point point;
        if (key == null) {
            DimensionService.$$$reportNull$$$0(0);
        }
        Point point2 = point = project == null ? null : WindowStateService.getInstance(project).getLocation(key);
        if (point != null) {
            return point;
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        point = this.myKeyToLocation.get(pair.first);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x / scale, (float)point.y / scale);
        }
        if (point != null && !ScreenUtil.getScreenRectangle((Point)point).contains(point)) {
            point = null;
        }
        return point;
    }

    @Deprecated(forRemoval=true)
    public synchronized void setLocation(String key, Point point) {
        this.setLocation(key, point, DimensionService.guessProject());
    }

    public synchronized void setLocation(@NotNull String key, Point point, @Nullable Project project) {
        if (key == null) {
            DimensionService.$$$reportNull$$$0(1);
        }
        DimensionService.getWindowStateService(project).putLocation(key, point);
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x * scale, (float)point.y * scale);
            this.myKeyToLocation.put((String)pair.first, point);
        } else {
            this.myKeyToLocation.remove(key);
        }
        this.incModificationCount();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key) {
        if (key == null) {
            DimensionService.$$$reportNull$$$0(2);
        }
        return this.getSize(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key, @Nullable Project project) {
        Dimension size;
        if (key == null) {
            DimensionService.$$$reportNull$$$0(3);
        }
        Dimension dimension = size = project == null ? null : WindowStateService.getInstance(project).getSize(key);
        if (size != null) {
            return size;
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        size = this.myKeToSize.get(pair.first);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width / scale, (float)size.height / scale);
        }
        return size;
    }

    @Deprecated(forRemoval=true)
    public synchronized void setSize(@NotNull @NonNls String key, Dimension size) {
        if (key == null) {
            DimensionService.$$$reportNull$$$0(4);
        }
        this.setSize(key, size, DimensionService.guessProject());
    }

    public synchronized void setSize(@NotNull @NonNls String key, Dimension size, @Nullable Project project) {
        Project projectIfValid;
        if (key == null) {
            DimensionService.$$$reportNull$$$0(5);
        }
        if ((projectIfValid = project) != null && projectIfValid.isDisposed()) {
            projectIfValid = null;
        }
        DimensionService.getWindowStateService(projectIfValid).putSize(key, size);
        Pair<String, Float> pair = DimensionService.keyPair(key, projectIfValid);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width * scale, (float)size.height * scale);
            this.myKeToSize.put((String)pair.first, size);
        } else {
            this.myKeToSize.remove(pair.first);
        }
        this.incModificationCount();
    }

    public Element getState() {
        Element e;
        Element element = new Element(STATE);
        for (Map.Entry<String, Point> entry : this.myKeyToLocation.entrySet()) {
            Point point = entry.getValue();
            LOG.assertTrue(point != null);
            e = new Element(ELEMENT_LOCATION);
            e.setAttribute(KEY, entry.getKey());
            e.setAttribute(ATTRIBUTE_X, String.valueOf(point.x));
            e.setAttribute(ATTRIBUTE_Y, String.valueOf(point.y));
            element.addContent(e);
        }
        for (Map.Entry<String, Cloneable> entry : this.myKeToSize.entrySet()) {
            Dimension size = (Dimension)entry.getValue();
            LOG.assertTrue(size != null);
            e = new Element(ELEMENT_SIZE);
            e.setAttribute(KEY, entry.getKey());
            e.setAttribute(ATTRIBUTE_WIDTH, String.valueOf(size.width));
            e.setAttribute(ATTRIBUTE_HEIGHT, String.valueOf(size.height));
            element.addContent(e);
        }
        for (ObjectIntMap.Entry entry : this.myKeyToExtendedState.entries()) {
            Element e2 = new Element(EXTENDED_STATE);
            e2.setAttribute(KEY, (String)entry.getKey());
            e2.setAttribute(STATE, Integer.toString(entry.getValue()));
            element.addContent(e2);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            DimensionService.$$$reportNull$$$0(6);
        }
        this.myKeyToLocation.clear();
        this.myKeToSize.clear();
        this.myKeyToExtendedState.clear();
        for (Element e : element.getChildren()) {
            if (ELEMENT_LOCATION.equals(e.getName())) {
                try {
                    this.myKeyToLocation.put(e.getAttributeValue(KEY), new Point(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_X)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_Y))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (ELEMENT_SIZE.equals(e.getName())) {
                try {
                    this.myKeToSize.put(e.getAttributeValue(KEY), new Dimension(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_WIDTH)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_HEIGHT))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!EXTENDED_STATE.equals(e.getName())) continue;
            try {
                this.myKeyToExtendedState.put((Object)e.getAttributeValue(KEY), Integer.parseInt(e.getAttributeValue(STATE)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Deprecated
    @Nullable
    private static Project guessProject() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        return openProjects.length == 1 ? openProjects[0] : null;
    }

    @NotNull
    private static Pair<String, Float> keyPair(String key, @Nullable Project project) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (env.isHeadlessInstance()) {
            return new Pair((Object)(key + ".headless"), (Object)Float.valueOf(1.0f));
        }
        JFrame frame = null;
        Component owner2 = IdeFocusManager.findInstance().getFocusOwner();
        if (owner2 != null) {
            frame = (JFrame)ComponentUtil.getParentOfType(JFrame.class, (Component)owner2);
        }
        if (frame == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        if (project != null && (frame == null || frame instanceof IdeFrame && project != ((IdeFrame)frame).getProject())) {
            frame = WindowManager.getInstance().getFrame(project);
        }
        Rectangle screen = new Rectangle(0, 0, 0, 0);
        GraphicsDevice gd = null;
        if (frame != null) {
            Point topLeft = frame.getLocation();
            float centerX = (float)topLeft.x + (float)frame.getWidth() / 2.0f;
            float centerY = (float)topLeft.y + (float)frame.getHeight() / 2.0f;
            for (GraphicsDevice device : env.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (!bounds.contains(centerX, centerY)) continue;
                screen = bounds;
                gd = device;
                break;
            }
        }
        if (gd == null) {
            gd = env.getDefaultScreenDevice();
            screen = gd.getDefaultConfiguration().getBounds();
        }
        float scale = 1.0f;
        if (JreHiDpiUtil.isJreHiDPIEnabled()) {
            scale = JBUIScale.sysScale((GraphicsConfiguration)gd.getDefaultConfiguration());
            screen.setBounds((int)Math.floor((float)screen.x * scale), (int)Math.floor((float)screen.y * scale), (int)Math.ceil((float)screen.width * scale), (int)Math.ceil((float)screen.height * scale));
        }
        String realKey = key + "." + screen.x + "." + screen.y + "." + screen.width + "." + screen.height;
        if (JBUI.isPixHiDPI((GraphicsConfiguration)gd.getDefaultConfiguration())) {
            int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)gd.getDefaultConfiguration()));
            realKey = realKey + "@" + dpi + "dpi";
        }
        return new Pair((Object)realKey, (Object)Float.valueOf(scale));
    }

    @NotNull
    private static WindowStateService getWindowStateService(@Nullable Project project) {
        WindowStateService windowStateService = project == null ? WindowStateService.getInstance() : WindowStateService.getInstance(project);
        if (windowStateService == null) {
            DimensionService.$$$reportNull$$$0(7);
        }
        return windowStateService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/DimensionService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/DimensionService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowStateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

