/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnOffButton
extends JToggleButton {
    @NlsContexts.Button
    private String myOnText = IdeBundle.message("ui.button.on", new Object[0]);
    @NlsContexts.Button
    private String myOffText = IdeBundle.message("ui.button.off", new Object[0]);
    @NotNull
    private Insets myIpad = JBUI.insets((int)3);

    public OnOffButton() {
        this.setBorder(null);
        this.setOpaque(false);
    }

    @NlsContexts.Button
    public String getOnText() {
        return this.myOnText;
    }

    public void setOnText(@NlsContexts.Button String onText) {
        this.myOnText = onText;
    }

    @NlsContexts.Button
    public String getOffText() {
        return this.myOffText;
    }

    public void setOffText(@NlsContexts.Button String offText) {
        this.myOffText = offText;
    }

    @Override
    public String getUIClassID() {
        return "OnOffButtonUI";
    }

    @Override
    public void updateUI() {
        Object uiClassName = UIManager.get(this.getUIClassID());
        this.setUI(uiClassName == null ? DefaultOnOffButtonUI.createUI(this) : UIManager.getUI(this));
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            OnOffButton.$$$reportNull$$$0(0);
        }
        this.myIpad = ipad;
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            OnOffButton.$$$reportNull$$$0(1);
        }
        return insets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipad";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/OnOffButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/OnOffButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpad";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setIpad";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class DefaultOnOffButtonUI
    extends BasicToggleButtonUI {
        private static final Color BORDER_COLOR = JBColor.namedColor((String)"ToggleButton.borderColor", (Color)new JBColor((Color)Gray._192, (Color)Gray._80));
        private static final Color BUTTON_COLOR = JBColor.namedColor((String)"ToggleButton.buttonColor", (Color)new JBColor((Color)Gray._200, (Color)Gray._100));
        private static final Color ON_BACKGROUND = JBColor.namedColor((String)"ToggleButton.onBackground", (Color)new JBColor(new Color(74, 146, 73), new Color(77, 105, 76)));
        private static final Color ON_FOREGROUND = JBColor.namedColor((String)"ToggleButton.onForeground", (Color)JBColor.lazy(() -> UIUtil.getListForeground((boolean)true, (boolean)true)));
        private static final Color OFF_BACKGROUND = JBColor.namedColor((String)"ToggleButton.offBackground", (Color)JBColor.lazy(() -> UIUtil.getPanelBackground()));
        private static final Color OFF_FOREGROUND = JBColor.namedColor((String)"ToggleButton.offForeground", (Color)JBColor.lazy(() -> UIUtil.getLabelDisabledForeground()));

        private DefaultOnOffButtonUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            c.setAlignmentY(0.5f);
            return new DefaultOnOffButtonUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            OnOffButton button2 = (OnOffButton)c;
            Insets ipad = button2.getIpad();
            int textWidth = Math.max(DefaultOnOffButtonUI.getTextWidth(button2, button2.getOnText()), DefaultOnOffButtonUI.getTextWidth(button2, button2.getOffText()));
            int fmHeight = c.getFontMetrics(c.getFont()).getHeight();
            int widthCorrection = (int)((double)JBUIScale.scale((int)3) * 0.5);
            int w = textWidth + (int)((double)fmHeight * 1.25) + widthCorrection + ipad.left + ipad.right;
            int h = fmHeight + ipad.top + ipad.bottom;
            return new Dimension(w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, JComponent c) {
            if (!(c instanceof OnOffButton)) {
                return;
            }
            OnOffButton button2 = (OnOffButton)c;
            int toggleArc = JBUIScale.scale((int)3);
            int buttonArc = JBUIScale.scale((int)5);
            Dimension size = button2.getSize();
            Insets ipad = button2.getIpad();
            int w = size.width - (ipad.left + ipad.right);
            int h = size.height - (ipad.top + ipad.bottom);
            if (h % 2 == 1) {
                --h;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int xOff = (button2.getWidth() - w) / 2;
                int yOff = (button2.getHeight() - h) / 2;
                g2.translate(xOff, yOff);
                boolean selected2 = button2.isSelected();
                g2.setColor(selected2 ? ON_BACKGROUND : OFF_BACKGROUND);
                g2.fillRoundRect(0, 0, w, h, buttonArc, buttonArc);
                int knobWidth = w - SwingUtilities.computeStringWidth(g2.getFontMetrics(), button2.getOffText()) - JBUIScale.scale((int)2);
                knobWidth = Math.min(knobWidth, h);
                int textAscent = g2.getFontMetrics().getAscent();
                Rectangle viewRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                Rectangle iconRect = new Rectangle();
                g2.setColor(BUTTON_COLOR);
                if (selected2) {
                    g2.fillRoundRect(w - knobWidth, 0, knobWidth, h, toggleArc, toggleArc);
                    if (button2.getOnText() != null) {
                        viewRect.setBounds(0, 0, w - knobWidth, h);
                        SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button2.getOnText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                        g2.setColor(ON_FOREGROUND);
                        g2.drawString(button2.getOnText(), textRect.x, textRect.y + textAscent);
                    }
                } else {
                    g2.fillRoundRect(0, 0, knobWidth, h, toggleArc, toggleArc);
                    if (button2.getOffText() != null) {
                        viewRect.setBounds(knobWidth, 0, w - knobWidth, h);
                        SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button2.getOffText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                        g2.setColor(OFF_FOREGROUND);
                        g2.drawString(button2.getOffText(), textRect.x, textRect.y + textAscent);
                    }
                }
                g2.setColor(BORDER_COLOR);
                g2.drawRoundRect(0, 0, w, h, buttonArc, buttonArc);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        private static int getTextWidth(OnOffButton button2, @Nullable String text) {
            if (text == null) {
                return 0;
            }
            FontMetrics fm = button2.getFontMetrics(button2.getFont());
            return fm.stringWidth(text.toUpperCase(Locale.getDefault()));
        }
    }
}

