/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.WideSelectionListCache;
import com.intellij.ui.speedSearch.FilteringListModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000e\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J&\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/ui/components/WideSelectionListCache;", "", "list", "Ljavax/swing/JList;", "<init>", "(Ljavax/swing/JList;)V", "modelChanged", "", "preferredSizeCache", "", "Ljava/awt/Dimension;", "getPreferredSizeCache", "()Ljava/util/Map;", "listDataListener", "com/intellij/ui/components/WideSelectionListCache$listDataListener$1", "Lcom/intellij/ui/components/WideSelectionListCache$listDataListener$1;", "modelChangeListener", "Ljava/beans/PropertyChangeListener;", "installListeners", "", "uninstallListeners", "getCachedPreferredSizeOrCalculate", "value", "useCache", "supplier", "Lkotlin/Function0;", "clear", "purgeIfNeeded", "installListDataListener", "model", "Ljavax/swing/ListModel;", "uninstallListDataListener", "originalModel", "getOriginalModel", "(Ljavax/swing/ListModel;)Ljavax/swing/ListModel;", "intellij.platform.ide"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nWideSelectionListCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WideSelectionListCache.kt\ncom/intellij/ui/components/WideSelectionListCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,119:1\n383#2,7:120\n*S KotlinDebug\n*F\n+ 1 WideSelectionListCache.kt\ncom/intellij/ui/components/WideSelectionListCache\n*L\n75#1:120,7\n*E\n"})
public final class WideSelectionListCache {
    @NotNull
    private final JList<?> list;
    private boolean modelChanged;
    @VisibleForTesting
    @NotNull
    private final Map<Object, Dimension> preferredSizeCache;
    @NotNull
    private final listDataListener.1 listDataListener;
    @NotNull
    private final PropertyChangeListener modelChangeListener;

    public WideSelectionListCache(@NotNull JList<?> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
        this.preferredSizeCache = new IdentityHashMap();
        this.listDataListener = new ListDataListener(this){
            final /* synthetic */ WideSelectionListCache this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalAdded(ListDataEvent e) {
                WideSelectionListCache.access$purgeIfNeeded(this.this$0);
            }

            public void intervalRemoved(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WideSelectionListCache.access$setModelChanged$p(this.this$0, true);
            }

            public void contentsChanged(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WideSelectionListCache.access$setModelChanged$p(this.this$0, true);
                WideSelectionListCache.access$purgeIfNeeded(this.this$0);
            }
        };
        this.modelChangeListener = arg_0 -> WideSelectionListCache.modelChangeListener$lambda$0(this, arg_0);
    }

    @NotNull
    public final Map<Object, Dimension> getPreferredSizeCache() {
        return this.preferredSizeCache;
    }

    public final void installListeners() {
        this.list.addPropertyChangeListener("model", this.modelChangeListener);
        this.installListDataListener(this.list.getModel());
    }

    public final void uninstallListeners() {
        this.list.removePropertyChangeListener("model", this.modelChangeListener);
        this.uninstallListDataListener(this.list.getModel());
        this.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Dimension getCachedPreferredSizeOrCalculate(@Nullable Object value2, boolean useCache, @NotNull Function0<? extends Dimension> supplier) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        if (!useCache) {
            this.clear();
            return (Dimension)supplier.invoke();
        }
        this.purgeIfNeeded();
        if (value2 == null) {
            return (Dimension)supplier.invoke();
        }
        Map<Object, Dimension> map = this.preferredSizeCache;
        Object key$iv = value2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object answer$iv = supplier.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Dimension)object;
    }

    private final void clear() {
        this.modelChanged = false;
        this.preferredSizeCache.clear();
    }

    private final void purgeIfNeeded() {
        if (!this.modelChanged) {
            return;
        }
        this.modelChanged = false;
        ListModel<?> model = this.getOriginalModel(this.list.getModel());
        if (model == null) {
            this.preferredSizeCache.clear();
            return;
        }
        Set<?> existingValues = Collections.newSetFromMap(new IdentityHashMap());
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            existingValues.add(model.getElementAt(i));
        }
        Collection collection = this.preferredSizeCache.keySet();
        Intrinsics.checkNotNull(existingValues);
        Collection collection2 = existingValues;
        TypeIntrinsics.asMutableCollection((Object)collection).retainAll(collection2);
    }

    private final void installListDataListener(ListModel<?> model) {
        block0: {
            ListModel<?> listModel = this.getOriginalModel(model);
            if (listModel == null) break block0;
            listModel.addListDataListener(this.listDataListener);
        }
    }

    private final void uninstallListDataListener(ListModel<?> model) {
        block0: {
            ListModel<?> listModel = this.getOriginalModel(model);
            if (listModel == null) break block0;
            listModel.removeListDataListener(this.listDataListener);
        }
    }

    private final ListModel<?> getOriginalModel(ListModel<?> $this$originalModel) {
        ListModel<?> listModel = $this$originalModel;
        return listModel == null ? null : (listModel instanceof FilteringListModel ? ((FilteringListModel)$this$originalModel).getOriginalModel() : $this$originalModel);
    }

    private static final void modelChangeListener$lambda$0(WideSelectionListCache this$0, PropertyChangeEvent evt) {
        this$0.uninstallListDataListener((ListModel)evt.getOldValue());
        this$0.installListDataListener((ListModel)evt.getNewValue());
        this$0.clear();
    }

    public static final /* synthetic */ void access$purgeIfNeeded(WideSelectionListCache $this) {
        $this.purgeIfNeeded();
    }

    public static final /* synthetic */ void access$setModelChanged$p(WideSelectionListCache $this, boolean bl) {
        $this.modelChanged = bl;
    }
}

