/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.breadcrumbs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StickyLineInfo
extends Record {
    private final int textOffset;
    private final int endOffset;
    @Nullable
    private final String debugText;

    public StickyLineInfo(@NotNull TextRange textRange) {
        if (textRange == null) {
            StickyLineInfo.$$$reportNull$$$0(0);
        }
        this(textRange.getStartOffset(), textRange.getEndOffset(), null);
    }

    public StickyLineInfo(@NotNull PsiElement element) {
        if (element == null) {
            StickyLineInfo.$$$reportNull$$$0(1);
        }
        this(element.getTextOffset(), element.getTextRange().getEndOffset(), StickyLineInfo.debugTextPsiElement(element));
    }

    public StickyLineInfo(int textOffset, int endOffset, @Nullable String debugText) {
        if (textOffset >= endOffset) {
            throw new IllegalArgumentException(String.format("sticky line endOffset %s should be less than startOffset %s", textOffset, endOffset));
        }
        this.textOffset = textOffset;
        this.endOffset = endOffset;
        this.debugText = debugText;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StickyLineInfo)) {
            return false;
        }
        StickyLineInfo info = (StickyLineInfo)other;
        return this.endOffset == info.endOffset && this.textOffset == info.textOffset;
    }

    @Override
    public int hashCode() {
        return this.textOffset + 31 * this.endOffset;
    }

    @Nullable
    private static String debugTextPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StickyLineInfo.$$$reportNull$$$0(2);
        }
        if (Registry.is((String)"editor.show.sticky.lines.debug")) {
            return element.toString();
        }
        return null;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{StickyLineInfo.class, "textOffset;endOffset;debugText", "textOffset", "endOffset", "debugText"}, this);
    }

    public int textOffset() {
        return this.textOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    @Nullable
    public String debugText() {
        return this.debugText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/breadcrumbs/StickyLineInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "debugTextPsiElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

