/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchSupply {
    @Deprecated(forRemoval=true)
    public static final String SEARCH_QUERY_KEY = "SEARCH_QUERY";
    private static final Key<SpeedSearchSupply> SPEED_SEARCH_COMPONENT_MARKER = Key.create((String)"SPEED_SEARCH_COMPONENT_MARKER");
    @Deprecated(forRemoval=true)
    public static final DataKey<String> SPEED_SEARCH_CURRENT_QUERY = PlatformDataKeys.SPEED_SEARCH_TEXT;
    public static final String ENTERED_PREFIX_PROPERTY_NAME = "enteredPrefix";
    protected static final JBColor BACKGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.background", (Color)JBColor.namedColor((String)"Editor.SearchField.background", (Color)UIUtil.getTextFieldBackground()));
    protected static final JBColor BORDER_COLOR = JBColor.namedColor((String)"SpeedSearch.borderColor", (Color)JBColor.namedColor((String)"Editor.Toolbar.borderColor", (Color)JBColor.LIGHT_GRAY));
    protected static final JBColor FOREGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.foreground", (Color)JBColor.namedColor((String)"TextField.foreground", (Color)UIUtil.getToolTipForeground()));
    protected static final JBColor ERROR_FOREGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.errorForeground", (Color)JBColor.namedColor((String)"SearchField.errorForeground", (Color)JBColor.RED));

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(0);
        }
        return SpeedSearchSupply.getSupply(component, false);
    }

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component, boolean evenIfInactive) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(1);
        }
        SpeedSearchSupply speedSearch = (SpeedSearchSupply)component.getClientProperty(SPEED_SEARCH_COMPONENT_MARKER);
        if (evenIfInactive) {
            return speedSearch;
        }
        return speedSearch != null && speedSearch.isPopupActive() ? speedSearch : null;
    }

    public boolean supportsNavigation() {
        return false;
    }

    @Nullable
    public abstract Iterable<TextRange> matchingFragments(@NotNull String var1);

    public abstract void refreshSelection();

    public abstract boolean isPopupActive();

    @Nullable
    public String getEnteredPrefix() {
        return null;
    }

    protected void installSupplyTo(@NotNull JComponent component) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(2);
        }
        this.installSupplyTo(component, true);
    }

    public void installSupplyTo(@NotNull JComponent component, boolean withRepaint) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(3);
        }
        component.putClientProperty(SPEED_SEARCH_COMPONENT_MARKER, this);
        if (withRepaint) {
            this.addChangeListener(evt -> component.repaint());
        }
    }

    public abstract void addChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void removeChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void findAndSelectElement(@NotNull String var1);

    public boolean isObjectFilteredOut(Object o) {
        return false;
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    @ApiStatus.Internal
    public void selectTextRange(int begin, int length) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearchSupply";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSupply";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installSupplyTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    @ApiStatus.Experimental
    public static interface SpeedSearchLocator {
        @Nullable
        public RelativeRectangle getSizeAndLocation(JComponent var1);
    }
}

