/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.Queryable;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.tabs.TabInfoIconHolder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010%\n\u0002\b\u0007\u0018\u0000 \u00a3\u00012\u00020\u00012\u00020\u0002:\u0006\u00a3\u0001\u00a4\u0001\u00a5\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010m\u001a\u00020\u00002\u000b\u0010n\u001a\u00070\u001d\u00a2\u0006\u0002\boJ\b\u0010p\u001a\u000206H\u0007J\b\u0010q\u001a\u00020UH\u0002J\u000e\u0010r\u001a\u00020\u00002\u0006\u0010s\u001a\u00020;J\u001b\u0010t\u001a\u00020\u00002\u000b\u0010u\u001a\u00070\u001d\u00a2\u0006\u0002\bv2\u0006\u0010w\u001a\u00020UJ\u0010\u0010x\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010y\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010z\u001a\u00020{J\n\u0010~\u001a\u0004\u0018\u00010\u001dH\u0016J\u0011\u0010\u007f\u001a\u00020\u00002\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0081\u0001\u001a\u00020\u00002\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0004J \u0010\u0082\u0001\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\r\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001eJ\u0011\u0010\u0083\u0001\u001a\u00020\u00002\b\u0010z\u001a\u0004\u0018\u00010\u0004J\u0011\u0010\u0084\u0001\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\u0007\u0010\u0085\u0001\u001a\u00020\u0004J\u0011\u0010\u0086\u0001\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0087\u0001\u001a\u00020\u00002\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0011\u0010\u0089\u0001\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u000eJ\u0011\u0010\u008a\u0001\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000104J\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001J\b\u0010\u008d\u0001\u001a\u00030\u008c\u0001J\u000b\u0010\u008e\u0001\u001a\u00020\u001dH\u0096\u0080\u0004J\u0007\u0010\u008f\u0001\u001a\u000204J\b\u0010\u0090\u0001\u001a\u00030\u008c\u0001J\u0012\u0010\u0091\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0092\u0001\u001a\u000206J\u0012\u0010\u0093\u0001\u001a\u00020\u00002\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010LJ\u001f\u0010\u0095\u0001\u001a\u00030\u008c\u00012\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010L2\b\u0010w\u001a\u0004\u0018\u00010PH\u0007J\u0011\u0010\u0096\u0001\u001a\u00020\u00002\b\u0010w\u001a\u0004\u0018\u00010PJ\n\u0010\u0097\u0001\u001a\u00030\u008c\u0001H\u0002J\b\u0010\u0098\u0001\u001a\u00030\u008c\u0001J\u0016\u0010\u0099\u0001\u001a\u00020\u00002\r\u0010n\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\bHJ\u0012\u0010\u009a\u0001\u001a\u00020\u00002\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010LJ\u0013\u0010\u009c\u0001\u001a\u00020\u00002\b\u0010[\u001a\u0004\u0018\u00010\u0001H\u0007J$\u0010\u009d\u0001\u001a\u00030\u008c\u00012\u0018\u0010\u009e\u0001\u001a\u0013\u0012\u0006\b\u0000\u0012\u00020\u001d\u0012\u0006\b\u0000\u0012\u00020\u001d0\u009f\u0001H\u0016J\u0012\u0010\u00a0\u0001\u001a\u00020\u00002\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\\J\u0007\u0010\u00a2\u0001\u001a\u00020;R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\r\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\"\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\bR\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\b\"\u0004\b+\u0010\u0006R\"\u0010,\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0011R\"\u0010.\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0011R\"\u00100\u001a\u0004\u0018\u00010\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001e\u0010<\u001a\u00020;2\u0006\u0010\r\u001a\u00020;@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R$\u0010?\u001a\u00020;2\u0006\u0010>\u001a\u00020;@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010=\"\u0004\b@\u0010AR\"\u0010B\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\bR\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR,\u0010I\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\bH2\r\u0010\r\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\bH@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00102R\u000e\u0010K\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010M\u001a\u0004\u0018\u00010L2\b\u0010\r\u001a\u0004\u0018\u00010L@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR$\u0010Q\u001a\u0004\u0018\u00010P2\b\u0010\r\u001a\u0004\u0018\u00010P8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0010\u0010T\u001a\u0004\u0018\u00010UX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010W\u001a\u00020;2\u0006\u0010V\u001a\u00020;@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010=\"\u0004\bX\u0010AR\"\u0010Y\u001a\u0004\u0018\u00010L2\b\u0010\r\u001a\u0004\u0018\u00010L@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010OR\u0010\u0010[\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010]\u001a\u0004\u0018\u00010\\2\b\u0010\r\u001a\u0004\u0018\u00010\\@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u001c\u0010`\u001a\u0004\u0018\u00010aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u0016\u0010f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010gX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010h\u001a\u0004\u0018\u00010\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u0011\u0010|\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b|\u0010=R\u0016\u0010n\u001a\u00070\u001d\u00a2\u0006\u0002\bo8F\u00a2\u0006\u0006\u001a\u0004\b}\u00102\u00a8\u0006\u00a6\u0001"}, d2={"Lcom/intellij/ui/tabs/TabInfo;", "Lcom/intellij/openapi/ui/Queryable;", "Lcom/intellij/ui/PlaceProvider;", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "setComponent", "tabLabel", "Lcom/intellij/ui/tabs/impl/TabLabel;", "preferredFocusableComponent", "value", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "group", "getGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "changeSupport", "Ljava/beans/PropertyChangeSupport;", "getChangeSupport", "()Ljava/beans/PropertyChangeSupport;", "iconHolder", "Lcom/intellij/ui/tabs/TabInfoIconHolder;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "place", "", "Lorg/jetbrains/annotations/NonNls;", "", "object", "getObject", "()Ljava/lang/Object;", "sideComponent", "getSideComponent", "foreSideComponent", "getForeSideComponent", "lastFocusOwnerRef", "Ljava/lang/ref/Reference;", "lastFocusOwner", "getLastFocusOwner", "setLastFocusOwner", "tabLabelActions", "getTabLabelActions", "tabPaneActions", "getTabPaneActions", "tabActionPlace", "getTabActionPlace", "()Ljava/lang/String;", "alertIcon", "Lcom/intellij/ui/content/AlertIcon;", "blinkCount", "", "getBlinkCount", "()I", "setBlinkCount", "(I)V", "", "isAlertRequested", "()Z", "hidden", "isHidden", "setHidden", "(Z)V", "actionsContextComponent", "getActionsContextComponent", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "getColoredText", "()Lcom/intellij/ui/SimpleColoredText;", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "tooltipText", "getTooltipText", "defaultStyle", "Ljava/awt/Color;", "defaultForeground", "getDefaultForeground", "()Ljava/awt/Color;", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editorAttributes", "getEditorAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "defaultAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "enabled", "isEnabled", "setEnabled", "tabColor", "getTabColor", "queryable", "Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "dragOutDelegate", "getDragOutDelegate", "()Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "dragDelegate", "Lcom/intellij/ui/tabs/TabInfo$DragDelegate;", "getDragDelegate", "()Lcom/intellij/ui/tabs/TabInfo$DragDelegate;", "setDragDelegate", "(Lcom/intellij/ui/tabs/TabInfo$DragDelegate;)V", "previousSelectionRef", "Ljava/lang/ref/WeakReference;", "previousSelection", "getPreviousSelection", "()Lcom/intellij/ui/tabs/TabInfo;", "setPreviousSelection", "(Lcom/intellij/ui/tabs/TabInfo;)V", "setText", "text", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "getFontSize", "getDefaultAttributes", "clearText", "invalidate", "append", "fragment", "Lcom/intellij/openapi/util/NlsContexts$Label;", "attributes", "setIcon", "setIconHolder", "c", "Ljava/awt/Component;", "isPinned", "getText", "getPlace", "setSideComponent", "comp", "setForeSideComponent", "setActions", "setActionsContextComponent", "setObject", "getPreferredFocusableComponent", "setPreferredFocusableComponent", "setTabLabelActions", "tabActions", "setTabPaneActions", "setAlertIcon", "fireAlert", "", "stopAlerting", "toString", "getAlertIcon", "resetAlertRequest", "setDefaultStyle", "style", "setDefaultForeground", "foregroundColor", "setDefaultForegroundAndAttributes", "setDefaultAttributes", "update", "revalidate", "setTooltipText", "setTabColor", "color", "setTestableUi", "putInfo", "info", "", "setDragOutDelegate", "delegate", "canBeDraggedOut", "Companion", "DragDelegate", "DragOutDelegate", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nTabInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabInfo.kt\ncom/intellij/ui/tabs/TabInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1#2:398\n*E\n"})
public final class TabInfo
implements Queryable,
PlaceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private JComponent component;
    @JvmField
    @Nullable
    public TabLabel tabLabel;
    @Nullable
    private JComponent preferredFocusableComponent;
    @Nullable
    private ActionGroup group;
    @NotNull
    private final PropertyChangeSupport changeSupport;
    @NotNull
    private TabInfoIconHolder iconHolder;
    @Nullable
    private String place;
    @Nullable
    private Object object;
    @Nullable
    private JComponent sideComponent;
    @Nullable
    private JComponent foreSideComponent;
    @Nullable
    private Reference<JComponent> lastFocusOwnerRef;
    @Nullable
    private ActionGroup tabLabelActions;
    @Nullable
    private ActionGroup tabPaneActions;
    @Nullable
    private String tabActionPlace;
    @Nullable
    private AlertIcon alertIcon;
    private int blinkCount;
    private boolean isAlertRequested;
    private boolean isHidden;
    @Nullable
    private JComponent actionsContextComponent;
    @NotNull
    private final SimpleColoredText coloredText;
    @Nullable
    private String tooltipText;
    private int defaultStyle;
    @Nullable
    private Color defaultForeground;
    @ApiStatus.Internal
    @Nullable
    private TextAttributes editorAttributes;
    @Nullable
    private SimpleTextAttributes defaultAttributes;
    private boolean isEnabled;
    @Nullable
    private Color tabColor;
    @Nullable
    private Queryable queryable;
    @Nullable
    private DragOutDelegate dragOutDelegate;
    @Nullable
    private DragDelegate dragDelegate;
    @Nullable
    private WeakReference<TabInfo> previousSelectionRef;
    @NotNull
    public static final String ACTION_GROUP = "actionGroup";
    @NotNull
    public static final String ICON = "icon";
    @NotNull
    public static final String TAB_COLOR = "color";
    @NotNull
    public static final String COMPONENT = "component";
    @NotNull
    public static final String TEXT = "text";
    @NotNull
    public static final String TAB_ACTION_GROUP = "tabActionGroup";
    @NotNull
    public static final String ALERT_ICON = "alertIcon";
    @NotNull
    public static final String ALERT_STATUS = "alertStatus";
    @NotNull
    public static final String HIDDEN = "hidden";
    @NotNull
    public static final String ENABLED = "enabled";
    @NotNull
    private static final AlertIcon DEFAULT_ALERT_ICON = new AlertIcon(AllIcons.Nodes.TabAlert, 0, -JBUI.scale((int)6));

    public TabInfo(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)COMPONENT);
        this.preferredFocusableComponent = this.component = component;
        this.changeSupport = new PropertyChangeSupport(this);
        this.iconHolder = TabInfoIconHolder.Companion.default(this);
        this.coloredText = new SimpleColoredText();
        this.defaultStyle = -1;
        this.isEnabled = true;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void setComponent(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
        this.component = jComponent;
    }

    @Nullable
    public final ActionGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    @Nullable
    public final Icon getIcon() {
        return this.iconHolder.getIcon();
    }

    @Nullable
    public final Object getObject() {
        return this.object;
    }

    @Nullable
    public final JComponent getSideComponent() {
        return this.sideComponent;
    }

    @Nullable
    public final JComponent getForeSideComponent() {
        return this.foreSideComponent;
    }

    @Nullable
    public final JComponent getLastFocusOwner() {
        Reference<JComponent> reference = this.lastFocusOwnerRef;
        return reference != null ? reference.get() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastFocusOwner(@Nullable JComponent value2) {
        WeakReference<void> weakReference;
        TabInfo tabInfo = this;
        JComponent jComponent = value2;
        if (jComponent != null) {
            void it;
            JComponent jComponent2 = jComponent;
            TabInfo tabInfo2 = tabInfo;
            boolean bl = false;
            weakReference = new WeakReference<void>(it);
            tabInfo = tabInfo2;
        } else {
            weakReference = null;
        }
        tabInfo.lastFocusOwnerRef = weakReference;
    }

    @Nullable
    public final ActionGroup getTabLabelActions() {
        return this.tabLabelActions;
    }

    @Nullable
    public final ActionGroup getTabPaneActions() {
        return this.tabPaneActions;
    }

    @Nullable
    public final String getTabActionPlace() {
        return this.tabActionPlace;
    }

    public final int getBlinkCount() {
        return this.blinkCount;
    }

    public final void setBlinkCount(int n) {
        this.blinkCount = n;
    }

    public final boolean isAlertRequested() {
        return this.isAlertRequested;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    public final void setHidden(boolean hidden) {
        boolean old = this.isHidden;
        this.isHidden = hidden;
        this.changeSupport.firePropertyChange(HIDDEN, old, this.isHidden);
    }

    @Nullable
    public final JComponent getActionsContextComponent() {
        return this.actionsContextComponent;
    }

    @NotNull
    public final SimpleColoredText getColoredText() {
        return this.coloredText;
    }

    @Nullable
    public final String getTooltipText() {
        return this.tooltipText;
    }

    @Nullable
    public final Color getDefaultForeground() {
        return this.defaultForeground;
    }

    @Nullable
    public final TextAttributes getEditorAttributes() {
        return this.editorAttributes;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean enabled) {
        boolean old = this.isEnabled;
        this.isEnabled = enabled;
        this.changeSupport.firePropertyChange(ENABLED, old, this.isEnabled);
    }

    @Nullable
    public final Color getTabColor() {
        return this.tabColor;
    }

    @Nullable
    public final DragOutDelegate getDragOutDelegate() {
        return this.dragOutDelegate;
    }

    @Nullable
    public final DragDelegate getDragDelegate() {
        return this.dragDelegate;
    }

    public final void setDragDelegate(@Nullable DragDelegate dragDelegate) {
        this.dragDelegate = dragDelegate;
    }

    @Nullable
    public final TabInfo getPreviousSelection() {
        WeakReference<TabInfo> weakReference = this.previousSelectionRef;
        return weakReference != null ? (TabInfo)weakReference.get() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreviousSelection(@Nullable TabInfo value2) {
        WeakReference<void> weakReference;
        TabInfo tabInfo = this;
        TabInfo tabInfo2 = value2;
        if (tabInfo2 != null) {
            void it;
            TabInfo tabInfo3 = tabInfo2;
            TabInfo tabInfo4 = tabInfo;
            boolean bl = false;
            weakReference = new WeakReference<void>(it);
            tabInfo = tabInfo4;
        } else {
            weakReference = null;
        }
        tabInfo.previousSelectionRef = weakReference;
    }

    @NotNull
    public final TabInfo setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)TEXT);
        ArrayList attributes = this.coloredText.getAttributes();
        Intrinsics.checkNotNull((Object)attributes);
        SimpleTextAttributes textAttributes = (SimpleTextAttributes)CollectionsKt.singleOrNull((List)attributes);
        SimpleTextAttributes defaultAttributes = this.getDefaultAttributes();
        if (!Intrinsics.areEqual((Object)this.coloredText.toString(), (Object)text) || !Intrinsics.areEqual((Object)textAttributes, (Object)defaultAttributes)) {
            this.clearText(false);
            this.append(text, defaultAttributes);
        }
        return this;
    }

    @ApiStatus.Internal
    public final int getFontSize() {
        if (this.tabLabel == null) {
            return 0;
        }
        TabLabel tabLabel = this.tabLabel;
        Intrinsics.checkNotNull((Object)tabLabel);
        return tabLabel.getFont().getSize();
    }

    private final SimpleTextAttributes getDefaultAttributes() {
        if (this.defaultAttributes == null) {
            int style = (this.defaultStyle == -1 ? 0 : this.defaultStyle) | 0x2000;
            if (this.editorAttributes == null) {
                this.defaultAttributes = new SimpleTextAttributes(style, this.defaultForeground);
            } else {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)this.editorAttributes);
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"fromTextAttributes(...)");
                SimpleTextAttributes attr = simpleTextAttributes;
                this.defaultAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)new SimpleTextAttributes(style, this.defaultForeground), (SimpleTextAttributes)attr);
            }
        }
        SimpleTextAttributes simpleTextAttributes = this.defaultAttributes;
        Intrinsics.checkNotNull((Object)simpleTextAttributes);
        return simpleTextAttributes;
    }

    @NotNull
    public final TabInfo clearText(boolean invalidate) {
        String string = this.coloredText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String old = string;
        this.coloredText.clear();
        if (invalidate) {
            this.changeSupport.firePropertyChange(TEXT, old, this.coloredText.toString());
        }
        return this;
    }

    @NotNull
    public final TabInfo append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String string = this.coloredText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String old = string;
        this.coloredText.append(fragment, attributes);
        this.changeSupport.firePropertyChange(TEXT, old, this.coloredText.toString());
        return this;
    }

    @NotNull
    public final TabInfo setIcon(@Nullable Icon icon) {
        Icon old = this.getIcon();
        if (!Intrinsics.areEqual((Object)old, (Object)icon)) {
            this.iconHolder.setIcon(icon);
        }
        return this;
    }

    @ApiStatus.Internal
    @NotNull
    public final TabInfo setIconHolder(@NotNull TabInfoIconHolder iconHolder) {
        Intrinsics.checkNotNullParameter((Object)iconHolder, (String)"iconHolder");
        iconHolder.setIcon(this.iconHolder.getIcon());
        this.iconHolder = iconHolder;
        return this;
    }

    @NotNull
    public final TabInfo setComponent(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.component != c) {
            JComponent old = this.component;
            this.component = (JComponent)c;
            this.changeSupport.firePropertyChange(COMPONENT, old, this.component);
        }
        return this;
    }

    public final boolean isPinned() {
        return ClientProperty.isTrue((Component)this.component, JBTabsImpl.PINNED);
    }

    @NotNull
    public final String getText() {
        String string = this.coloredText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public String getPlace() {
        return this.place;
    }

    @NotNull
    public final TabInfo setSideComponent(@Nullable JComponent comp) {
        this.sideComponent = comp;
        return this;
    }

    @NotNull
    public final TabInfo setForeSideComponent(@Nullable JComponent comp) {
        this.foreSideComponent = comp;
        return this;
    }

    @NotNull
    public final TabInfo setActions(@Nullable ActionGroup group, @Nullable String place) {
        ActionGroup old = this.group;
        this.group = group;
        this.place = place;
        this.changeSupport.firePropertyChange(ACTION_GROUP, old, this.group);
        return this;
    }

    @NotNull
    public final TabInfo setActionsContextComponent(@Nullable JComponent c) {
        this.actionsContextComponent = c;
        return this;
    }

    @NotNull
    public final TabInfo setObject(@Nullable Object object) {
        this.object = object;
        return this;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.preferredFocusableComponent;
        if (jComponent == null) {
            jComponent = this.component;
        }
        return jComponent;
    }

    @NotNull
    public final TabInfo setPreferredFocusableComponent(@Nullable JComponent component) {
        this.preferredFocusableComponent = component;
        return this;
    }

    @NotNull
    public final TabInfo setTabLabelActions(@Nullable ActionGroup tabActions, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        ActionGroup old = this.tabLabelActions;
        this.tabLabelActions = tabActions;
        this.tabActionPlace = place;
        this.changeSupport.firePropertyChange(TAB_ACTION_GROUP, old, this.tabLabelActions);
        return this;
    }

    @NotNull
    public final TabInfo setTabPaneActions(@Nullable ActionGroup tabPaneActions) {
        this.tabPaneActions = tabPaneActions;
        return this;
    }

    @NotNull
    public final TabInfo setAlertIcon(@Nullable AlertIcon alertIcon) {
        AlertIcon old = this.alertIcon;
        this.alertIcon = alertIcon;
        this.changeSupport.firePropertyChange(ALERT_ICON, old, this.alertIcon);
        return this;
    }

    public final void fireAlert() {
        this.isAlertRequested = true;
        this.changeSupport.firePropertyChange(ALERT_STATUS, null, (Object)true);
    }

    public final void stopAlerting() {
        this.isAlertRequested = false;
        this.changeSupport.firePropertyChange(ALERT_STATUS, null, (Object)false);
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @NotNull
    public final AlertIcon getAlertIcon() {
        AlertIcon alertIcon = this.alertIcon;
        if (alertIcon == null) {
            alertIcon = DEFAULT_ALERT_ICON;
        }
        return alertIcon;
    }

    public final void resetAlertRequest() {
        this.isAlertRequested = false;
    }

    @NotNull
    public final TabInfo setDefaultStyle(@SimpleTextAttributes.StyleAttributeConstant int style) {
        this.defaultStyle = style;
        this.defaultAttributes = null;
        this.update();
        return this;
    }

    @NotNull
    public final TabInfo setDefaultForeground(@Nullable Color foregroundColor) {
        this.defaultForeground = foregroundColor;
        this.defaultAttributes = null;
        this.update();
        return this;
    }

    @ApiStatus.Internal
    public final void setDefaultForegroundAndAttributes(@Nullable Color foregroundColor, @Nullable TextAttributes attributes) {
        this.defaultForeground = foregroundColor;
        this.editorAttributes = attributes;
        this.defaultAttributes = null;
        this.update();
    }

    @NotNull
    public final TabInfo setDefaultAttributes(@Nullable TextAttributes attributes) {
        this.editorAttributes = attributes;
        this.defaultAttributes = null;
        this.update();
        return this;
    }

    private final void update() {
        this.setText(this.getText());
    }

    public final void revalidate() {
        this.defaultAttributes = null;
        this.update();
    }

    @NotNull
    public final TabInfo setTooltipText(@Nullable String text) {
        String old = this.tooltipText;
        if (!Intrinsics.areEqual((Object)old, (Object)text)) {
            this.tooltipText = text;
            this.changeSupport.firePropertyChange(TEXT, old, this.tooltipText);
        }
        return this;
    }

    @NotNull
    public final TabInfo setTabColor(@Nullable Color color) {
        Color old = this.tabColor;
        if (!Intrinsics.areEqual((Object)color, (Object)old)) {
            this.tabColor = color;
            this.changeSupport.firePropertyChange(TAB_COLOR, old, color);
        }
        return this;
    }

    @ApiStatus.Internal
    @NotNull
    public final TabInfo setTestableUi(@Nullable Queryable queryable) {
        this.queryable = queryable;
        return this;
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        block0: {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            Queryable queryable = this.queryable;
            if (queryable == null) break block0;
            queryable.putInfo(info);
        }
    }

    @NotNull
    public final TabInfo setDragOutDelegate(@Nullable DragOutDelegate delegate) {
        this.dragOutDelegate = delegate;
        return this;
    }

    public final boolean canBeDraggedOut() {
        return this.dragOutDelegate != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/tabs/TabInfo$Companion;", "", "<init>", "()V", "ACTION_GROUP", "", "ICON", "TAB_COLOR", "COMPONENT", "TEXT", "TAB_ACTION_GROUP", "ALERT_ICON", "ALERT_STATUS", "HIDDEN", "ENABLED", "DEFAULT_ALERT_ICON", "Lcom/intellij/ui/content/AlertIcon;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ui/tabs/TabInfo$DragDelegate;", "", "dragStarted", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "dragFinishedOrCanceled", "intellij.platform.ide"})
    public static interface DragDelegate {
        public void dragStarted(@NotNull MouseEvent var1);

        public void dragFinishedOrCanceled();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H&J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "", "dragOutStarted", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "processDragOut", "event", "source", "dragOutFinished", "dragOutCancelled", "intellij.platform.ide"})
    public static interface DragOutDelegate {
        public void dragOutStarted(@NotNull MouseEvent var1, @NotNull TabInfo var2);

        public void processDragOut(@NotNull MouseEvent var1, @NotNull TabInfo var2);

        public void dragOutFinished(@NotNull MouseEvent var1, @NotNull TabInfo var2);

        public void dragOutCancelled(@NotNull TabInfo var1);
    }
}

