/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@ApiStatus.Internal
public class TableLayout
extends TabLayout {
    private int myScrollOffset = 0;
    final JBTabsImpl myTabs;
    public TablePassInfo lastTableLayout;
    private final boolean myWithScrollBar;

    public TableLayout(JBTabsImpl tabs) {
        this(tabs, false);
    }

    public TableLayout(JBTabsImpl tabs, boolean isWithScrollBar) {
        this.myTabs = tabs;
        this.myWithScrollBar = isWithScrollBar;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        TablePassInfo data = new TablePassInfo(this, visibleInfos);
        if (this.myTabs.isHideTabs()) {
            return data;
        }
        this.doScrollToSelectedTab(this.lastTableLayout);
        boolean singleRow = this.myTabs.isSingleRow();
        boolean showPinnedTabsSeparately = TableLayout.showPinnedTabsSeparately();
        boolean scrollable = UISettings.getInstance().getHideTabsIfNeeded() && singleRow;
        int titleWidth = this.myTabs.getTitleWrapper().getPreferredSize().width;
        data.titleRect.setBounds(data.toFitRec.x, data.toFitRec.y, titleWidth, Objects.requireNonNull(this.myTabs.getHeaderFitSize()).height);
        data.entryPointRect.setBounds(data.toFitRec.x + data.toFitRec.width - this.myTabs.getEntryPointPreferredSize().width - this.myTabs.getActionsInsets().right, data.toFitRec.y, this.myTabs.getEntryPointPreferredSize().width, this.myTabs.getHeaderFitSize().height);
        data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width - this.myTabs.getEntryPointPreferredSize().width - this.myTabs.getActionsInsets().right, data.toFitRec.y, 0, this.myTabs.getHeaderFitSize().height);
        this.calculateLengths(data);
        int eachX = data.titleRect.x + data.titleRect.width;
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        int requiredRowsPinned = 0;
        int requiredRowsUnpinned = 0;
        int maxX = data.moreRect.x - (singleRow ? this.myTabs.getActionsInsets().left : 0);
        if (!singleRow && showPinnedTabsSeparately && ContainerUtil.all(visibleInfos, info -> !info.isPinned())) {
            maxX += this.myTabs.getEntryPointPreferredSize().width;
        }
        int hGap = this.myTabs.getTabHGap();
        int entryPointMargin = scrollable ? 0 : this.myTabs.getEntryPointPreferredSize().width;
        for (TabInfo eachInfo : data.visibleInfos) {
            TabLabel eachLabel = this.myTabs.getTabLabel(eachInfo);
            boolean pinned = eachLabel.isPinned();
            int width = data.lengths.get(eachInfo);
            if (!pinned || !showPinnedTabsSeparately) {
                data.requiredLength += width;
            }
            if (pinned && showPinnedTabsSeparately) {
                if (requiredRowsPinned == 0) {
                    requiredRowsPinned = 1;
                }
                this.myTabs.layout(eachLabel, eachX, eachY, width, this.myTabs.getHeaderFitSize().height);
                data.bounds.put(eachInfo, eachLabel.getBounds());
            } else {
                if (!scrollable && eachX + width + hGap > maxX - entryPointMargin && !singleRow || showPinnedTabsSeparately && eachLabel.isNextToLastPinned()) {
                    ++requiredRowsUnpinned;
                    eachY += this.myTabs.getHeaderFitSize().height;
                    eachX = data.toFitRec.x;
                } else if (requiredRowsUnpinned == 0) {
                    requiredRowsUnpinned = 1;
                }
                if (scrollable && eachX - this.getScrollOffset() + width + hGap > maxX - entryPointMargin) {
                    width = Math.max(0, maxX - eachX + this.getScrollOffset());
                    data.invisible.add(eachInfo);
                }
                this.myTabs.layout(eachLabel, eachX - this.getScrollOffset(), eachY, width == 1 ? 0 : width, this.myTabs.getHeaderFitSize().height);
                Rectangle rectangle = new Rectangle(this.myTabs.getHeaderFitSize());
                data.bounds.put(eachInfo, eachLabel.getBounds());
                int intersection = eachLabel.getBounds().intersection((Rectangle)rectangle).width;
                if (scrollable && intersection < eachLabel.getBounds().width) {
                    data.invisible.add(eachInfo);
                }
            }
            eachX += width + hGap;
            if (requiredRowsPinned + requiredRowsUnpinned <= 1) continue;
            entryPointMargin = singleRow ? 0 : -data.moreRect.width;
        }
        if (requiredRowsPinned > 0 && requiredRowsUnpinned > 0) {
            data.moreRect.y += this.myTabs.getHeaderFitSize().height;
        }
        if (data.invisible.isEmpty()) {
            data.moreRect.setBounds(0, 0, 0, 0);
        }
        eachY = -1;
        TableRow eachTableRow = new TableRow(data);
        for (TabInfo info2 : data.visibleInfos) {
            TabLabel tabLabel = this.myTabs.getTabLabel(info2);
            if (eachY == -1 || eachY != Objects.requireNonNull(tabLabel).getY()) {
                if (eachY != -1) {
                    eachTableRow = new TableRow(data);
                }
                eachY = tabLabel.getY();
                data.table.add(eachTableRow);
            }
            eachTableRow.add(info2, tabLabel.getWidth());
        }
        this.doScrollToSelectedTab(data);
        this.clampScrollOffsetToBounds(data);
        return data;
    }

    private void calculateLengths(TablePassInfo data) {
        boolean compressible = this.isCompressible();
        boolean showPinnedTabsSeparately = TableLayout.showPinnedTabsSeparately();
        int standardLengthToFit = data.moreRect.x - (data.titleRect.x + data.titleRect.width) - this.myTabs.getActionsInsets().left;
        if (compressible || showPinnedTabsSeparately) {
            if (showPinnedTabsSeparately) {
                List pinned = ContainerUtil.filter((Collection)data.visibleInfos, info -> info.isPinned());
                this.calculateCompressibleLengths(pinned, data, standardLengthToFit);
                List unpinned = ContainerUtil.filter((Collection)data.visibleInfos, info -> !info.isPinned());
                if (compressible) {
                    Insets insets = this.myTabs.getActionsInsets();
                    this.calculateCompressibleLengths(unpinned, data, pinned.isEmpty() ? standardLengthToFit : standardLengthToFit + data.titleRect.width + this.myTabs.getEntryPointPreferredSize().width + insets.left + insets.right);
                } else {
                    this.calculateRawLengths(unpinned, data);
                    if (TableLayout.getTotalLength(unpinned, data) > standardLengthToFit) {
                        int moreWidth = this.getMoreRectAxisSize();
                        int entryPointsWidth = pinned.isEmpty() ? this.myTabs.getEntryPointPreferredSize().width : 0;
                        data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width - moreWidth - entryPointsWidth - this.myTabs.getActionsInsets().right, this.myTabs.getLayoutInsets().top, moreWidth, this.myTabs.getHeaderFitSize().height);
                        this.calculateRawLengths(unpinned, data);
                    }
                }
            } else {
                this.calculateCompressibleLengths(data.visibleInfos, data, standardLengthToFit);
            }
        } else {
            this.calculateRawLengths(data.visibleInfos, data);
            if (TableLayout.getTotalLength(data.visibleInfos, data) > standardLengthToFit) {
                int moreWidth = this.getMoreRectAxisSize();
                data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width - moreWidth, data.toFitRec.y, moreWidth, this.myTabs.getHeaderFitSize().height);
                this.calculateRawLengths(data.visibleInfos, data);
            }
        }
    }

    private int getMoreRectAxisSize() {
        return this.myTabs.isSingleRow() ? this.myTabs.getMoreToolbarPreferredSize().width : 0;
    }

    private static int getTotalLength(@NotNull List<TabInfo> list, @NotNull TablePassInfo data) {
        if (list == null) {
            TableLayout.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TableLayout.$$$reportNull$$$0(1);
        }
        int total = 0;
        for (TabInfo info : list) {
            total += data.lengths.get(info).intValue();
        }
        return total;
    }

    private boolean isCompressible() {
        return this.myTabs.isSingleRow() && !UISettings.getInstance().getHideTabsIfNeeded() && this.myTabs.supportCompression();
    }

    private void calculateCompressibleLengths(List<TabInfo> list, TablePassInfo data, int toFitLength) {
        if (list.isEmpty()) {
            return;
        }
        int spentLength = 0;
        int lengthEstimation = 0;
        for (TabInfo tabInfo : list) {
            lengthEstimation += Math.max(TableLayout.getMinTabWidth(), this.myTabs.getTabLabel((TabInfo)tabInfo).getPreferredSize().width);
        }
        int extraWidth = toFitLength - lengthEstimation;
        Iterator<TabInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            TabInfo tabInfo = iterator.next();
            TabLabel label2 = this.myTabs.getTabLabel(tabInfo);
            int lengthIncrement = label2.getPreferredSize().width;
            int length = !iterator.hasNext() ? Math.min(toFitLength - spentLength, lengthIncrement) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)toFitLength / (float)lengthEstimation) : lengthIncrement);
            if (tabInfo.isPinned()) {
                length = Math.min(TableLayout.getMaxPinnedTabWidth(), length);
            }
            length = Math.max(TableLayout.getMinTabWidth(), length);
            data.lengths.put(tabInfo, length);
            spentLength += length + this.myTabs.getTabHGap();
        }
    }

    private void calculateRawLengths(List<TabInfo> list, TablePassInfo data) {
        for (TabInfo info : list) {
            TabLabel eachLabel = this.myTabs.getTabLabel(info);
            Dimension size = eachLabel.isPinned() && TableLayout.showPinnedTabsSeparately() ? eachLabel.getNotStrictPreferredSize() : eachLabel.getPreferredSize();
            data.lengths.put(info, Math.max(TableLayout.getMinTabWidth(), size.width + this.myTabs.getTabHGap()));
        }
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos) {
        this.myTabs.resetLayout(true);
        Rectangle unitedTabArea = null;
        TablePassInfo data = this.computeLayoutTable(visibleInfos);
        Rectangle rect = new Rectangle(data.moreRect);
        rect.y += this.myTabs.getBorderThickness();
        this.myTabs.getMoreToolbar().getComponent().setBounds(rect);
        ActionToolbar entryPointToolbar = this.myTabs.entryPointToolbar;
        if (entryPointToolbar != null) {
            entryPointToolbar.getComponent().setBounds(data.entryPointRect);
        }
        this.myTabs.getTitleWrapper().setBounds(data.titleRect);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        for (TabInfo info : visibleInfos) {
            Rectangle bounds = data.bounds.get(info);
            if (unitedTabArea == null) {
                unitedTabArea = bounds;
                continue;
            }
            unitedTabArea = unitedTabArea.union(bounds);
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.getInfoToToolbar().get(this.myTabs.getSelectedInfo());
            int componentY = (unitedTabArea != null ? unitedTabArea.y + unitedTabArea.height : eachY) + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top;
            if (!this.myTabs.getHorizontalSide() && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myTabs.separatorWidth : 0;
                if (this.myTabs.isSideComponentBefore()) {
                    Rectangle compRect = this.myTabs.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myTabs.getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.myTabs.layoutComp(new Rectangle(0, componentY, width, this.myTabs.getHeight()), this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.myTabs.layoutComp(0, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        if (unitedTabArea != null) {
            data.tabRectangle.setBounds(unitedTabArea);
        }
        this.lastTableLayout = data;
        return data;
    }

    @Override
    public boolean isTabHidden(@NotNull TabInfo info) {
        if (info == null) {
            TableLayout.$$$reportNull$$$0(2);
        }
        TabLabel label2 = this.myTabs.getTabLabel(info);
        Rectangle bounds = label2.getBounds();
        int deadzone = JBUI.scale((int)10);
        return bounds.x < -deadzone || bounds.width < label2.getPreferredSize().width - deadzone;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            TableLayout.$$$reportNull$$$0(3);
        }
        if (this.lastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.lastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i = 0; i < this.lastTableLayout.visibleInfos.size(); ++i) {
            area = area.union(this.myTabs.getTabLabel((TabInfo)this.lastTableLayout.visibleInfos.get(i)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(@NotNull Point point) {
        int i;
        if (point == null) {
            TableLayout.$$$reportNull$$$0(4);
        }
        if (this.lastTableLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myTabs.getComponentAt(point);
        HashSet<TabInfo> lastInRow = new HashSet<TabInfo>();
        for (i = 0; i < this.lastTableLayout.table.size(); ++i) {
            List<TabInfo> columns = this.lastTableLayout.table.get((int)i).myColumns;
            if (columns.isEmpty()) continue;
            lastInRow.add(columns.get(columns.size() - 1));
        }
        if (c instanceof JBTabsImpl) {
            for (i = 0; i < this.lastTableLayout.visibleInfos.size() - 1; ++i) {
                boolean between;
                TabInfo firstInfo = (TabInfo)this.lastTableLayout.visibleInfos.get(i);
                TabInfo secondInfo = (TabInfo)this.lastTableLayout.visibleInfos.get(i + 1);
                TabLabel first = this.myTabs.getTabLabel(firstInfo);
                TabLabel second = this.myTabs.getTabLabel(secondInfo);
                Rectangle firstBounds = Objects.requireNonNull(first).getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (between) {
                    c = first;
                    break;
                }
                if (!lastInRow.contains(firstInfo) || firstBounds.y > point.y || !(firstBounds.getMaxY() >= (double)point.y) || !(firstBounds.getMaxX() <= (double)point.x)) continue;
                c = second;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.lastTableLayout.visibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i2 = 0; i2 <= index; ++i2) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.lastTableLayout.visibleInfos.get(i2))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.lastTableLayout.visibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            TableLayout.$$$reportNull$$$0(5);
        }
        return TabsUtil.getDropSideFor(point, this.myTabs);
    }

    @Override
    public int getScrollOffset() {
        return this.myScrollOffset;
    }

    @Override
    public void scroll(int units) {
        if (!this.myTabs.isSingleRow()) {
            this.myScrollOffset = 0;
            return;
        }
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.lastTableLayout);
    }

    private void clampScrollOffsetToBounds(@Nullable TablePassInfo data) {
        if (data == null) {
            return;
        }
        if (data.requiredLength < data.toFitRec.width) {
            this.myScrollOffset = 0;
        } else {
            int entryPointsWidth = data.moreRect.y == data.entryPointRect.y ? data.entryPointRect.width + 1 : 0;
            this.myScrollOffset = Math.max(0, Math.min(this.myScrollOffset, data.requiredLength - data.toFitRec.width + data.moreRect.width + entryPointsWidth + data.titleRect.width));
        }
    }

    @Override
    public boolean isWithScrollBar() {
        return this.myWithScrollBar;
    }

    public int getScrollUnitIncrement() {
        return 10;
    }

    private void doScrollToSelectedTab(TablePassInfo data) {
        if (this.myTabs.isMouseInsideTabsArea() || data == null || data.lengths.isEmpty() || this.myTabs.isHideTabs() || !TableLayout.showPinnedTabsSeparately()) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : data.visibleInfos) {
            if (info.isPinned()) continue;
            int length = data.lengths.get(info);
            if (info == this.myTabs.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = data.moreRect.x;
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/table/TableLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalLength";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTabHidden";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropIndexFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

