/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.wayland;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0001H\u0007\u001a\u0019\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a@\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002\"\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"getValidBoundsForPopup", "Ljava/awt/Rectangle;", "popup", "Ljava/awt/Component;", "moveToFitChildPopupX", "", "childBounds", "parent", "getNearestTopLevelParentBounds", "component", "getNearestTopLevelAncestor", "addFakeScreenInsets", "rectangle", "getFakeScreenHeight", "", "(Ljava/awt/Component;)Ljava/lang/Integer;", "isAllowedTabDnD", "", "tabs", "Lcom/intellij/ui/tabs/JBTabsEx;", "fitValue", "location", "width", "start1", "end1", "start2", "end2", "preferLess", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nWaylandUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaylandUtil.kt\ncom/intellij/ui/wayland/WaylandUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n60#2,5:205\n60#2,5:210\n60#2,5:215\n60#2,5:220\n60#2,5:225\n60#2,5:230\n60#2,5:235\n60#2,5:240\n60#2,5:245\n60#2,5:250\n60#2,5:255\n60#2,5:260\n60#2,5:265\n60#2,5:270\n60#2,5:275\n60#2,5:280\n60#2,5:285\n57#2:290\n35#2,2:291\n*S KotlinDebug\n*F\n+ 1 WaylandUtil.kt\ncom/intellij/ui/wayland/WaylandUtilKt\n*L\n37#1:205,5\n47#1:210,5\n59#1:215,5\n61#1:220,5\n65#1:225,5\n67#1:230,5\n81#1:235,5\n93#1:240,5\n164#1:245,5\n166#1:250,5\n170#1:255,5\n176#1:260,5\n181#1:265,5\n185#1:270,5\n189#1:275,5\n194#1:280,5\n198#1:285,5\n203#1:290\n203#1:291,2\n*E\n"})
public final class WaylandUtilKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @Nullable
    public static final Rectangle getValidBoundsForPopup(@NotNull Component popup2) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        if (!popup2.isShowing()) {
            LOG.warn("Impossible to determine the valid bounds because the popup is not showing: " + popup2);
            return null;
        }
        Rectangle rectangle = WaylandUtilKt.getNearestTopLevelParentBounds(popup2);
        if (rectangle == null) {
            return null;
        }
        Rectangle validBounds = rectangle;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The allowed bounds in screen coordinates are " + validBounds, t$iv);
        }
        Container directParent = popup2.getParent();
        if (directParent == null) {
            LOG.warn("Impossible to determine the valid bounds because the popup has no direct parent: " + popup2);
            return null;
        }
        Point directParentLocation = directParent.getLocationOnScreen();
        validBounds.x -= directParentLocation.x;
        validBounds.y -= directParentLocation.y;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("The allowed bounds in parent coordinates are " + validBounds, t$iv2);
        }
        return validBounds;
    }

    @ApiStatus.Internal
    public static final void moveToFitChildPopupX(@NotNull Rectangle childBounds, @NotNull Component parent) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)childBounds, (String)"childBounds");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!parent.isShowing()) {
            LOG.warn("Impossible to fit the child popup to the main window because the parent is not showing: " + parent);
            return;
        }
        Point childLocation = childBounds.getLocation();
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The initial child bounds are " + childBounds, t$iv);
        }
        SwingUtilities.convertPointToScreen(childLocation, parent);
        $this$debug_u24default$iv = LOG;
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The initial child location relative to the screen is " + childLocation, t$iv);
        }
        Rectangle rectangle = WaylandUtilKt.getNearestTopLevelParentBounds(parent);
        if (rectangle == null) {
            return;
        }
        Rectangle topLevelBounds = rectangle;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("The relative parent location is " + parent.getLocation(), t$iv2);
        }
        Rectangle parentBounds = new Rectangle(parent.getLocationOnScreen(), parent.getSize());
        Logger $this$debug_u24default$iv3 = LOG;
        Throwable t$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            logger = $this$debug_u24default$iv3;
            boolean bl = false;
            logger.debug("The screen parent bounds are " + parentBounds, t$iv3);
        }
        childLocation.x = WaylandUtilKt.fitValue(childLocation.x, childBounds.width, topLevelBounds.x, parentBounds.x, parentBounds.x + parentBounds.width, topLevelBounds.x + topLevelBounds.width, childLocation.x < parentBounds.x + parentBounds.width / 2);
        SwingUtilities.convertPointFromScreen(childLocation, parent);
        childBounds.setLocation(childLocation);
        $this$debug_u24default$iv3 = LOG;
        t$iv3 = null;
        $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            logger = $this$debug_u24default$iv3;
            boolean bl = false;
            logger.debug("The final result is " + childBounds, t$iv3);
        }
    }

    private static final Rectangle getNearestTopLevelParentBounds(Component component) {
        Component topLevelWindow = WaylandUtilKt.getNearestTopLevelAncestor(component);
        if (!(topLevelWindow instanceof Window)) {
            LOG.warn("The top level parent isn't a window, but " + topLevelWindow);
            return null;
        }
        Rectangle topLevelBounds = new Rectangle(((Window)topLevelWindow).getLocationOnScreen(), ((Window)topLevelWindow).getSize());
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The top level bounds are " + topLevelBounds, t$iv);
        }
        return topLevelBounds;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Component getNearestTopLevelAncestor(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return ComponentUtil.findParentByCondition((Component)component, arg_0 -> WaylandUtilKt.getNearestTopLevelAncestor$lambda$1(WaylandUtilKt::getNearestTopLevelAncestor$lambda$0, arg_0));
    }

    @ApiStatus.Internal
    public static final void addFakeScreenInsets(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        if (!StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        int total = JBUI.scale((int)Registry.Companion.intValue("wayland.screen.vInsets", 50, 0, 300));
        int top = total / 2;
        rectangle.y += top;
        rectangle.height -= total;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Integer getFakeScreenHeight(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        Component component2 = ComponentUtil.findUltimateParent((Component)component);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"findUltimateParent(...)");
        Component parent = component2;
        if (!(parent instanceof Window) || !((Window)parent).isShowing()) {
            return null;
        }
        int screenHeight = parent.getHeight();
        if (screenHeight < 600) {
            return null;
        }
        return screenHeight;
    }

    @ApiStatus.Internal
    public static final boolean isAllowedTabDnD(@NotNull JBTabsEx tabs) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        if (!StartupUiUtil.isWaylandToolkit() || !tabs.isEditorTabs()) {
            return true;
        }
        Window window = SwingUtilities.getWindowAncestor(tabs.getComponent());
        if (window == null) {
            return true;
        }
        Window window2 = window;
        return !(window2 instanceof IdeFrame.Child);
    }

    private static final int fitValue(int location, int width, int start1, int end1, int start2, int end2, boolean preferLess) {
        int result2;
        Logger logger;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The available intervals are " + start1 + ".." + end1 + " and " + start2 + ".." + end2 + ", the popup size is " + width, t$iv);
        }
        if (location >= start1 && location + width < end1) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The initial location already fits within the first interval", t$iv);
            }
            return location;
        }
        if (location >= start2 && location + width < end2) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The initial location already fits within the second interval", t$iv);
            }
            return location;
        }
        int space1 = end1 - start1;
        int space2 = end2 - start2;
        if (space1 >= width && space2 >= width) {
            Logger $this$debug_u24default$iv2 = LOG;
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("We have enough space on both sides, preferring the " + (preferLess ? "first" : "second"), t$iv2);
            }
            return preferLess ? end1 - width : start2;
        }
        if (space1 >= width) {
            result2 = end1 - width;
            Logger $this$debug_u24default$iv3 = LOG;
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug("We have enough space the first side: " + space1 + " >= " + width + ", the result is " + end1 + "-" + width + "=" + result2, t$iv3);
            }
            return result2;
        }
        if (space2 >= width) {
            Logger $this$debug_u24default$iv4 = LOG;
            Throwable t$iv4 = null;
            boolean $i$f$debug4 = false;
            if ($this$debug_u24default$iv4.isDebugEnabled()) {
                logger = $this$debug_u24default$iv4;
                boolean bl = false;
                logger.debug("We have enough space the first side: " + space2 + " >= " + width + ", the result is " + start2, t$iv4);
            }
            return start2;
        }
        if (space1 > 0 && space1 > space2) {
            Logger $this$debug_u24default$iv5 = LOG;
            Throwable t$iv5 = null;
            boolean $i$f$debug5 = false;
            if ($this$debug_u24default$iv5.isDebugEnabled()) {
                logger = $this$debug_u24default$iv5;
                boolean bl = false;
                logger.debug("We have more space the first side: " + space1 + " > " + space2 + ", the result is " + start1, t$iv5);
            }
            return start1;
        }
        if (space2 > 0) {
            result2 = end2 - width;
            Logger $this$debug_u24default$iv6 = LOG;
            Throwable t$iv6 = null;
            boolean $i$f$debug6 = false;
            if ($this$debug_u24default$iv6.isDebugEnabled()) {
                logger = $this$debug_u24default$iv6;
                boolean bl = false;
                logger.debug("We have more space the second side: " + space1 + " <= " + space2 + ", the result is " + end2 + "-" + width + "=" + result2, t$iv6);
            }
            return result2;
        }
        Logger $this$debug_u24default$iv7 = LOG;
        Throwable t$iv7 = null;
        boolean $i$f$debug7 = false;
        if ($this$debug_u24default$iv7.isDebugEnabled()) {
            logger = $this$debug_u24default$iv7;
            boolean bl = false;
            logger.debug("We don't have any space at all, falling back to the initial value", t$iv7);
        }
        return location;
    }

    private static final boolean getNearestTopLevelAncestor$lambda$0(Component c) {
        return c instanceof Window && ((Window)c).getType() != Window.Type.POPUP;
    }

    private static final boolean getNearestTopLevelAncestor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

