/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ui.AnimatedIcon;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AsyncProcessIcon
extends AnimatedIcon {
    private static final Icon[] SMALL_ICONS = AnimatedIcon.Default.ICONS.toArray(new Icon[0]);
    public static final int COUNT = SMALL_ICONS.length;
    public static final int CYCLE_LENGTH = 125 * SMALL_ICONS.length;

    public AsyncProcessIcon(@NonNls String name) {
        this(name, SMALL_ICONS, AllIcons.Process.Step_passive);
    }

    public AsyncProcessIcon(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            AsyncProcessIcon.$$$reportNull$$$0(0);
        }
        this(null, SMALL_ICONS, AllIcons.Process.Step_passive, coroutineScope);
    }

    public AsyncProcessIcon(@NonNls String name, Icon[] icons, Icon passive) {
        super(name, icons, passive, CYCLE_LENGTH);
    }

    public AsyncProcessIcon(@NonNls String name, Icon[] icons, Icon passive, @NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            AsyncProcessIcon.$$$reportNull$$$0(1);
        }
        super(name, icons, passive, CYCLE_LENGTH, coroutineScope);
    }

    @Override
    protected Dimension calcPreferredSize() {
        return new Dimension(this.passiveIcon.getIconWidth(), this.passiveIcon.getIconHeight());
    }

    public void updateLocation(@NotNull JComponent container) {
        Rectangle newBounds;
        if (container == null) {
            AsyncProcessIcon.$$$reportNull$$$0(2);
        }
        if (!(newBounds = this.calculateBounds(container)).equals(this.getBounds())) {
            this.setBounds(newBounds);
            SwingUtilities.invokeLater(() -> container.repaint());
        }
    }

    @NotNull
    protected Rectangle calculateBounds(@NotNull JComponent container) {
        if (container == null) {
            AsyncProcessIcon.$$$reportNull$$$0(3);
        }
        Rectangle rec = container.getVisibleRect();
        Dimension iconSize = this.getPreferredSize();
        return new Rectangle(rec.x + rec.width - iconSize.width, rec.y, iconSize.width, iconSize.height);
    }

    @NotNull
    public static AnimatedIcon createBig(@NonNls String name) {
        return new AsyncProcessIcon(name, AnimatedIcon.Big.ICONS, AllIcons.Process.Big.Step_passive);
    }

    @NotNull
    public static AnimatedIcon createBig(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            AsyncProcessIcon.$$$reportNull$$$0(4);
        }
        return new AsyncProcessIcon(null, AnimatedIcon.Big.ICONS, AllIcons.Process.Big.Step_passive, coroutineScope);
    }

    public boolean isDisposed() {
        return this.animator.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/AsyncProcessIcon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateBounds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BigCentered
    extends Big {
        public BigCentered(@NonNls String name) {
            super(name);
        }

        @Override
        @NotNull
        protected Rectangle calculateBounds(@NotNull JComponent container) {
            if (container == null) {
                BigCentered.$$$reportNull$$$0(0);
            }
            Dimension size = container.getSize();
            Dimension iconSize = this.getPreferredSize();
            return new Rectangle((size.width - iconSize.width) / 2, (size.height - iconSize.height) / 2, iconSize.width, iconSize.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/ui/AsyncProcessIcon$BigCentered", "calculateBounds"));
        }
    }

    public static class Big
    extends AsyncProcessIcon {
        public Big(@NonNls String name) {
            super(name, AnimatedIcon.Big.ICONS, AllIcons.Process.Big.Step_passive);
        }
    }
}

