/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBIntSpinner;
import com.intellij.util.ObjectUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CalendarView
extends JPanel {
    private static final int[] DAYS_IN_THE_MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String INCREASE_NUMBER_ID = "IncreaseNumber";
    private static final String DECREASE_NUMBER_ID = "DecreaseNumber";
    private final JComboBox<String> myDays;
    private final JComboBox<String> myMonths;
    private final JSpinner myYears;
    private final JSpinner myHours;
    private final JSpinner myMinutes;
    private final JSpinner mySeconds;
    private final Calendar myCalendar;
    private final Mode myMode;

    public CalendarView() {
        this(Mode.DATETIME);
    }

    public CalendarView(@NotNull Mode mode) {
        if (mode == null) {
            CalendarView.$$$reportNull$$$0(0);
        }
        super(new GridLayout(mode == Mode.DATETIME ? 2 : 1, 0));
        this.myDays = new ComboBox<String>();
        this.myMonths = new ComboBox<String>();
        this.myYears = new JBIntSpinner(2022, 0, Integer.MAX_VALUE);
        this.myHours = new JBIntSpinner(23, 0, 23);
        this.myMinutes = new JBIntSpinner(59, 0, 59);
        this.mySeconds = new JBIntSpinner(59, 0, 59);
        this.myCalendar = Calendar.getInstance();
        this.myMode = mode;
        this.fillMonths();
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.myYears, "####");
        editor.getTextField().setColumns(4);
        this.myYears.setEditor(editor);
        this.myYears.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarView.this.refresh();
            }
        });
        this.setDate(new Date());
        if (this.myMode.hasDate()) {
            this.addDateFields();
        }
        if (this.myMode.hasTime()) {
            this.addTimeFields();
        }
        int height = Math.max(this.myYears.getPreferredSize().height, this.myDays.getPreferredSize().height);
        height = Math.max(this.myMonths.getPreferredSize().height, height);
        this.myDays.setPreferredSize(new Dimension(this.myDays.getPreferredSize().width, height));
        this.myYears.setPreferredSize(new Dimension(this.myYears.getPreferredSize().width, height));
        this.myMonths.setPreferredSize(new Dimension(this.myMonths.getPreferredSize().width, height));
        Dimension preferredSize = this.getPreferredSize();
        this.setMaximumSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        CalendarView.selectAllOnFocusGained(this.myYears);
        CalendarView.selectAllOnFocusGained(this.myHours);
        CalendarView.selectAllOnFocusGained(this.myMinutes);
        CalendarView.selectAllOnFocusGained(this.mySeconds);
        CalendarView.registerUpAndDownKeys(this.myYears);
        CalendarView.registerUpAndDownKeys(this.myHours);
        CalendarView.registerUpAndDownKeys(this.myMinutes);
        CalendarView.registerUpAndDownKeys(this.mySeconds);
    }

    private static void registerUpAndDownKeys(@NotNull JSpinner spinner) {
        JSpinner.DefaultEditor editor;
        if (spinner == null) {
            CalendarView.$$$reportNull$$$0(1);
        }
        if ((editor = (JSpinner.DefaultEditor)ObjectUtils.tryCast((Object)spinner.getEditor(), JSpinner.DefaultEditor.class)) == null) {
            return;
        }
        JFormattedTextField field = editor.getTextField();
        field.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), INCREASE_NUMBER_ID);
        field.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), DECREASE_NUMBER_ID);
        field.getActionMap().put(INCREASE_NUMBER_ID, CalendarView.getIncAction(spinner, field, 1));
        field.getActionMap().put(DECREASE_NUMBER_ID, CalendarView.getIncAction(spinner, field, -1));
    }

    @NotNull
    private static AbstractAction getIncAction(final @NotNull JSpinner spinner, final @NotNull JFormattedTextField field, final int inc) {
        if (spinner == null) {
            CalendarView.$$$reportNull$$$0(2);
        }
        if (field == null) {
            CalendarView.$$$reportNull$$$0(3);
        }
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinnerNumberModel model;
                int newValue = CalendarView.getIntValue(spinner) + inc;
                if (newValue <= (Integer)(model = (SpinnerNumberModel)spinner.getModel()).getMaximum() && newValue >= (Integer)model.getMinimum()) {
                    boolean hasSelection = field.getSelectionStart() != field.getSelectionEnd();
                    model.setValue(newValue);
                    if (hasSelection) {
                        field.selectAll();
                    }
                }
            }
        };
    }

    private static void selectAllOnFocusGained(@NotNull JSpinner spinner) {
        JSpinner.DefaultEditor editor;
        if (spinner == null) {
            CalendarView.$$$reportNull$$$0(4);
        }
        if ((editor = (JSpinner.DefaultEditor)ObjectUtils.tryCast((Object)spinner.getEditor(), JSpinner.DefaultEditor.class)) == null) {
            return;
        }
        editor.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> editor.getTextField().selectAll());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @NotNull
    public Calendar getCalendar() {
        Calendar calendar = this.myCalendar;
        if (calendar == null) {
            CalendarView.$$$reportNull$$$0(5);
        }
        return calendar;
    }

    private void fillMonths() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.getDefault());
        for (int i = 0; i <= 11; ++i) {
            this.myMonths.addItem(dateFormatSymbols.getMonths()[i]);
        }
        this.myMonths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarView.this.refresh();
            }
        });
    }

    public void setDate(Date date) {
        this.myCalendar.setTime(date);
        this.myYears.setValue(this.myCalendar.get(1));
        this.myMonths.setSelectedIndex(this.myCalendar.get(2));
        this.myDays.setSelectedIndex(this.myCalendar.get(5) - 1);
        this.myHours.setValue(this.myCalendar.get(11));
        this.myMinutes.setValue(this.myCalendar.get(12));
        this.mySeconds.setValue(this.myCalendar.get(13));
    }

    public JComponent getDaysCombo() {
        return this.myDays;
    }

    private void addTimeFields() {
        JPanel timePanel = new JPanel(new FlowLayout(2));
        timePanel.add(this.myHours);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.myMinutes);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.mySeconds);
        this.add(timePanel);
    }

    private void addDateFields() {
        JPanel datePanel = new JPanel(new FlowLayout(2));
        datePanel.add(this.myDays);
        datePanel.add(this.myMonths);
        datePanel.add(this.myYears);
        this.add(datePanel);
    }

    private void refresh() {
        int days = DAYS_IN_THE_MONTH[this.myMonths.getSelectedIndex()];
        if (days > 0) {
            this.fillDays(days);
        } else {
            this.fillDays(this.daysInTheFebruary());
        }
    }

    private void fillDays(int days) {
        int selectedDayIndex = this.myDays.getSelectedIndex();
        this.myDays.removeAllItems();
        for (int i = 0; i < days; ++i) {
            this.myDays.addItem(String.valueOf(i + 1));
        }
        if (selectedDayIndex < this.myDays.getItemCount()) {
            this.myDays.setSelectedIndex(selectedDayIndex);
        } else {
            this.myDays.setSelectedIndex(this.myDays.getItemCount() - 1);
        }
    }

    private int daysInTheFebruary() {
        int year = Integer.parseInt(this.myYears.getValue().toString());
        if (year % 4 > 0) {
            return 29;
        }
        if (year % 100 > 0) {
            return 29;
        }
        return 28;
    }

    public Date getDate() {
        this.commitSpinners();
        this.myCalendar.set(CalendarView.getIntValue(this.myYears), this.myMonths.getSelectedIndex(), this.myDays.getSelectedIndex() + 1, CalendarView.getIntValue(this.myHours), CalendarView.getIntValue(this.myMinutes), CalendarView.getIntValue(this.mySeconds));
        return this.myCalendar.getTime();
    }

    private static int getIntValue(JSpinner spinner) {
        return ((Number)spinner.getModel().getValue()).intValue();
    }

    public void registerEnterHandler(final Runnable runnable) {
        new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!CalendarView.this.myMonths.isPopupVisible() && !CalendarView.this.myDays.isPopupVisible());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(2);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/CalendarView$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/CalendarView$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.registerCustomShortcutSet(10, 0, (JComponent)this);
    }

    private void commitSpinners() {
        try {
            this.myYears.commitEdit();
            this.myHours.commitEdit();
            this.myMinutes.commitEdit();
            this.mySeconds.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spinner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/CalendarView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/CalendarView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalendar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerUpAndDownKeys";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectAllOnFocusGained";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static enum Mode {
        DATE,
        TIME,
        DATETIME;


        boolean hasDate() {
            return this == DATE || this == DATETIME;
        }

        boolean hasTime() {
            return this == TIME || this == DATETIME;
        }
    }
}

