/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.BulkUpdateListSelectionModel;
import com.intellij.ui.components.BulkUpdateListUi;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.plaf.ListUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/components/BulkDefaultListSelectionModel;", "Ljavax/swing/DefaultListSelectionModel;", "Lcom/intellij/ui/components/BulkUpdateListSelectionModel;", "list", "Ljavax/swing/JList;", "<init>", "(Ljavax/swing/JList;)V", "myBulkUpdateDepth", "", "isBulkUpdateInProgress", "", "()Z", "enterBulkUpdate", "", "exitBulkUpdate", "intellij.platform.ide"})
public final class BulkDefaultListSelectionModel
extends DefaultListSelectionModel
implements BulkUpdateListSelectionModel {
    @NotNull
    private final JList<?> list;
    private int myBulkUpdateDepth;

    public BulkDefaultListSelectionModel(@NotNull JList<?> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
    }

    @Override
    public boolean isBulkUpdateInProgress() {
        return this.myBulkUpdateDepth > 0;
    }

    @Override
    public void enterBulkUpdate() {
        ListUI listUI;
        int n = this.myBulkUpdateDepth;
        this.myBulkUpdateDepth = n + 1;
        if (this.myBulkUpdateDepth == 1 && (listUI = this.list.getUI()) instanceof BulkUpdateListUi) {
            ((BulkUpdateListUi)((Object)listUI)).beforeBulkListUpdate();
        }
    }

    @Override
    public void exitBulkUpdate() {
        ListUI listUI;
        int n = this.myBulkUpdateDepth;
        this.myBulkUpdateDepth = n + -1;
        if (this.myBulkUpdateDepth == 0 && (listUI = this.list.getUI()) instanceof BulkUpdateListUi) {
            ((BulkUpdateListUi)((Object)listUI)).afterBulkListUpdate();
        }
    }
}

