/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AnimatedIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressBarLoadingDecorator
extends LoadingDecorator {
    private final AtomicBoolean loadingStarted;
    private JProgressBar myProgressBar;

    public ProgressBarLoadingDecorator(@NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
        if (contentPanel == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(1);
        }
        super(contentPanel, disposable, startDelayMs, true);
        this.loadingStarted = new AtomicBoolean(false);
    }

    @Override
    protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AnimatedIcon icon) {
        parent.setLayout(new BorderLayout());
        NonOpaquePanel result2 = new NonOpaquePanel();
        result2.setLayout(new BoxLayout(result2, 1));
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setIndeterminate(true);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 2);
        this.myProgressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        result2.add(this.myProgressBar);
        parent.add((Component)result2, this.isOnTop() ? "North" : "South");
        return result2;
    }

    protected boolean isOnTop() {
        return true;
    }

    @NotNull
    public JProgressBar getProgressBar() {
        JProgressBar jProgressBar = this.myProgressBar;
        if (jProgressBar == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(2);
        }
        return jProgressBar;
    }

    @Override
    public void startLoading(boolean takeSnapshot) {
        if (this.loadingStarted.compareAndSet(false, true)) {
            super.startLoading(takeSnapshot);
        }
    }

    public void startLoading() {
        this.startLoading(false);
    }

    @Override
    public void stopLoading() {
        if (this.loadingStarted.compareAndSet(true, false)) {
            super.stopLoading();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/ProgressBarLoadingDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/ProgressBarLoadingDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

