/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.builders;

import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.builders.RowsGridBuilder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000fJ\u0018\u0010\f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/dsl/gridLayout/builders/RowBuilder;", "", "panel", "Ljavax/swing/JPanel;", "<init>", "(Ljavax/swing/JPanel;)V", "builder", "Lcom/intellij/ui/dsl/gridLayout/builders/RowsGridBuilder;", "gap", "", "verticalAlign", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "add", "components", "", "Ljavax/swing/JComponent;", "([Ljavax/swing/JComponent;)Lcom/intellij/ui/dsl/gridLayout/builders/RowBuilder;", "addResizable", "component", "", "resizable", "", "intellij.platform.ide"})
@ApiStatus.Internal
public final class RowBuilder {
    @NotNull
    private final JPanel panel;
    @NotNull
    private final RowsGridBuilder builder;
    private int gap;
    @NotNull
    private VerticalAlign verticalAlign;

    public RowBuilder(@NotNull JPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        this.verticalAlign = VerticalAlign.CENTER;
        this.panel.setLayout(new GridLayout());
        this.builder = new RowsGridBuilder(this.panel, null, 2, null);
        this.builder.resizableRow();
    }

    @NotNull
    public final RowBuilder gap(int gap) {
        this.gap = gap;
        return this;
    }

    @NotNull
    public final RowBuilder verticalAlign(@NotNull VerticalAlign verticalAlign) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        this.verticalAlign = verticalAlign;
        return this;
    }

    @NotNull
    public final RowBuilder add(JComponent ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        for (JComponent component : components) {
            this.add(component, false);
        }
        return this;
    }

    @NotNull
    public final RowBuilder addResizable(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.add(component, true);
        return this;
    }

    private final void add(JComponent component, boolean resizable) {
        UnscaledGaps gaps = this.panel.getComponentCount() == 0 || this.gap == 0 ? UnscaledGaps.EMPTY : UnscaledGapsKt.UnscaledGaps$default(0, this.gap, 0, 0, 13, null);
        RowsGridBuilder rowsGridBuilder = this.builder;
        VerticalAlign verticalAlign = this.verticalAlign;
        HorizontalAlign horizontalAlign = resizable ? HorizontalAlign.FILL : HorizontalAlign.LEFT;
        RowsGridBuilder.cell$default(rowsGridBuilder, component, 0, horizontalAlign, verticalAlign, false, resizable, gaps, null, null, null, 914, null);
    }
}

