/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.ui.table.AdditionalTableHeaderPositionHelper;
import com.intellij.util.ui.EDT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010 \u001a\u00020!2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010$\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005J\u001c\u0010&\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0004J\b\u0010'\u001a\u00020!H&J\b\u0010(\u001a\u00020!H\u0004J\b\u0010)\u001a\u00020\u0015H&J\b\u0010*\u001a\u00020!H\u0014J\b\u0010+\u001a\u00020!H\u0016J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020.H\u0016R&\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lcom/intellij/ui/table/AdditionalTableHeader;", "Ljavax/swing/JPanel;", "<init>", "()V", "value", "Ljavax/swing/JTable;", "table", "getTable", "()Ljavax/swing/JTable;", "setTable", "(Ljavax/swing/JTable;)V", "updateChangeListener", "Ljava/beans/PropertyChangeListener;", "location", "Lcom/intellij/ui/table/AdditionalTableHeader$Position;", "position", "getPosition", "()Lcom/intellij/ui/table/AdditionalTableHeader$Position;", "setPosition", "(Lcom/intellij/ui/table/AdditionalTableHeader$Position;)V", "columnsController", "Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel;", "getColumnsController", "()Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel;", "setColumnsController", "(Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel;)V", "positionHelper", "Lcom/intellij/ui/table/AdditionalTableHeaderPositionHelper;", "resizer", "Ljava/awt/event/ComponentAdapter;", "getResizer", "()Ljava/awt/event/ComponentAdapter;", "installTable", "", "setupNewTable", "newTable", "disposeOldTable", "oldTable", "changeTableAtPositionHelper", "detachController", "removeController", "createColumnsController", "recreateController", "addNotify", "setVisible", "flag", "", "Position", "ColumnsControllerPanel", "intellij.platform.ide"})
public abstract class AdditionalTableHeader
extends JPanel {
    @NotNull
    private final PropertyChangeListener updateChangeListener = arg_0 -> AdditionalTableHeader.updateChangeListener$lambda$0(this, arg_0);
    @Nullable
    private ColumnsControllerPanel columnsController;
    @NotNull
    private final AdditionalTableHeaderPositionHelper positionHelper = new AdditionalTableHeaderPositionHelper(this);
    @NotNull
    private final ComponentAdapter resizer = new ComponentAdapter(this){
        final /* synthetic */ AdditionalTableHeader this$0;
        {
            this.this$0 = $receiver;
        }

        public void componentResized(ComponentEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ColumnsControllerPanel columnsControllerPanel = this.this$0.getColumnsController();
                if (columnsControllerPanel == null) break block0;
                columnsControllerPanel.revalidate();
            }
        }
    };

    public AdditionalTableHeader() {
        super(new BorderLayout());
    }

    @Nullable
    public abstract JTable getTable();

    protected abstract void setTable(@Nullable JTable var1);

    @Nullable
    public final Position getPosition() {
        return this.positionHelper.getPosition();
    }

    public final void setPosition(@Nullable Position location) {
        this.positionHelper.setPosition(location);
    }

    @Nullable
    protected final ColumnsControllerPanel getColumnsController() {
        return this.columnsController;
    }

    protected final void setColumnsController(@Nullable ColumnsControllerPanel columnsControllerPanel) {
        this.columnsController = columnsControllerPanel;
    }

    @NotNull
    protected final ComponentAdapter getResizer() {
        return this.resizer;
    }

    public void installTable(@Nullable JTable table) {
        JTable oldTable = this.getTable();
        this.disposeOldTable(oldTable, table);
        this.setTable(table);
        this.setupNewTable(table);
    }

    private final void setupNewTable(JTable newTable) {
        this.removeController();
        if (newTable == null) {
            this.revalidate();
        } else {
            this.recreateController();
            newTable.addComponentListener(this.resizer);
            newTable.addPropertyChangeListener("model", this.updateChangeListener);
            newTable.addPropertyChangeListener("componentOrientation", this.updateChangeListener);
        }
    }

    public final void disposeOldTable(@Nullable JTable oldTable, @Nullable JTable newTable) {
        this.changeTableAtPositionHelper(oldTable, newTable);
        if (oldTable != null) {
            oldTable.removeComponentListener(this.resizer);
            oldTable.removePropertyChangeListener("model", this.updateChangeListener);
            oldTable.removePropertyChangeListener("componentOrientation", this.updateChangeListener);
        }
    }

    protected final void changeTableAtPositionHelper(@Nullable JTable oldTable, @Nullable JTable newTable) {
        this.positionHelper.changeTable(oldTable, newTable);
    }

    public abstract void detachController();

    protected final void removeController() {
        if (this.columnsController != null) {
            this.detachController();
            this.remove(this.columnsController);
            this.columnsController = null;
        }
    }

    @NotNull
    public abstract ColumnsControllerPanel createColumnsController();

    protected void recreateController() {
        ColumnsControllerPanel newController;
        this.columnsController = newController = this.createColumnsController();
        this.add((Component)newController, "West");
        this.revalidate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.positionHelper.currentHeaderContainmentUpdate();
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.isVisible() != flag) {
            this.positionHelper.headerVisibilityChanged(flag);
        }
        super.setVisible(flag);
        this.positionHelper.headerVisibilityChanged(flag);
    }

    private static final void updateChangeListener$lambda$0(AdditionalTableHeader this$0, PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (Intrinsics.areEqual((Object)"model", (Object)evt.getPropertyName()) || Intrinsics.areEqual((Object)"componentOrientation", (Object)evt.getPropertyName())) {
            this$0.removeController();
            this$0.recreateController();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010!\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0019H&J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0004J\b\u0010&\u001a\u00020$H&J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010(\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020$H\u0004J\b\u0010.\u001a\u00020\nH&J\u0010\u0010/\u001a\u00020$2\u0006\u0010(\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0011R\u00020\u00000\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u00198\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u00063"}, d2={"Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel;", "Ljavax/swing/JPanel;", "Ljavax/swing/event/TableColumnModelListener;", "table", "Ljavax/swing/JTable;", "<init>", "(Ljavax/swing/JTable;)V", "getTable", "()Ljavax/swing/JTable;", "myPreferredSize", "Ljava/awt/Dimension;", "getMyPreferredSize", "()Ljava/awt/Dimension;", "setMyPreferredSize", "(Ljava/awt/Dimension;)V", "columns", "Ljava/util/LinkedList;", "Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel$AdditionalPanel;", "getColumns", "()Ljava/util/LinkedList;", "tableColumnModel", "Ljavax/swing/table/TableColumnModel;", "getTableColumnModel", "()Ljavax/swing/table/TableColumnModel;", "autoRun", "", "tableModel", "Ljavax/swing/table/TableModel;", "getTableModel", "()Ljavax/swing/table/TableModel;", "isCorrectModel", "", "()Z", "createColumn", "columnView", "detach", "", "update", "updateColumns", "columnAdded", "e", "Ljavax/swing/event/TableColumnModelEvent;", "columnRemoved", "columnSelectionChanged", "Ljavax/swing/event/ListSelectionEvent;", "placeComponents", "computeMyPreferredSize", "columnMarginChanged", "Ljavax/swing/event/ChangeEvent;", "columnMoved", "AdditionalPanel", "intellij.platform.ide"})
    public static abstract class ColumnsControllerPanel
    extends JPanel
    implements TableColumnModelListener {
        @NotNull
        private final JTable table;
        protected Dimension myPreferredSize;
        @NotNull
        private final LinkedList<AdditionalPanel> columns;
        @NotNull
        private final TableColumnModel tableColumnModel;
        @JvmField
        protected int autoRun;
        @NotNull
        private final TableModel tableModel;

        public ColumnsControllerPanel(@NotNull JTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super(null);
            this.table = table;
            this.columns = new LinkedList();
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            Intrinsics.checkNotNullExpressionValue((Object)tableColumnModel, (String)"getColumnModel(...)");
            this.tableColumnModel = tableColumnModel;
            TableModel tableModel = this.table.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)tableModel, (String)"getModel(...)");
            this.tableModel = tableModel;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        protected final Dimension getMyPreferredSize() {
            Dimension dimension = this.myPreferredSize;
            if (dimension != null) {
                return dimension;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPreferredSize");
            return null;
        }

        protected final void setMyPreferredSize(@NotNull Dimension dimension) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
            this.myPreferredSize = dimension;
        }

        @NotNull
        public final LinkedList<AdditionalPanel> getColumns() {
            return this.columns;
        }

        @NotNull
        protected final TableColumnModel getTableColumnModel() {
            return this.tableColumnModel;
        }

        @NotNull
        protected final TableModel getTableModel() {
            return this.tableModel;
        }

        protected final boolean isCorrectModel() {
            return this.tableModel == this.table.getModel();
        }

        @NotNull
        public abstract AdditionalPanel createColumn(int var1);

        public final void detach() {
            Iterator iterator = this.columns.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                AdditionalPanel column = (AdditionalPanel)e;
                column.detach();
            }
            this.tableColumnModel.removeColumnModelListener(this);
        }

        protected final void update() {
            ++this.autoRun;
            if (EDT.isCurrentThreadEdt()) {
                SwingUtilities.invokeLater(() -> ColumnsControllerPanel.update$lambda$0(this));
            } else {
                this.updateColumns();
            }
        }

        public abstract void updateColumns();

        @Override
        public void columnAdded(@NotNull TableColumnModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isCorrectModel()) {
                this.createColumn(e.getToIndex());
                this.update();
            }
        }

        @Override
        public void columnRemoved(@NotNull TableColumnModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isCorrectModel()) {
                AdditionalPanel additionalPanel = this.columns.remove(e.getFromIndex());
                Intrinsics.checkNotNullExpressionValue((Object)additionalPanel, (String)"removeAt(...)");
                AdditionalPanel fcp = additionalPanel;
                fcp.detach();
                this.remove(fcp);
                this.update();
            }
        }

        @Override
        public void columnSelectionChanged(@NotNull ListSelectionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        protected final void placeComponents() {
            Iterator<AdditionalPanel> it;
            int x = 0;
            Iterator<AdditionalPanel> iterator = it = Intrinsics.areEqual((Object)ComponentOrientation.RIGHT_TO_LEFT, (Object)this.table.getComponentOrientation()) ? this.columns.descendingIterator() : this.columns.iterator();
            while (it.hasNext()) {
                AdditionalPanel fcp = it.next();
                fcp.setBounds(x, 0, fcp.getMyWidth(), this.getMyPreferredSize().height);
                x += fcp.getMyWidth();
            }
            this.revalidate();
        }

        @NotNull
        public abstract Dimension computeMyPreferredSize();

        @Override
        public void columnMarginChanged(@NotNull ChangeEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.placeComponents();
        }

        @Override
        public void columnMoved(@NotNull TableColumnModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getFromIndex() != e.getToIndex()) {
                AdditionalPanel additionalPanel = this.columns.remove(e.getFromIndex());
                Intrinsics.checkNotNullExpressionValue((Object)additionalPanel, (String)"removeAt(...)");
                AdditionalPanel fcp = additionalPanel;
                this.columns.add(e.getToIndex(), fcp);
                this.placeComponents();
            }
            JTableHeader jTableHeader = this.table.getTableHeader();
            Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"getTableHeader(...)");
            JTableHeader header = jTableHeader;
            TableColumn tc = header.getDraggedColumn();
            if (tc != null) {
                boolean rightToLeft = Intrinsics.areEqual((Object)this.table.getComponentOrientation(), (Object)ComponentOrientation.RIGHT_TO_LEFT);
                Iterator<AdditionalPanel> it = rightToLeft ? this.columns.descendingIterator() : this.columns.iterator();
                AdditionalPanel previous = null;
                while (it.hasNext()) {
                    AdditionalPanel fcp = it.next();
                    if (fcp.getTableColumn() == tc) {
                        boolean overPreviousDragging;
                        Rectangle r = null;
                        double x = 0.0;
                        if (previous != null) {
                            r = previous.getBounds();
                            x = r.getX() + r.getWidth();
                        }
                        r = fcp.getBounds(r);
                        r.translate((int)(x - r.getX() + (double)header.getDraggedDistance()), 0);
                        fcp.setBounds(r);
                        if (rightToLeft) {
                            AdditionalPanel additionalPanel = previous = it.hasNext() ? it.next() : null;
                        }
                        if (previous == null) break;
                        int prevZOrder = this.getComponentZOrder(previous);
                        int zOrder = this.getComponentZOrder(fcp);
                        boolean bl = rightToLeft ? header.getDraggedDistance() > 0 : (overPreviousDragging = header.getDraggedDistance() < 0);
                        if (overPreviousDragging == zOrder < prevZOrder) break;
                        this.setComponentZOrder(previous, zOrder);
                        this.setComponentZOrder(fcp, prevZOrder);
                        break;
                    }
                    previous = fcp;
                }
            }
        }

        private static final void update$lambda$0(ColumnsControllerPanel this$0) {
            this$0.updateColumns();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel$AdditionalPanel;", "Ljavax/swing/JPanel;", "Ljava/beans/PropertyChangeListener;", "tableColumn", "Ljavax/swing/table/TableColumn;", "<init>", "(Lcom/intellij/ui/table/AdditionalTableHeader$ColumnsControllerPanel;Ljavax/swing/table/TableColumn;)V", "getTableColumn", "()Ljavax/swing/table/TableColumn;", "myWidth", "", "getMyWidth", "()I", "setMyWidth", "(I)V", "myHeight", "getMyHeight", "setMyHeight", "detach", "", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "updateHeight", "intellij.platform.ide"})
        public abstract class AdditionalPanel
        extends JPanel
        implements PropertyChangeListener {
            @NotNull
            private final TableColumn tableColumn;
            private int myWidth;
            private int myHeight;

            public AdditionalPanel(TableColumn tableColumn) {
                Intrinsics.checkNotNullParameter((Object)tableColumn, (String)"tableColumn");
                super(new BorderLayout());
                this.tableColumn = tableColumn;
            }

            @NotNull
            public final TableColumn getTableColumn() {
                return this.tableColumn;
            }

            public final int getMyWidth() {
                return this.myWidth;
            }

            public final void setMyWidth(int n) {
                this.myWidth = n;
            }

            public final int getMyHeight() {
                return this.myHeight;
            }

            public final void setMyHeight(int n) {
                this.myHeight = n;
            }

            public abstract void detach();

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                int newW = this.tableColumn.getWidth();
                if (this.myWidth != newW) {
                    this.myWidth = newW;
                    ColumnsControllerPanel.this.placeComponents();
                }
            }

            public abstract void updateHeight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/table/AdditionalTableHeader$Position;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "INLINE", "NONE", "REPLACE", "intellij.platform.ide"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position INLINE = new Position();
        public static final /* enum */ Position NONE = new Position();
        public static final /* enum */ Position REPLACE = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value2) {
            return Enum.valueOf(Position.class, value2);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.TOP, Position.INLINE, Position.NONE, Position.REPLACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

