/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.path.EelPathKt;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemUtil;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.RelativeIjentNioPath;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0016J\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\rH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0001H\u0016J!\u0010$\u001a\u00020\u00012\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\n\u0010)\u001a\u00020*H\u0096\u0080\u0004J\u0014\u0010+\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010,H\u0096\u0082\u0004J\n\u0010-\u001a\u00020\u0014H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath;", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "eelPath", "Lcom/intellij/platform/eel/path/EelPath;", "nioFs", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;", "cachedAttributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "<init>", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;Ljava/nio/file/attribute/BasicFileAttributes;)V", "getEelPath", "()Lcom/intellij/platform/eel/path/EelPath;", "isAbsolute", "", "getRoot", "getFileName", "toNioPath", "preserveAttributes", "getParent", "getNameCount", "", "getName", "index", "subpath", "beginIndex", "endIndex", "startsWith", "other", "Ljava/nio/file/Path;", "endsWith", "normalize", "resolve", "relativize", "toUri", "Ljava/net/URI;", "toAbsolutePath", "toRealPath", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "toString", "", "equals", "", "hashCode", "intellij.platform.ijent.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjentNioPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioPath.kt\ncom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n777#2:326\n873#2,2:327\n1849#2,3:329\n1849#2,3:332\n*S KotlinDebug\n*F\n+ 1 IjentNioPath.kt\ncom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath\n*L\n127#1:326\n127#1:327,2\n128#1:329,3\n165#1:332,3\n*E\n"})
public final class AbsoluteIjentNioPath
extends IjentNioPath {
    @NotNull
    private final EelPath eelPath;

    public AbsoluteIjentNioPath(@NotNull EelPath eelPath, @NotNull IjentNioFileSystem nioFs, @Nullable BasicFileAttributes cachedAttributes) {
        Intrinsics.checkNotNullParameter((Object)eelPath, (String)"eelPath");
        Intrinsics.checkNotNullParameter((Object)nioFs, (String)"nioFs");
        super(nioFs, cachedAttributes, null);
        this.eelPath = eelPath;
    }

    @NotNull
    public final EelPath getEelPath() {
        return this.eelPath;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    @Nullable
    public IjentNioPath getRoot() {
        return this.toNioPath(this.eelPath.getRoot(), false);
    }

    @Override
    @Nullable
    public IjentNioPath getFileName() {
        return this.createRelativePath(this, this.eelPath.getFileName());
    }

    private final IjentNioPath toNioPath(EelPath $this$toNioPath, boolean preserveAttributes) {
        return new AbsoluteIjentNioPath($this$toNioPath, this.getNioFs$intellij_platform_ijent_community_impl(), preserveAttributes ? (BasicFileAttributes)this.myCachedAttributes.get() : null);
    }

    @Override
    @Nullable
    public IjentNioPath getParent() {
        EelPath eelPath = this.eelPath.getParent();
        return eelPath != null ? this.toNioPath(eelPath, false) : null;
    }

    @Override
    public int getNameCount() {
        return this.eelPath.getNameCount();
    }

    @Override
    @NotNull
    public IjentNioPath getName(int index) {
        return this.createRelativePath(this, this.eelPath.getName(index));
    }

    @Override
    @NotNull
    public IjentNioPath subpath(int beginIndex, int endIndex) {
        return new RelativeIjentNioPath(this.eelPath.getParts().subList(beginIndex, endIndex), this.getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath) || !Intrinsics.areEqual((Object)((IjentNioPath)other).getFileSystem(), (Object)this.getFileSystem())) {
            return false;
        }
        IjentNioPath ijentNioPath = (IjentNioPath)other;
        if (ijentNioPath instanceof AbsoluteIjentNioPath) {
            return this.eelPath.startsWith(((AbsoluteIjentNioPath)other).eelPath);
        }
        if (ijentNioPath instanceof RelativeIjentNioPath) {
            return false;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath) || !Intrinsics.areEqual((Object)((IjentNioPath)other).getFileSystem(), (Object)this.getFileSystem())) {
            return false;
        }
        IjentNioPath ijentNioPath = (IjentNioPath)other;
        if (ijentNioPath instanceof AbsoluteIjentNioPath) {
            return Intrinsics.areEqual((Object)this.eelPath, (Object)((AbsoluteIjentNioPath)other).eelPath);
        }
        if (ijentNioPath instanceof RelativeIjentNioPath) {
            return this.eelPath.endsWith(((RelativeIjentNioPath)other).getSegments());
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public IjentNioPath normalize() {
        return this.toNioPath(this.eelPath.normalize(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IjentNioPath resolve(@NotNull Path other) {
        IjentNioPath ijentNioPath;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath)) {
            throw new ProviderMismatchException("Expected IJentNioPath, got " + other);
        }
        IjentNioPath ijentNioPath2 = (IjentNioPath)other;
        if (ijentNioPath2 instanceof AbsoluteIjentNioPath) {
            ijentNioPath = (IjentNioPath)other;
        } else if (ijentNioPath2 instanceof RelativeIjentNioPath) {
            void $this$fold$iv;
            void initial$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((RelativeIjentNioPath)other).getSegments();
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)".") && !Intrinsics.areEqual((Object)it, (Object)""))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List curatedSegments = (List)destination$iv$iv;
            $this$filter$iv = ((RelativeIjentNioPath)other).getSegments();
            EelPath $i$f$filter22 = this.eelPath;
            AbsoluteIjentNioPath absoluteIjentNioPath = this;
            boolean $i$f$fold = false;
            EelPath accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                Object element$iv$iv;
                element$iv$iv = (String)element$iv;
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.resolve((String)part);
            }
            ijentNioPath = absoluteIjentNioPath.toNioPath(accumulator$iv, curatedSegments.isEmpty());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ijentNioPath;
    }

    @Override
    @NotNull
    public IjentNioPath relativize(@NotNull Path other) {
        int firstDifferenceIndex;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        EelPath otherEelPath = IjentNioFileSystemUtil.toEelPath(other);
        if (!Intrinsics.areEqual((Object)this.eelPath.getRoot(), (Object)otherEelPath.getRoot())) {
            throw new EelPathException(((Object)other.getRoot()).toString(), "The other path has a different root");
        }
        for (firstDifferenceIndex = 0; firstDifferenceIndex < RangesKt.coerceAtMost((int)this.getNameCount(), (int)other.getNameCount()); ++firstDifferenceIndex) {
            boolean different = !Intrinsics.areEqual((Object)this.getName(firstDifferenceIndex), (Object)other.getName(firstDifferenceIndex));
            if (!different) continue;
        }
        List result2 = new ArrayList();
        int n = this.getNameCount() - firstDifferenceIndex;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ((Collection)result2).add("..");
        }
        n2 = other.getNameCount();
        for (int index = firstDifferenceIndex; index < n2; ++index) {
            ((Collection)result2).add(otherEelPath.getName(index));
        }
        return new RelativeIjentNioPath(result2, this.getNioFs$intellij_platform_ijent_community_impl());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public URI toUri() {
        void $this$fold$iv;
        String prefix = switch (WhenMappings.$EnumSwitchMapping$0[EelPathKt.getPlatform((EelPath)this.eelPath).ordinal()]) {
            case 1 -> "/" + StringsKt.replace$default((String)this.eelPath.getRoot().toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            case 2 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
        List allParts = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(prefix), (Iterable)this.eelPath.getParts());
        Iterable iterable = allParts;
        URI initial$iv = this.getNioFs$intellij_platform_ijent_community_impl().getUri$intellij_platform_ijent_community_impl();
        boolean $i$f$fold = false;
        URI accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            String string = (String)element$iv;
            URI p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.resolve((String)p1);
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public IjentNioPath toAbsolutePath() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IjentNioPath toRealPath(LinkOption ... options) {
        void normalizedPath;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        EelPath eelPath = this.eelPath.normalize();
        AbsoluteIjentNioPath absoluteIjentNioPath = this;
        boolean bl = false;
        return absoluteIjentNioPath.toNioPath((EelPath)(ArraysKt.contains((Object[])options, (Object)LinkOption.NOFOLLOW_LINKS) ? normalizedPath : (EelPath)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CanonicalizeError>>, Object>(this, (EelPath)normalizedPath, null){
            int label;
            final /* synthetic */ AbsoluteIjentNioPath this$0;
            final /* synthetic */ EelPath $normalizedPath;
            {
                this.this$0 = $receiver;
                this.$normalizedPath = $normalizedPath;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getNioFs$intellij_platform_ijent_community_impl().getIjentFs().canonicalize(this.$normalizedPath, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CanonicalizeError>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        })))), true);
    }

    @Override
    @NotNull
    public String toString() {
        return this.eelPath.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AbsoluteIjentNioPath && Intrinsics.areEqual((Object)this.eelPath, (Object)((AbsoluteIjentNioPath)other).eelPath) && Intrinsics.areEqual((Object)this.getNioFs$intellij_platform_ijent_community_impl(), (Object)((AbsoluteIjentNioPath)other).getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    public int hashCode() {
        return this.eelPath.hashCode() * 31 + this.getNioFs$intellij_platform_ijent_community_impl().hashCode();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EelOsFamily.values().length];
            try {
                nArray[EelOsFamily.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOsFamily.Posix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

