/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.ijent.community.impl.nio.AbsoluteIjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileStore;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemUtil;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.RelativeIjentNioPath;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import com.intellij.platform.ijent.fs.IjentFileSystemPosixApi;
import com.intellij.platform.ijent.fs.IjentFileSystemWindowsApi;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cH\u0016J)\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00152\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150 \"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0014\u0010)\u001a\u00020\u00122\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0082\u0004J\n\u0010,\u001a\u00020-H\u0096\u0080\u0004J\n\u0010.\u001a\u00020\u0015H\u0096\u0080\u0004J\f\u0010/\u001a\u00020\u0018*\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;", "Ljava/nio/file/FileSystem;", "fsProvider", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider;", "uri", "Ljava/net/URI;", "<init>", "(Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider;Ljava/net/URI;)V", "getUri$intellij_platform_ijent_community_impl", "()Ljava/net/URI;", "close", "", "provider", "ijentFs", "Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;", "getIjentFs", "()Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;", "isOpen", "", "isReadOnly", "getSeparator", "", "getRootDirectories", "", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "getFileStores", "Ljava/nio/file/FileStore;", "supportedFileAttributeViews", "", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "newWatchService", "Ljava/nio/file/WatchService;", "equals", "other", "", "hashCode", "", "toString", "toNioPath", "Lcom/intellij/platform/eel/path/EelPath;", "intellij.platform.ijent.community.impl"})
@SourceDebugExtension(value={"SMAP\nIjentNioFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioFileSystem.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n13471#2,3:106\n*S KotlinDebug\n*F\n+ 1 IjentNioFileSystem.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem\n*L\n71#1:106,3\n*E\n"})
public final class IjentNioFileSystem
extends FileSystem {
    @NotNull
    private final IjentNioFileSystemProvider fsProvider;
    @NotNull
    private final URI uri;

    public IjentNioFileSystem(@NotNull IjentNioFileSystemProvider fsProvider, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)fsProvider, (String)"fsProvider");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.fsProvider = fsProvider;
        this.uri = uri;
    }

    @NotNull
    public final URI getUri$intellij_platform_ijent_community_impl() {
        return this.uri;
    }

    @Override
    public void close() {
        this.fsProvider.close$intellij_platform_ijent_community_impl(this.uri);
    }

    @Override
    @NotNull
    public IjentNioFileSystemProvider provider() {
        return this.fsProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public final IjentFileSystemApi getIjentFs() {
        IjentFileSystemApi ijentFileSystemApi = this.fsProvider.ijentFsApi$intellij_platform_ijent_community_impl(this.uri);
        if (ijentFileSystemApi == null) {
            throw new FileSystemException("`" + this.uri + "` was removed from IJent FS providers");
        }
        return ijentFileSystemApi;
    }

    @Override
    public boolean isOpen() {
        return this.fsProvider.ijentFsApi$intellij_platform_ijent_community_impl(this.uri) != null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public String getSeparator() {
        String string;
        IjentFileSystemApi ijentFileSystemApi = this.getIjentFs();
        if (ijentFileSystemApi instanceof IjentFileSystemPosixApi) {
            string = "/";
        } else if (ijentFileSystemApi instanceof IjentFileSystemWindowsApi) {
            string = "\\";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public Iterable<IjentNioPath> getRootDirectories() {
        Iterable iterable;
        IjentFileSystemApi fs = this.getIjentFs();
        if (fs instanceof IjentFileSystemPosixApi) {
            iterable = CollectionsKt.listOf((Object)this.getPath("/", new String[0]));
        } else if (fs instanceof IjentFileSystemWindowsApi) {
            iterable = (Iterable)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super List<? extends IjentNioPath>>, Object>(fs, this, null){
                int label;
                final /* synthetic */ IjentFileSystemApi $fs;
                final /* synthetic */ IjentNioFileSystem this$0;
                {
                    this.$fs = $fs;
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = ((IjentFileSystemWindowsApi)this.$fs).getRootDirectories((Continuation)this);
                            if (v0 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var2_3 = (Iterable)v0;
                            var3_4 = this.this$0;
                            $i$f$map = false;
                            var5_6 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var10_11 = (EelPath)item$iv$iv;
                                var12_13 = destination$iv$iv;
                                $i$a$-map-IjentNioFileSystem$getRootDirectories$1$1 = false;
                                var12_13.add(IjentNioFileSystem.access$toNioPath(var3_4, (EelPath)it));
                            }
                            return (List)destination$iv$iv;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super List<? extends IjentNioPath>> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return iterable;
    }

    @Override
    @NotNull
    public Iterable<FileStore> getFileStores() {
        EelPath home = this.getIjentFs().getUser().getHome();
        return CollectionsKt.listOf((Object)new IjentNioFileStore(home, this.getIjentFs()));
    }

    @Override
    @NotNull
    public Set<String> supportedFileAttributeViews() {
        Set set;
        IjentFileSystemApi ijentFileSystemApi = this.getIjentFs();
        if (ijentFileSystemApi instanceof IjentFileSystemWindowsApi) {
            Object[] objectArray = new String[]{"basic", "dos", "acl", "owner", "user"};
            set = SetsKt.setOf((Object[])objectArray);
        } else if (ijentFileSystemApi instanceof IjentFileSystemPosixApi) {
            Object[] objectArray = new String[]{"basic", "posix", "unix", "owner", "user"};
            set = SetsKt.setOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IjentNioPath getPath(@NotNull String first, String ... more) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        try {
            void $this$fold$iv;
            void initial$iv;
            object = more;
            EelPath eelPath = EelPath.Companion.parse(first, this.getIjentFs().getDescriptor());
            IjentNioFileSystem ijentNioFileSystem = this;
            boolean $i$f$fold = false;
            EelPath accumulator$iv = initial$iv;
            int n = ((void)$this$fold$iv).length;
            for (int i = 0; i < n; ++i) {
                void newPart;
                void element$iv;
                void var10_13 = element$iv = $this$fold$iv[i];
                void path = accumulator$iv;
                boolean bl = false;
                accumulator$iv = path.resolve((String)newPart);
            }
            object = ijentNioFileSystem.toNioPath(accumulator$iv);
        }
        catch (EelPathException eelPathException) {
            char[] cArray = EelPlatformKt.getDirectorySeparators((EelOsFamily)this.getIjentFs().getDescriptor().getOsFamily());
            object = new RelativeIjentNioPath(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)first, (char[])Arrays.copyOf(cArray, cArray.length), (boolean)false, (int)0, (int)6, null), (Object[])more), this);
        }
        return object;
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@NotNull String syntaxAndPattern) {
        Intrinsics.checkNotNullParameter((Object)syntaxAndPattern, (String)"syntaxAndPattern");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public WatchService newWatchService() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IjentNioFileSystem && Intrinsics.areEqual((Object)((IjentNioFileSystem)other).uri, (Object)this.uri) && Intrinsics.areEqual((Object)((IjentNioFileSystem)other).fsProvider, (Object)this.fsProvider);
    }

    public int hashCode() {
        return this.fsProvider.hashCode() * 31 + this.uri.hashCode();
    }

    @NotNull
    public String toString() {
        return "IjentNioFileSystem(uri=" + this.uri + ")";
    }

    private final IjentNioPath toNioPath(EelPath $this$toNioPath) {
        return new AbsoluteIjentNioPath($this$toNioPath, this, null);
    }

    public static final /* synthetic */ IjentNioPath access$toNioPath(IjentNioFileSystem $this, EelPath $receiver) {
        return $this.toNioPath($receiver);
    }
}

