/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.impl.hyperv;

import com.intellij.platform.ijent.impl.hyperv.HyperV;
import com.sun.jna.LastErrorException;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ijent/impl/hyperv/HyperVSocket;", "", "pointer", "Lcom/sun/jna/Pointer;", "canceled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "<init>", "(Lcom/sun/jna/Pointer;Ljava/util/concurrent/atomic/AtomicBoolean;)V", "read", "", "buf", "Ljava/nio/ByteBuffer;", "acceptableErrorCodesOfCancellation", "", "checkCancellation", "", "e", "Lcom/sun/jna/LastErrorException;", "write", "intellij.platform.ijent.impl"})
public final class HyperVSocket {
    @NotNull
    private final Pointer pointer;
    @NotNull
    private final AtomicBoolean canceled;
    @NotNull
    private final Set<Integer> acceptableErrorCodesOfCancellation;

    public HyperVSocket(@NotNull Pointer pointer, @NotNull AtomicBoolean canceled) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)canceled, (String)"canceled");
        this.pointer = pointer;
        this.canceled = canceled;
        Object[] objectArray = new Integer[]{10058, 10053, 10038};
        this.acceptableErrorCodesOfCancellation = SetsKt.setOf((Object[])objectArray);
    }

    public final int read(@NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            int bytesRead = HyperV.SocketLibrary.recv(this.pointer, buf, buf.remaining(), 0);
            buf.position(buf.position() + bytesRead);
            return bytesRead;
        }
        catch (LastErrorException e) {
            this.checkCancellation(e);
            throw new IOException(e);
        }
    }

    private final void checkCancellation(LastErrorException e) {
        if (this.acceptableErrorCodesOfCancellation.contains(e.getErrorCode()) && this.canceled.get()) {
            throw ExceptionsKt.CancellationException((String)"Read is cancelled by the outer scope", (Throwable)e);
        }
    }

    public final int write(@NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            int bytesWritten = HyperV.SocketLibrary.send(this.pointer, buf, buf.remaining(), 0);
            buf.position(buf.position() + bytesWritten);
            return bytesWritten;
        }
        catch (LastErrorException e) {
            this.checkCancellation(e);
            throw new IOException(e);
        }
    }
}

