/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.testFramework.common.validators;

import com.intellij.platform.ijent.testFramework.common.DataHelpersKt;
import com.intellij.platform.ijent.testFramework.functional.fs.Delay;
import io.kotest.assertions.ErrorCollectorKt;
import io.kotest.assertions.Exceptions;
import io.kotest.assertions.jvmerrorcollector;
import io.kotest.matchers.ShouldKt;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.TimeoutCancellationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ijent/testFramework/common/validators/FileTimeChecker;", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "accessTime", "Ljava/nio/file/attribute/FileTime;", "modifiedTime", "accessTimeCalls", "Ljava/util/concurrent/atomic/AtomicInteger;", "modifiedTimeCalls", "assertAccessTimeChanged", "", "assertAccessTimeDidNotChange", "assertModifiedTimeChanged", "assertModifiedTimeDidNotChange", "intellij.platform.ijent.testFramework"})
@SourceDebugExtension(value={"SMAP\nFileTimeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTimeChecker.kt\ncom/intellij/platform/ijent/testFramework/common/validators/FileTimeChecker\n+ 2 clues.kt\nio/kotest/assertions/CluesKt\n*L\n1#1,92:1\n13#2:93\n42#2:94\n24#2,8:95\n13#2:103\n42#2:104\n24#2,8:105\n13#2:113\n42#2:114\n24#2,8:115\n13#2:123\n42#2:124\n24#2,8:125\n*S KotlinDebug\n*F\n+ 1 FileTimeChecker.kt\ncom/intellij/platform/ijent/testFramework/common/validators/FileTimeChecker\n*L\n33#1:93\n33#1:94\n33#1:95,8\n49#1:103\n49#1:104\n49#1:105,8\n65#1:113\n65#1:114\n65#1:115,8\n81#1:123\n81#1:124\n81#1:125,8\n*E\n"})
public final class FileTimeChecker {
    @NotNull
    private final Path path;
    @NotNull
    private FileTime accessTime;
    @NotNull
    private FileTime modifiedTime;
    @NotNull
    private final AtomicInteger accessTimeCalls;
    @NotNull
    private final AtomicInteger modifiedTimeCalls;

    public FileTimeChecker(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.accessTimeCalls = new AtomicInteger();
        this.modifiedTimeCalls = new AtomicInteger();
        Delay.INSTANCE.hundredMilliseconds();
        BasicFileAttributes attrs = DataHelpersKt.readBasicAttributes(this.path);
        FileTime fileTime = attrs.lastAccessTime();
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"lastAccessTime(...)");
        this.accessTime = fileTime;
        FileTime fileTime2 = attrs.lastModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"lastModifiedTime(...)");
        this.modifiedTime = fileTime2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertAccessTimeChanged() {
        this.accessTimeCalls.incrementAndGet();
        Delay.INSTANCE.hundredMilliseconds();
        String clue$iv = "Access time should be changed for " + this.path + ". Access time call number: " + this.accessTimeCalls.get();
        boolean $i$f$withClue = false;
        String $this$asClue$iv$iv = clue$iv;
        boolean $i$f$asClue = false;
        Lazy clue$iv$iv$iv = LazyKt.lazy((Function0)((Function0)new Function0<String>((Object)$this$asClue$iv$iv){
            final /* synthetic */ Object $this_asClue;
            {
                this.$this_asClue = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return String.valueOf(this.$this_asClue);
            }
        }));
        boolean $i$f$withClue2 = false;
        try {
            jvmerrorcollector.getErrorCollector().pushClue((Function0)new Function0<String>(clue$iv$iv$iv){
                final /* synthetic */ Lazy $clue;
                {
                    this.$clue = $clue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return String.valueOf(this.$clue.getValue());
                }
            });
            boolean bl = false;
            String it$iv = $this$asClue$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            FileTime currentAccessTime = DataHelpersKt.readBasicAttributes(this.path).lastAccessTime();
            try {
                ShouldKt.shouldNotBe((Object)currentAccessTime, (Object)this.accessTime);
            }
            finally {
                Intrinsics.checkNotNull((Object)currentAccessTime);
                this.accessTime = currentAccessTime;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (TimeoutCancellationException t$iv$iv$iv) {
            StringBuilder stringBuilder = new StringBuilder().append(ErrorCollectorKt.clueContextAsString());
            String string = t$iv$iv$iv.getMessage();
            if (string == null) {
                string = "";
            }
            throw Exceptions.INSTANCE.createAssertionError(stringBuilder.append(string).toString(), (Throwable)t$iv$iv$iv);
        }
        finally {
            jvmerrorcollector.getErrorCollector().popClue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertAccessTimeDidNotChange() {
        this.accessTimeCalls.incrementAndGet();
        Delay.INSTANCE.hundredMilliseconds();
        String clue$iv = "Access time should NOT be changed for " + this.path + ". Access time call number: " + this.accessTimeCalls.get();
        boolean $i$f$withClue = false;
        String $this$asClue$iv$iv = clue$iv;
        boolean $i$f$asClue = false;
        Lazy clue$iv$iv$iv = LazyKt.lazy((Function0)((Function0)new Function0<String>((Object)$this$asClue$iv$iv){
            final /* synthetic */ Object $this_asClue;
            {
                this.$this_asClue = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return String.valueOf(this.$this_asClue);
            }
        }));
        boolean $i$f$withClue2 = false;
        try {
            jvmerrorcollector.getErrorCollector().pushClue((Function0)new Function0<String>(clue$iv$iv$iv){
                final /* synthetic */ Lazy $clue;
                {
                    this.$clue = $clue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return String.valueOf(this.$clue.getValue());
                }
            });
            boolean bl = false;
            String it$iv = $this$asClue$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            FileTime currentAccessTime = DataHelpersKt.readBasicAttributes(this.path).lastAccessTime();
            try {
                ShouldKt.shouldBe((Object)currentAccessTime, (Object)this.accessTime);
            }
            finally {
                Intrinsics.checkNotNull((Object)currentAccessTime);
                this.accessTime = currentAccessTime;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (TimeoutCancellationException t$iv$iv$iv) {
            StringBuilder stringBuilder = new StringBuilder().append(ErrorCollectorKt.clueContextAsString());
            String string = t$iv$iv$iv.getMessage();
            if (string == null) {
                string = "";
            }
            throw Exceptions.INSTANCE.createAssertionError(stringBuilder.append(string).toString(), (Throwable)t$iv$iv$iv);
        }
        finally {
            jvmerrorcollector.getErrorCollector().popClue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertModifiedTimeChanged() {
        this.modifiedTimeCalls.incrementAndGet();
        Delay.INSTANCE.hundredMilliseconds();
        String clue$iv = "Modified time should be changed for " + this.path + ". Modified time call number: " + this.accessTimeCalls.get();
        boolean $i$f$withClue = false;
        String $this$asClue$iv$iv = clue$iv;
        boolean $i$f$asClue = false;
        Lazy clue$iv$iv$iv = LazyKt.lazy((Function0)((Function0)new Function0<String>((Object)$this$asClue$iv$iv){
            final /* synthetic */ Object $this_asClue;
            {
                this.$this_asClue = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return String.valueOf(this.$this_asClue);
            }
        }));
        boolean $i$f$withClue2 = false;
        try {
            jvmerrorcollector.getErrorCollector().pushClue((Function0)new Function0<String>(clue$iv$iv$iv){
                final /* synthetic */ Lazy $clue;
                {
                    this.$clue = $clue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return String.valueOf(this.$clue.getValue());
                }
            });
            boolean bl = false;
            String it$iv = $this$asClue$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            FileTime currentModifiedTime = DataHelpersKt.readBasicAttributes(this.path).lastModifiedTime();
            try {
                ShouldKt.shouldNotBe((Object)currentModifiedTime, (Object)this.modifiedTime);
            }
            finally {
                Intrinsics.checkNotNull((Object)currentModifiedTime);
                this.modifiedTime = currentModifiedTime;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (TimeoutCancellationException t$iv$iv$iv) {
            StringBuilder stringBuilder = new StringBuilder().append(ErrorCollectorKt.clueContextAsString());
            String string = t$iv$iv$iv.getMessage();
            if (string == null) {
                string = "";
            }
            throw Exceptions.INSTANCE.createAssertionError(stringBuilder.append(string).toString(), (Throwable)t$iv$iv$iv);
        }
        finally {
            jvmerrorcollector.getErrorCollector().popClue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertModifiedTimeDidNotChange() {
        this.modifiedTimeCalls.incrementAndGet();
        Delay.INSTANCE.hundredMilliseconds();
        String clue$iv = "Modified time should NOT be changed for " + this.path + ". Modified time call number: " + this.accessTimeCalls.get();
        boolean $i$f$withClue = false;
        String $this$asClue$iv$iv = clue$iv;
        boolean $i$f$asClue = false;
        Lazy clue$iv$iv$iv = LazyKt.lazy((Function0)((Function0)new Function0<String>((Object)$this$asClue$iv$iv){
            final /* synthetic */ Object $this_asClue;
            {
                this.$this_asClue = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return String.valueOf(this.$this_asClue);
            }
        }));
        boolean $i$f$withClue2 = false;
        try {
            jvmerrorcollector.getErrorCollector().pushClue((Function0)new Function0<String>(clue$iv$iv$iv){
                final /* synthetic */ Lazy $clue;
                {
                    this.$clue = $clue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return String.valueOf(this.$clue.getValue());
                }
            });
            boolean bl = false;
            String it$iv = $this$asClue$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            FileTime currentModifiedTime = DataHelpersKt.readBasicAttributes(this.path).lastModifiedTime();
            try {
                ShouldKt.shouldBe((Object)currentModifiedTime, (Object)this.modifiedTime);
            }
            finally {
                Intrinsics.checkNotNull((Object)currentModifiedTime);
                this.modifiedTime = currentModifiedTime;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (TimeoutCancellationException t$iv$iv$iv) {
            StringBuilder stringBuilder = new StringBuilder().append(ErrorCollectorKt.clueContextAsString());
            String string = t$iv$iv$iv.getMessage();
            if (string == null) {
                string = "";
            }
            throw Exceptions.INSTANCE.createAssertionError(stringBuilder.append(string).toString(), (Throwable)t$iv$iv$iv);
        }
        finally {
            jvmerrorcollector.getErrorCollector().popClue();
        }
    }
}

