/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.testFramework.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.ijent.testFramework.common.EelTestEnvironment;
import com.intellij.platform.ijent.testFramework.common.EelTestEnvironmentHolder;
import com.intellij.platform.ijent.testFramework.functional.fixture.EelFixture;
import com.intellij.platform.ijent.testFramework.functional.fixture.IjentFixture;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.IdeaTestFixtureFactoryImpl;
import com.intellij.testFramework.utils.io.NioPathUtilKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/ijent/testFramework/common/IdeaEelProjectTestFixture;", "Lcom/intellij/testFramework/fixtures/IdeaProjectTestFixture;", "name", "", "fixtureFileSystemRoot", "directoryBasedProject", "", "fixtureFactory", "Lcom/intellij/platform/ijent/testFramework/functional/fixture/IjentFixture$Factory;", "Lcom/intellij/platform/ijent/testFramework/functional/fixture/IjentFixture;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/platform/ijent/testFramework/functional/fixture/IjentFixture$Factory;)V", "environment", "Lcom/intellij/platform/ijent/testFramework/common/EelTestEnvironment;", "Lcom/intellij/platform/ijent/testFramework/functional/fixture/EelFixture;", "delegate", "myDir", "Ljava/nio/file/Path;", "getProject", "Lcom/intellij/openapi/project/Project;", "getModule", "Lcom/intellij/openapi/module/Module;", "setUp", "", "tearDown", "getTestRootDisposable", "Lcom/intellij/openapi/Disposable;", "cleanup", "setupTestFolder", "intellij.platform.ijent.testFramework"})
public final class IdeaEelProjectTestFixture
implements IdeaProjectTestFixture {
    @NotNull
    private final String name;
    @NotNull
    private final String fixtureFileSystemRoot;
    private final boolean directoryBasedProject;
    @NotNull
    private final IjentFixture.Factory<? extends IjentFixture> fixtureFactory;
    private EelTestEnvironment<EelFixture> environment;
    private IdeaProjectTestFixture delegate;
    private Path myDir;

    public IdeaEelProjectTestFixture(@NotNull String name, @NotNull String fixtureFileSystemRoot, boolean directoryBasedProject, @NotNull IjentFixture.Factory<? extends IjentFixture> fixtureFactory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fixtureFileSystemRoot, (String)"fixtureFileSystemRoot");
        Intrinsics.checkNotNullParameter(fixtureFactory, (String)"fixtureFactory");
        this.name = name;
        this.fixtureFileSystemRoot = fixtureFileSystemRoot;
        this.directoryBasedProject = directoryBasedProject;
        this.fixtureFactory = fixtureFactory;
    }

    @NotNull
    public Project getProject() {
        IdeaProjectTestFixture ideaProjectTestFixture = this.delegate;
        if (ideaProjectTestFixture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            ideaProjectTestFixture = null;
        }
        Project project = ideaProjectTestFixture.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Nullable
    public Module getModule() {
        IdeaProjectTestFixture ideaProjectTestFixture = this.delegate;
        if (ideaProjectTestFixture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            ideaProjectTestFixture = null;
        }
        return ideaProjectTestFixture.getModule();
    }

    public void setUp() {
        IdeaTestFixtureFactory ideaTestFixtureFactory = IdeaTestFixtureFactoryImpl.getFixtureFactory();
        Intrinsics.checkNotNullExpressionValue((Object)ideaTestFixtureFactory, (String)"getFixtureFactory(...)");
        IdeaTestFixtureFactory delegateFactory = ideaTestFixtureFactory;
        TestFixtureBuilder factory = delegateFactory.createFixtureBuilder(this.name, (arg_0, arg_1) -> IdeaEelProjectTestFixture.setUp$lambda$0(this, arg_0, arg_1), this.directoryBasedProject);
        IdeaTestFixture ideaTestFixture = factory.getFixture();
        Intrinsics.checkNotNullExpressionValue((Object)ideaTestFixture, (String)"getFixture(...)");
        this.delegate = (IdeaProjectTestFixture)ideaTestFixture;
        IdeaProjectTestFixture ideaProjectTestFixture = this.delegate;
        if (ideaProjectTestFixture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            ideaProjectTestFixture = null;
        }
        ideaProjectTestFixture.setUp();
        String[] stringArray = new String[]{this.fixtureFileSystemRoot};
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])stringArray);
    }

    public void tearDown() {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[]{() -> IdeaEelProjectTestFixture.tearDown$lambda$0(this), () -> IdeaEelProjectTestFixture.tearDown$lambda$1(this)};
        RunAll runAll = new RunAll(throwableRunnableArray);
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        IdeaProjectTestFixture ideaProjectTestFixture = this.delegate;
        if (ideaProjectTestFixture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            ideaProjectTestFixture = null;
        }
        Disposable disposable = ideaProjectTestFixture.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        return disposable;
    }

    private final void cleanup() {
        Path path = this.myDir;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDir");
            path = null;
        }
        NioPathUtilKt.deleteRecursively((Path)path);
    }

    private final Path setupTestFolder() {
        EelTestEnvironment<EelFixture> eelTestEnvironment = this.environment;
        if (eelTestEnvironment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            eelTestEnvironment = null;
        }
        EelPath remoteFileSystemTestRoot = EelFileSystemApiKt.getPath((EelFileSystemApi)eelTestEnvironment.getEelFixture().getEelApi().getFs(), (String)"/test_env");
        String string = FileUtil.sanitizeFileName((String)this.name, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        Path remoteTestFolder = TemporaryDirectory.Companion.generateTemporaryPath(string, EelNioBridgeServiceKt.asNioPath((EelPath)remoteFileSystemTestRoot));
        PathKt.createDirectories((Path)remoteTestFolder);
        return remoteTestFolder;
    }

    private static final Path setUp$lambda$0(IdeaEelProjectTestFixture this$0, String testName, Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this$0.environment = EelTestEnvironmentHolder.get$default(EelTestEnvironmentHolder.INSTANCE, this$0.fixtureFileSystemRoot, this$0.fixtureFactory, null, 4, null);
        this$0.myDir = this$0.setupTestFolder();
        Path path = this$0.myDir;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDir");
            path = null;
        }
        Path projectPathPath = path.resolve("project");
        Intrinsics.checkNotNull((Object)projectPathPath);
        NioPathUtilKt.createDirectory((Path)projectPathPath);
        return projectPathPath;
    }

    private static final void tearDown$lambda$0(IdeaEelProjectTestFixture this$0) {
        this$0.cleanup();
    }

    private static final void tearDown$lambda$1(IdeaEelProjectTestFixture this$0) {
        IdeaProjectTestFixture ideaProjectTestFixture = this$0.delegate;
        if (ideaProjectTestFixture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            ideaProjectTestFixture = null;
        }
        ideaProjectTestFixture.tearDown();
    }
}

