/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.EnvironmentUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.images.ImagesBundle;
import org.intellij.images.actions.EditExternallyActionKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.impl.ImagesConfigurable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/actions/EditExternallyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "performActionWithBackingFile", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nEditExternallyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditExternallyAction.kt\norg/intellij/images/actions/EditExternallyAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n221#2,2:180\n23#3:182\n*S KotlinDebug\n*F\n+ 1 EditExternallyAction.kt\norg/intellij/images/actions/EditExternallyAction\n*L\n73#1:180,2\n133#1:182\n*E\n"})
public final class EditExternallyAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile imageFile = virtualFile;
        if (VirtualFileUtil.toNioPathOrNull((VirtualFile)imageFile) != null) {
            this.actionPerformed(e, imageFile);
        } else {
            this.performActionWithBackingFile(e, imageFile);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = enabled = file != null && ImageFileTypeManager.getInstance().isImage(file);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void actionPerformed(AnActionEvent e, VirtualFile imageFile) {
        String executablePath = null;
        String string = PropertiesComponent.getInstance().getValue("Images.ExternalEditorPath", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        executablePath = string;
        if (!StringUtil.isEmpty((String)executablePath)) {
            String path;
            Object object;
            Map map = EnvironmentUtil.getEnvironmentMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                String string2;
                object = element$iv;
                boolean bl = false;
                String varName = (String)object.getKey();
                String varValue = (String)object.getValue();
                if (SystemInfo.isWindows) {
                    String string3 = StringUtil.replace((String)executablePath, (String)("%" + varName + "%"), (String)varValue, (boolean)true);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"replace(...)");
                } else {
                    String string4 = StringUtil.replace((String)executablePath, (String)("${" + varName + "}"), (String)varValue, (boolean)false);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"replace(...)");
                }
                executablePath = string2;
            }
            String string5 = FileUtil.toSystemDependentName((String)executablePath);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemDependentName(...)");
            executablePath = string5;
            File executable = new File(executablePath);
            GeneralCommandLine commandLine = new GeneralCommandLine();
            String string6 = path = executable.exists() ? executable.getAbsolutePath() : executablePath;
            if (SystemInfo.isMac) {
                commandLine.setExePath(ExecUtil.getOpenCommandPath());
                commandLine.addParameter("-a");
                commandLine.addParameter(path);
            } else {
                commandLine.setExePath(path);
            }
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (imageFile.isInLocalFileSystem() && typeManager.isImage(imageFile)) {
                commandLine.addParameter(VfsUtilCore.virtualToIoFile((VirtualFile)imageFile).getAbsolutePath());
            }
            commandLine.setWorkDirectory(new File(executablePath).getParentFile());
            try {
                object = commandLine.createProcess();
                Intrinsics.checkNotNull((Object)object);
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                ImagesConfigurable.show(e.getProject());
                object = Unit.INSTANCE;
            }
        } else {
            try {
                Desktop.getDesktop().open(imageFile.toNioPath().toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void performActionWithBackingFile(AnActionEvent e, VirtualFile imageFile) {
        try {
            Disposable disposable = EditExternallyActionKt.access$getDisposable(e);
            CoroutineScope coroutineScope = e.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(imageFile, disposable, this, e, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ VirtualFile $imageFile;
                final /* synthetic */ Disposable $disposable;
                final /* synthetic */ EditExternallyAction this$0;
                final /* synthetic */ AnActionEvent $e;
                {
                    this.$imageFile = $imageFile;
                    this.$disposable = $disposable;
                    this.this$0 = $receiver;
                    this.$e = $e;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object2;
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                VirtualFile backingFile = EditExternallyActionKt.access$copyToBackingFile(this.$imageFile, this.$disposable);
                                EditExternallyAction.access$actionPerformed(this.this$0, this.$e, backingFile);
                                return Unit.INSTANCE;
                            }
                            catch (IllegalStateException e) {
                                void $this$launch;
                                void $this$thisLogger$iv = $this$launch;
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(CoroutineScope.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.warn("Failed to open external image editor", (Throwable)e);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                                this.label = 1;
                                object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                    int label;

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Messages.showErrorDialog((String)ImagesBundle.message("error.cannot.edit.image.external.editor", new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                        }
                        case 1: {
                            IllegalStateException e = (IllegalStateException)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (IllegalStateException e2) {
            EditExternallyAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditExternallyAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to open external image editor", (Throwable)e2);
            Messages.showErrorDialog((String)ImagesBundle.message("error.cannot.edit.image.external.editor", new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
        }
    }

    public static final /* synthetic */ void access$actionPerformed(EditExternallyAction $this, AnActionEvent e, VirtualFile imageFile) {
        $this.actionPerformed(e, imageFile);
    }
}

