/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ui.ImageComponentDecorator;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"copyToBackingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposable", "Lcom/intellij/openapi/Disposable;", "safeDelete", "", "Ljava/nio/file/Path;", "getDisposable", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.images"})
public final class EditExternallyActionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VirtualFile copyToBackingFile(VirtualFile $this$copyToBackingFile, Disposable disposable) {
        Path filePath = Files.createTempFile("EditExternallyAction (copy)", $this$copyToBackingFile.getName(), new FileAttribute[0]);
        Disposer.register((Disposable)disposable, () -> EditExternallyActionKt.copyToBackingFile$lambda$0(filePath));
        Closeable closeable = $this$copyToBackingFile.getInputStream();
        Throwable throwable = null;
        try {
            long l;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            try {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                l = Files.copy(inputStream, filePath, copyOptionArray);
            }
            catch (IOException e) {
                Intrinsics.checkNotNull((Object)filePath);
                EditExternallyActionKt.safeDelete(filePath);
                throw new IllegalStateException("Failed to create backing file", e);
            }
            long l2 = l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(filePath);
        if (virtualFile == null) {
            throw new IllegalStateException("Failed to create virtual file");
        }
        return virtualFile;
    }

    private static final void safeDelete(Path $this$safeDelete) {
        try {
            NioFiles.deleteRecursively((Path)$this$safeDelete);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final Disposable getDisposable(AnActionEvent $this$getDisposable) {
        ImageComponentDecorator data = (ImageComponentDecorator)$this$getDisposable.getData(ImageComponentDecorator.DATA_KEY);
        if (data instanceof Disposable) {
            return (Disposable)data;
        }
        FileEditor fileEditor = (FileEditor)$this$getDisposable.getData(PlatformCoreDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            throw new IllegalStateException("Component does not provide a Disposable object");
        }
        return (Disposable)fileEditor;
    }

    private static final void copyToBackingFile$lambda$0(Path $filePath) {
        Intrinsics.checkNotNull((Object)$filePath);
        EditExternallyActionKt.safeDelete($filePath);
    }

    public static final /* synthetic */ Disposable access$getDisposable(AnActionEvent $receiver) {
        return EditExternallyActionKt.getDisposable($receiver);
    }

    public static final /* synthetic */ VirtualFile access$copyToBackingFile(VirtualFile $receiver, Disposable disposable) {
        return EditExternallyActionKt.copyToBackingFile($receiver, disposable);
    }
}

