/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.BinarizationThresholdConfig;
import org.intellij.images.scientific.action.BaseImageActionKt;
import org.intellij.images.scientific.action.BinarizeImageAction;
import org.intellij.images.scientific.action.ImageOperationMode;
import org.intellij.images.scientific.action.ImageOperationsActionGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/images/scientific/action/ConfigureBinarization;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "openConfigurationDialog", "project", "Lcom/intellij/openapi/project/Project;", "event", "ThresholdDialogWrapper", "intellij.platform.images"})
public final class ConfigureBinarization
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.openConfigurationDialog(e.getProject(), e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void openConfigurationDialog(Project project, AnActionEvent event) {
        ThresholdDialogWrapper dialog;
        boolean wasBinarized;
        VirtualFile imageFile;
        BinarizationThresholdConfig thresholdConfig = BinarizationThresholdConfig.Companion.getInstance();
        VirtualFile virtualFile = imageFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        ImageOperationMode originalMode = virtualFile != null ? (ImageOperationMode)((Object)virtualFile.getUserData(BaseImageActionKt.getCURRENT_OPERATION_MODE_KEY())) : null;
        int originalThreshold = thresholdConfig.getThreshold();
        boolean bl = wasBinarized = originalMode == ImageOperationMode.BINARIZE_IMAGE;
        if (!wasBinarized) {
            ImageOperationMode.BINARIZE_IMAGE.executeAction(event);
        }
        if ((dialog = new ThresholdDialogWrapper(project, originalThreshold, event)).showAndGet()) {
            int newThreshold = dialog.getThreshold();
            if (newThreshold != originalThreshold) {
                thresholdConfig.setThreshold(newThreshold);
            }
        } else {
            thresholdConfig.setThreshold(originalThreshold);
            ImageOperationMode imageOperationMode = originalMode;
            if (imageOperationMode == null) {
                imageOperationMode = ImageOperationMode.ORIGINAL_IMAGE;
            }
            ImageOperationMode modeToRestore = imageOperationMode;
            modeToRestore.executeAction(event);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/intellij/images/scientific/action/ConfigureBinarization$ThresholdDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "initialValue", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "<init>", "(Lcom/intellij/openapi/project/Project;ILcom/intellij/openapi/actionSystem/AnActionEvent;)V", "thresholdValue", "threshold", "getThreshold", "()I", "doOKAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "intellij.platform.images"})
    private static final class ThresholdDialogWrapper
    extends DialogWrapper {
        @NotNull
        private final AnActionEvent event;
        private int thresholdValue;

        public ThresholdDialogWrapper(@Nullable Project project, int initialValue, @NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super(project);
            this.event = event;
            this.thresholdValue = RangesKt.coerceIn((int)initialValue, (int)0, (int)255);
            this.setTitle(ImagesBundle.message("image.binarize.dialog.title", new Object[0]));
            this.setResizable(true);
            this.init();
        }

        public final int getThreshold() {
            return this.thresholdValue;
        }

        protected void doOKAction() {
            super.doOKAction();
            AnAction actionGroup = ActionManager.getInstance().getAction("Images.ImageOperationsGroup");
            if (actionGroup instanceof ImageOperationsActionGroup) {
                ((ImageOperationsActionGroup)actionGroup).updateSelectedMode(ImageOperationMode.BINARIZE_IMAGE);
            }
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JSlider jSlider;
            JSlider $this$createCenterPanel_u24lambda_u240 = jSlider = new JSlider(0, 255, this.thresholdValue);
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setMajorTickSpacing(50);
            $this$createCenterPanel_u24lambda_u240.setMinorTickSpacing(5);
            $this$createCenterPanel_u24lambda_u240.setPaintTicks(true);
            $this$createCenterPanel_u24lambda_u240.setPaintLabels(true);
            $this$createCenterPanel_u24lambda_u240.setValue(this.thresholdValue);
            $this$createCenterPanel_u24lambda_u240.addChangeListener(arg_0 -> ThresholdDialogWrapper.createCenterPanel$lambda$0$0(this, $this$createCenterPanel_u24lambda_u240, arg_0));
            JSlider slider = jSlider;
            Object object = new Object[]{this.thresholdValue};
            object = new JLabel(ImagesBundle.message("scientific.threshold.value", (Object[])object));
            Object $this$createCenterPanel_u24lambda_u241 = object;
            boolean bl2 = false;
            slider.addChangeListener(arg_0 -> ThresholdDialogWrapper.createCenterPanel$lambda$1$0((JLabel)$this$createCenterPanel_u24lambda_u241, slider, arg_0));
            Object valueLabel = object;
            Object $this$createCenterPanel_u24lambda_u242 = object = new JPanel(new BorderLayout());
            boolean bl3 = false;
            ((Container)$this$createCenterPanel_u24lambda_u242).add((Component)slider, "Center");
            ((Container)$this$createCenterPanel_u24lambda_u242).add((Component)valueLabel, "South");
            ((JComponent)$this$createCenterPanel_u24lambda_u242).setBorder(JBUI.Borders.empty((int)10));
            return (JComponent)object;
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            return this.createCenterPanel();
        }

        private static final void createCenterPanel$lambda$0$0(ThresholdDialogWrapper this$0, JSlider $this_apply, ChangeEvent it) {
            this$0.thresholdValue = $this_apply.getValue();
            BinarizationThresholdConfig.Companion.getInstance().setThreshold(this$0.thresholdValue);
            new BinarizeImageAction().actionPerformed(this$0.event);
        }

        private static final void createCenterPanel$lambda$1$0(JLabel $this_apply, JSlider $slider, ChangeEvent it) {
            Object[] objectArray = new Object[]{$slider.getValue()};
            $this_apply.setText(ImagesBundle.message("scientific.threshold.value", objectArray));
        }
    }
}

