/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.scientific.statistics.ScientificImageActionsCollector;
import org.intellij.images.scientific.utils.ImageTransformationData;
import org.intellij.images.scientific.utils.ScientificImageViewerCoroutineKt;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/scientific/action/NormalizeImageAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.platform.images"})
public final class NormalizeImageAction
extends DumbAwareToggleAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabledAndVisible(imageFile != null && imageFile.getUserData(ScientificUtils.SCIENTIFIC_MODE_KEY) != null);
        boolean normalizationApplied = ImageTransformationData.Companion.getInstance(imageFile).isNormalized();
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)normalizationApplied);
        e.getPresentation().setText(normalizationApplied ? ImagesBundle.message("action.restore.original.text", new Object[0]) : ImagesBundle.message("action.normalize.image.text", new Object[0]));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile imageFile = virtualFile;
        return ImageTransformationData.Companion.getInstance(imageFile).isNormalized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile imageFile = virtualFile;
        BufferedImage bufferedImage = (BufferedImage)imageFile.getUserData(ImageTransformationData.Companion.getORIGINAL_IMAGE_KEY());
        if (bufferedImage == null) {
            return;
        }
        BufferedImage originalImage = bufferedImage;
        ImageDocument imageDocument = (ImageDocument)e.getData(ImageDocument.IMAGE_DOCUMENT_DATA_KEY);
        if (imageDocument == null) {
            return;
        }
        ImageDocument document = imageDocument;
        BufferedImage bufferedImage2 = document.getValue();
        if (bufferedImage2 == null) {
            return;
        }
        BufferedImage currentImage = bufferedImage2;
        ImageTransformationData transformationData = ImageTransformationData.Companion.getInstance(imageFile);
        if (state == transformationData.isNormalized()) {
            return;
        }
        ScientificImageViewerCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(state, imageFile, currentImage, transformationData, originalImage, document, null){
            Object L$0;
            int I$0;
            int label;
            final /* synthetic */ boolean $state;
            final /* synthetic */ VirtualFile $imageFile;
            final /* synthetic */ BufferedImage $currentImage;
            final /* synthetic */ ImageTransformationData $transformationData;
            final /* synthetic */ BufferedImage $originalImage;
            final /* synthetic */ ImageDocument $document;
            {
                this.$state = $state;
                this.$imageFile = $imageFile;
                this.$currentImage = $currentImage;
                this.$transformationData = $transformationData;
                this.$originalImage = $originalImage;
                this.$document = $document;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$state) break;
                        this.$imageFile.putUserData(ImageTransformationData.Companion.getCURRENT_NOT_NORMALIZED_IMAGE_KEY(), (Object)this.$currentImage);
                        this.$imageFile.putUserData(ImageTransformationData.Companion.getCURRENT_ANGLE_KEY(), (Object)Boxing.boxInt((int)this.$transformationData.getRotationAngle()));
                        this.label = 1;
                        v0 = ScientificUtils.INSTANCE.normalizeImage$intellij_platform_images(this.$currentImage, (Continuation<? super BufferedImage>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        normalizedImage = (BufferedImage)v0;
                        this.$transformationData.setIsNormalized(true);
                        ScientificImageActionsCollector.INSTANCE.logNormalizedImageInvoked(true);
                        v1 = normalizedImage;
                        ** GOTO lbl43
                    }
                }
                v2 = (BufferedImage)this.$imageFile.getUserData(ImageTransformationData.Companion.getCURRENT_NOT_NORMALIZED_IMAGE_KEY());
                if (v2 == null) {
                    v2 = this.$originalImage;
                }
                notNormalizedImage = v2;
                v3 = (Integer)this.$imageFile.getUserData(ImageTransformationData.Companion.getCURRENT_ANGLE_KEY());
                currentAngle = v3 != null ? v3 : 0;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)notNormalizedImage);
                this.I$0 = currentAngle;
                this.label = 2;
                v4 = ScientificUtils.INSTANCE.rotateImage$intellij_platform_images(notNormalizedImage, this.$transformationData.getRotationAngle() - currentAngle, (Continuation<? super BufferedImage>)((Continuation)this));
                if (v4 == var5_2) {
                    return var5_2;
                }
                ** GOTO lbl39
                {
                    case 2: {
                        currentAngle = this.I$0;
                        notNormalizedImage = (BufferedImage)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl39:
                        // 2 sources

                        notNormalizedImage = (BufferedImage)v4;
                        this.$transformationData.setIsNormalized(false);
                        ScientificImageActionsCollector.INSTANCE.logNormalizedImageInvoked(false);
                        v1 = var3_3;
lbl43:
                        // 2 sources

                        resultImage = v1;
                        this.L$0 = resultImage;
                        this.label = 3;
                        v5 = ScientificUtils.INSTANCE.saveImageToFile$intellij_platform_images(this.$imageFile, resultImage, (Continuation<? super Unit>)((Continuation)this));
                        if (v5 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl54
                    }
                    case 3: {
                        resultImage = (BufferedImage)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl54:
                        // 2 sources

                        this.$document.setValue(resultImage);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

