/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/events/FileIndexingRequest;", "", "isDeleteRequest", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileId", "", "<init>", "(ZLcom/intellij/openapi/vfs/VirtualFile;I)V", "()Z", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFileId", "()I", "equals", "other", "hashCode", "Companion", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
public final class FileIndexingRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isDeleteRequest;
    @NotNull
    private final VirtualFile file;
    private final int fileId;
    @NotNull
    private static final Logger LOG;

    private FileIndexingRequest(boolean isDeleteRequest, VirtualFile file, int fileId) {
        this.isDeleteRequest = isDeleteRequest;
        this.file = file;
        this.fileId = fileId;
    }

    /* synthetic */ FileIndexingRequest(boolean bl, VirtualFile virtualFile, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = FileBasedIndex.getFileId((VirtualFile)virtualFile);
        }
        this(bl, virtualFile, n);
    }

    public final boolean isDeleteRequest() {
        return this.isDeleteRequest;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public final int getFileId() {
        return this.fileId;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FileIndexingRequest && this.isDeleteRequest == ((FileIndexingRequest)other).isDeleteRequest && this.fileId == ((FileIndexingRequest)other).fileId;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.isDeleteRequest, this.fileId};
        return Objects.hash(objectArray);
    }

    @JvmStatic
    @NotNull
    public static final FileIndexingRequest updateRequest(@NotNull VirtualFile file) {
        return Companion.updateRequest(file);
    }

    @JvmStatic
    @NotNull
    public static final FileIndexingRequest deleteRequest(@NotNull VirtualFile file) {
        return Companion.deleteRequest(file);
    }

    static {
        Logger logger = Logger.getInstance(FileIndexingRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/events/FileIndexingRequest$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateRequest", "Lcom/intellij/util/indexing/events/FileIndexingRequest;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteRequest", "intellij.platform.indexing.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FileIndexingRequest updateRequest(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof VirtualFileWithId)) {
                LOG.error("Not a VirtualFileWithId: " + file.getClass() + " [" + file + "]");
            }
            return new FileIndexingRequest(false, file, 0, 4, null);
        }

        @JvmStatic
        @NotNull
        public final FileIndexingRequest deleteRequest(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof VirtualFileWithId)) {
                LOG.error("Not a VirtualFileWithId: " + file.getClass() + " [" + file + "]");
            }
            return new FileIndexingRequest(true, file, 0, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

