/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.events.IndexingEventsLogger;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class VfsEventsMerger {
    private final AtomicInteger myPublishedEventIndex = new AtomicInteger();
    private final ConcurrentIntObjectMap<ChangeInfo> myChangeInfos = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private static final short FILE_ADDED = 1;
    private static final short FILE_REMOVED = 2;
    private static final short FILE_CONTENT_CHANGED = 4;
    private static final short FILE_TRANSIENT_STATE_CHANGED = 8;

    @ApiStatus.Internal
    public void recordFileEvent(@NotNull VirtualFile file, boolean contentChange) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(0);
        }
        IndexingEventsLogger.tryLog(contentChange ? "FILE_CONTENT_CHANGED" : "FILE_ADDED", file);
        this.updateChange(file, contentChange ? (short)4 : 1);
    }

    @ApiStatus.Internal
    public void recordFileRemovedEvent(@NotNull VirtualFile file) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(1);
        }
        IndexingEventsLogger.tryLog("FILE_REMOVED", file);
        this.updateChange(file, (short)2);
    }

    @ApiStatus.Internal
    public void recordTransientStateChangeEvent(@NotNull VirtualFile file) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(2);
        }
        IndexingEventsLogger.tryLog("FILE_TRANSIENT_STATE_CHANGED", file);
        this.updateChange(file, (short)8);
    }

    @ApiStatus.Internal
    public int getPublishedEventIndex() {
        return this.myPublishedEventIndex.get();
    }

    private void updateChange(@NotNull VirtualFile file, @EventMask short mask) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(3);
        }
        if (file instanceof VirtualFileWithId) {
            this.updateChange(((VirtualFileWithId)file).getId(), file, mask);
        }
    }

    private void updateChange(int fileId, @NotNull VirtualFile file, @EventMask short mask) {
        ChangeInfo existingChangeInfo;
        ChangeInfo newChangeInfo;
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(4);
        }
        while (this.myChangeInfos.put(fileId, (Object)(newChangeInfo = new ChangeInfo(file, mask, existingChangeInfo = (ChangeInfo)this.myChangeInfos.get(fileId)))) != existingChangeInfo) {
        }
        this.myPublishedEventIndex.incrementAndGet();
    }

    @VisibleForTesting
    public boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (eventProcessor == null) {
            VfsEventsMerger.$$$reportNull$$$0(5);
        }
        if (!this.myChangeInfos.isEmpty()) {
            Throwable interruptReason = null;
            try {
                int[] fileIds;
                for (int fileId : fileIds = this.myChangeInfos.keys()) {
                    ProgressManager.checkCanceled();
                    ChangeInfo info = (ChangeInfo)this.myChangeInfos.remove(fileId);
                    if (info == null) continue;
                    try {
                        IndexingEventsLogger.tryLog(() -> "Processing " + String.valueOf(info));
                        if (eventProcessor.process(info)) continue;
                        eventProcessor.endBatch();
                        boolean bl = false;
                        return bl;
                    }
                    catch (AlreadyDisposedException e) {
                        throw e;
                    }
                    catch (ProcessCanceledException pce) {
                        ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().error((Throwable)new RuntimeException(pce));
                        assert (false);
                    }
                }
                eventProcessor.endBatch();
            }
            catch (Throwable t) {
                interruptReason = t;
                throw t;
            }
            finally {
                Throwable finalInterruptReason = interruptReason;
                IndexingEventsLogger.tryLog(() -> "Processing " + (String)(finalInterruptReason != null ? "interrupted: " + String.valueOf(finalInterruptReason) : "finished"));
            }
        }
        return true;
    }

    @ApiStatus.Internal
    public boolean hasChanges() {
        return !this.myChangeInfos.isEmpty();
    }

    @ApiStatus.Internal
    public int getApproximateChangesCount() {
        return this.myChangeInfos.size();
    }

    @NotNull
    public Iterator<VirtualFile> getChangedFiles() {
        Iterator iterator = ContainerUtil.mapIterator(this.myChangeInfos.values().iterator(), ChangeInfo::getFile);
        if (iterator == null) {
            VfsEventsMerger.$$$reportNull$$$0(6);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordFileEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordFileRemovedEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordTransientStateChangeEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChanges";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static final class ChangeInfo {
        private final VirtualFile file;
        @EventMask
        private final short eventMask;

        ChangeInfo(@NotNull VirtualFile file, @EventMask short eventMask, @Nullable ChangeInfo previous) {
            if (file == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.eventMask = ChangeInfo.mergeEventMask(previous == null ? (short)0 : previous.eventMask, eventMask);
        }

        @EventMask
        private static short mergeEventMask(@EventMask short existingOperation, @EventMask short newOperation) {
            if (newOperation == 2) {
                return 2;
            }
            return (short)(existingOperation | newOperation);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("file: ");
            VirtualFile virtualFile = this.file;
            if (virtualFile instanceof VirtualFileWithId) {
                VirtualFileWithId fileWithId = (VirtualFileWithId)virtualFile;
                builder.append(fileWithId.getId());
            } else {
                builder.append(this.file.getPath());
            }
            builder.append("; ").append("operation: ");
            if ((this.eventMask & 8) != 0) {
                builder.append("TRANSIENT_STATE_CHANGE ");
            }
            if ((this.eventMask & 4) != 0) {
                builder.append("CONTENT_CHANGE ");
            }
            if ((this.eventMask & 2) != 0) {
                builder.append("REMOVE ");
            }
            if ((this.eventMask & 1) != 0) {
                builder.append("ADD ");
            }
            return builder.toString().trim();
        }

        @ApiStatus.Internal
        public boolean isContentChanged() {
            return (this.eventMask & 4) != 0;
        }

        @ApiStatus.Internal
        public boolean isFileRemoved() {
            return (this.eventMask & 2) != 0;
        }

        @ApiStatus.Internal
        public boolean isFileAdded() {
            return (this.eventMask & 1) != 0;
        }

        @ApiStatus.Internal
        public boolean isTransientStateChanged() {
            return (this.eventMask & 8) != 0;
        }

        @NotNull
        @ApiStatus.Internal
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                ChangeInfo.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @ApiStatus.Internal
        public int getFileId() {
            int fileId = FileBasedIndex.getFileId((VirtualFile)this.file);
            assert (fileId >= 0);
            return fileId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);

        default public void endBatch() {
        }
    }

    static @interface EventMask {
    }
}

