/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.storage.KeyHashLog;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private final boolean myBuildKeyHashToVirtualFileMapping;
    @Nullable
    private KeyHashLog<Key> myKeyHashToVirtualFileMapping;

    @TestOnly
    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(2);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly, false, null);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping, boolean enableWal) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(5);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, enableWal, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    protected void initMapAndCache() throws IOException {
        this.withWriteLock(() -> {
            super.initMapAndCache();
            if (this.myBuildKeyHashToVirtualFileMapping && this.myBaseStorageFile != null) {
                FileSystem projectFileFS = this.myBaseStorageFile.getFileSystem();
                assert (!projectFileFS.isReadOnly()) : "File system " + String.valueOf(projectFileFS) + " is read only";
                this.myKeyHashToVirtualFileMapping = new KeyHashLog(this.myKeyDescriptor, this.myBaseStorageFile);
            } else {
                this.myKeyHashToVirtualFileMapping = null;
            }
        });
    }

    public void flush() throws IOException {
        this.withWriteLock(() -> {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.force();
            }
        });
    }

    public void close() throws IOException {
        super.close();
        if (this.myKeyHashToVirtualFileMapping != null) {
            this.myKeyHashToVirtualFileMapping.close();
        }
    }

    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.clear();
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(7);
        }
        return (Boolean)this.withReadLock(() -> {
            try {
                this.invalidateCachedMappings();
                Project project = scope.getProject();
                if (this.myKeyHashToVirtualFileMapping != null && project != null && idFilter != null) {
                    IntSet hashMaskSet = this.myKeyHashToVirtualFileMapping.getSuitableKeyHashes(idFilter, project);
                    return this.doProcessKeys(key -> {
                        if (!hashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
                            return true;
                        }
                        return processor.process(key);
                    });
                }
                return this.doProcessKeys(processor);
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            catch (RuntimeException e) {
                throw VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
            }
        });
    }

    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(8);
        }
        this.withWriteLock(() -> {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.removeKeyHashToVirtualFileMapping(key, inputId);
            }
            super.removeAllValues(key, inputId);
        });
    }

    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myKeyHashToVirtualFileMapping == null) {
            super.addValue(key, inputId, value);
        } else {
            this.withWriteLock(() -> {
                if (this.myKeyHashToVirtualFileMapping != null) {
                    this.myKeyHashToVirtualFileMapping.addKeyHashToVirtualFileMapping(key, inputId);
                }
                super.addValue(key, inputId, value);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/storage/VfsAwareMapIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

