/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.impl.storage.IndexLayoutPersistentSettings;
import com.intellij.util.indexing.impl.storage.IndexStorageLayoutLocator;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "indexLayoutSettingFile", "Ljava/nio/file/Path;", "loadLayout", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "saveLayout", "", "bean", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nIndexLayoutPersistentSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexLayoutPersistentSettings.kt\ncom/intellij/util/indexing/impl/storage/IndexLayoutPersistentSettingsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n13#2:126\n*S KotlinDebug\n*F\n+ 1 IndexLayoutPersistentSettings.kt\ncom/intellij/util/indexing/impl/storage/IndexLayoutPersistentSettingsKt\n*L\n72#1:126\n*E\n"})
public final class IndexLayoutPersistentSettingsKt {
    @NotNull
    private static final Logger LOG;

    private static final Path indexLayoutSettingFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.layout");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized FileBasedIndexLayoutProviderBean loadLayout() {
        Path indexLayoutSettingFile = IndexLayoutPersistentSettingsKt.indexLayoutSettingFile();
        if (!Files.exists(indexLayoutSettingFile, new LinkOption[0])) {
            return null;
        }
        String id = null;
        int version = 0;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(indexLayoutSettingFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Object object = inputStream;
        int n = 8192;
        object = new DataInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)object;
            boolean bl = false;
            String string = EnumeratorStringDescriptor.INSTANCE.read((DataInput)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read(...)");
            id = string;
            version = DataInputOutputUtil.readINT((DataInput)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        for (FileBasedIndexLayoutProviderBean bean : IndexStorageLayoutLocator.INSTANCE.getSupportedLayoutProviders()) {
            if (!Intrinsics.areEqual((Object)bean.id, (Object)id) || bean.version != version) continue;
            return bean;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void saveLayout(FileBasedIndexLayoutProviderBean bean) {
        try {
            Path indexLayoutSettingFile = IndexLayoutPersistentSettingsKt.indexLayoutSettingFile();
            Files.createDirectories(indexLayoutSettingFile.getParent(), new FileAttribute[0]);
            if (bean == null) {
                FileUtil.delete((Path)indexLayoutSettingFile);
                return;
            }
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(indexLayoutSettingFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            int n = 8192;
            closeable = (Closeable)new DataOutputStream((OutputStream)(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n)));
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                EnumeratorStringDescriptor.INSTANCE.save((DataOutput)it, bean.id);
                DataInputOutputUtil.writeINT((DataOutput)((DataOutput)it), (int)bean.version);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static final /* synthetic */ FileBasedIndexLayoutProviderBean access$loadLayout() {
        return IndexLayoutPersistentSettingsKt.loadLayout();
    }

    public static final /* synthetic */ void access$saveLayout(FileBasedIndexLayoutProviderBean bean) {
        IndexLayoutPersistentSettingsKt.saveLayout(bean);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexLayoutPersistentSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

