/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoItemImpl
implements TodoItem {
    private final PsiFile myPsiFile;
    private final int myStartOffset;
    private final int myEndOffset;
    @Nullable
    private final TodoPattern myPattern;
    private final List<TextRange> myAdditionalRanges;

    public TodoItemImpl(@NotNull PsiFile psiFile, int startOffset, int endOffset, @Nullable TodoPattern pattern, @NotNull List<TextRange> additionalRanges) {
        if (psiFile == null) {
            TodoItemImpl.$$$reportNull$$$0(0);
        }
        if (additionalRanges == null) {
            TodoItemImpl.$$$reportNull$$$0(1);
        }
        this.myPsiFile = psiFile;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPattern = pattern;
        this.myAdditionalRanges = additionalRanges;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            TodoItemImpl.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return new TextRange(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public List<TextRange> getAdditionalTextRanges() {
        List<TextRange> list = this.myAdditionalRanges;
        if (list == null) {
            TodoItemImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public TodoPattern getPattern() {
        return this.myPattern;
    }

    public int hashCode() {
        return this.myPsiFile.hashCode() + this.myStartOffset + this.myEndOffset + (this.myPattern != null ? this.myPattern.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoItemImpl)) {
            return false;
        }
        TodoItemImpl todoItem = (TodoItemImpl)obj;
        return this.myPsiFile.equals((Object)todoItem.myPsiFile) && this.myStartOffset == todoItem.myStartOffset && this.myEndOffset == todoItem.myEndOffset && Objects.equals(this.myPattern, todoItem.myPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/TodoItemImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/TodoItemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

