/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.AbstractStringEnumerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LazyStubData {
    private final AbstractStringEnumerator myStorage;
    private final MostlyUShortIntList myParentsAndStarts;
    private final byte[] mySerializedStubs;
    private final BitSet myAllStarts;

    LazyStubData(AbstractStringEnumerator storage, MostlyUShortIntList parentsAndStarts, byte[] serializedStubs, BitSet allStarts) {
        this.myStorage = storage;
        this.myParentsAndStarts = parentsAndStarts;
        this.mySerializedStubs = serializedStubs;
        this.myAllStarts = allStarts;
    }

    int getParentIndex(int index) {
        return this.myParentsAndStarts.get(index * 2);
    }

    private int getDataStart(int index) {
        return this.myParentsAndStarts.get(index * 2 + 1);
    }

    @NotNull
    StubBase<?> deserializeStub(int index, @Nullable StubBase<?> parent, @NotNull ObjectStubSerializer<?, ? super Stub> serializer2, @NotNull IElementType type) throws IOException {
        if (serializer2 == null) {
            LazyStubData.$$$reportNull$$$0(0);
        }
        if (type == null) {
            LazyStubData.$$$reportNull$$$0(1);
        }
        StubInputStream stream = new StubInputStream((InputStream)this.stubBytes(index), this.myStorage);
        StubBase stub = (StubBase)serializer2.deserialize(stream, parent);
        int available = stream.available();
        if (available > 0) {
            if (available != 1) {
                throw new AssertionError((Object)LazyStubData.getSerializeDeserializerMismatchMessage(type));
            }
            stub.markDangling();
        }
        StubBase stubBase = stub;
        if (stubBase == null) {
            LazyStubData.$$$reportNull$$$0(2);
        }
        return stubBase;
    }

    private ByteArrayInputStream stubBytes(int index) {
        int start = this.getDataStart(index);
        if (start == 0) {
            return new ByteArrayInputStream(ArrayUtilRt.EMPTY_BYTE_ARRAY);
        }
        int end = this.myAllStarts.nextSetBit(start + 1);
        if (end < 0) {
            end = this.mySerializedStubs.length + 1;
        }
        return new ByteArrayInputStream(this.mySerializedStubs, start - 1, end - start);
    }

    @NotNull
    private static String getSerializeDeserializerMismatchMessage(@NotNull IElementType type) {
        if (type == null) {
            LazyStubData.$$$reportNull$$$0(3);
        }
        String string = "Stub serializer/deserialize mismatch for StubElementType: name = " + type.getDebugName() + ", language = " + String.valueOf(type.getLanguage());
        if (string == null) {
            LazyStubData.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LazyStubData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LazyStubData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeStub";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializeDeserializerMismatchMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserializeStub";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSerializeDeserializerMismatchMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

