/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.PlainTextIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.OverrideOnly
public class PlainTextTodoIndexer
extends VersionedTodoIndexer {
    private static final Logger LOG = Logger.getInstance(PlainTextTodoIndexer.class);

    @NotNull
    public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
        IndexPattern[] indexPatterns;
        if (inputData == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(0);
        }
        if ((indexPatterns = IndexPatternUtil.getIndexPatterns()).length <= 0) {
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                PlainTextTodoIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }
        String chars = inputData.getContentAsText().toString();
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        for (IndexPattern indexPattern : indexPatterns) {
            if (!PlainTextTodoIndexer.idIndexContainAllWords(indexPattern.getWordsToFindFirst(), indexPattern.isCaseSensitive(), inputData)) continue;
            Pattern pattern = indexPattern.getOptimizedIndexingPattern();
            try {
                if (pattern == null) continue;
                Matcher matcher = pattern.matcher(StringPattern.newBombedCharSequence((CharSequence)chars));
                while (matcher.find()) {
                    if (matcher.start() == matcher.end()) continue;
                    occurrenceConsumer.incTodoOccurrence(indexPattern);
                }
            }
            catch (StackOverflowError error) {
                LOG.error((Throwable)error);
            }
        }
        HashMap<TodoIndexEntry, Integer> map = new HashMap<TodoIndexEntry, Integer>();
        for (IndexPattern indexPattern : indexPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            map.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        HashMap<TodoIndexEntry, Integer> hashMap = map;
        if (hashMap == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static boolean idIndexContainAllWords(@NotNull List<String> words, boolean caseSensitive, @NotNull FileContent content) {
        if (words == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(3);
        }
        if (content == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(4);
        }
        Map<IdIndexEntry, Integer> idIndexData = PlainTextIdIndexer.getIdIndexData(content);
        return words.stream().allMatch(word -> idIndexData.containsKey(new IdIndexEntry((String)word, caseSensitive)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/todo/PlainTextTodoIndexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/PlainTextTodoIndexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "idIndexContainAllWords";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

