/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NanoXmlUtil {
    private static final Logger LOG = Logger.getInstance(NanoXmlUtil.class);

    private NanoXmlUtil() {
    }

    private static MyXMLReader createReader(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            NanoXmlUtil.$$$reportNull$$$0(0);
        }
        return new MyXMLReader((Reader)new CharSequenceReader(psiFile.getViewProvider().getContents()));
    }

    public static void parse(@NotNull InputStream is, @NotNull IXMLBuilder builder) {
        if (is == null) {
            NanoXmlUtil.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(2);
        }
        try (InputStream inputStream = is;){
            NanoXmlUtil.parse(new MyXMLReader(is), builder);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void parse(@NotNull Reader reader, @NotNull IXMLBuilder builder) {
        if (reader == null) {
            NanoXmlUtil.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(4);
        }
        NanoXmlUtil.parse(reader, builder, null);
    }

    public static void parse(@NotNull Reader reader, @NotNull IXMLBuilder builder, @Nullable IXMLValidator validator) {
        if (reader == null) {
            NanoXmlUtil.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(6);
        }
        try (Reader reader2 = reader;){
            NanoXmlUtil.parse(new MyXMLReader(reader), builder, validator);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void parse(StdXMLReader r, @NotNull IXMLBuilder builder) {
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(7);
        }
        NanoXmlUtil.parse(r, builder, null);
    }

    public static void parse(StdXMLReader r, @NotNull IXMLBuilder builder, @Nullable IXMLValidator validator) {
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(8);
        }
        StdXMLParser parser = new StdXMLParser(r, builder, (IXMLValidator)(validator == null ? new EmptyValidator() : validator), (IXMLEntityResolver)new EmptyEntityResolver());
        try {
            parser.parse();
        }
        catch (ParserStoppedXmlException parserStoppedXmlException) {
        }
        catch (XMLException e) {
            if (e.getException() instanceof ProcessCanceledException) {
                throw new ProcessCanceledException((Throwable)e);
            }
            LOG.debug((Throwable)e);
        }
    }

    @NotNull
    public static XmlFileHeader parseHeader(VirtualFile file) {
        try {
            return NanoXmlUtil.parseHeaderWithException(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(Reader reader) {
        return NanoXmlUtil.doParseHeader(new MyXMLReader(reader));
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(VirtualFile file) throws IOException {
        InputStream stream = file.getInputStream();
        XmlFileHeader xmlFileHeader = NanoXmlUtil.doParseHeader(new MyXMLReader(stream));
        XmlFileHeader xmlFileHeader2 = xmlFileHeader;
        if (xmlFileHeader2 == null) {
            NanoXmlUtil.$$$reportNull$$$0(9);
        }
        return xmlFileHeader2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @NotNull
    public static XmlFileHeader parseHeader(Reader reader) {
        return NanoXmlUtil.doParseHeader(new MyXMLReader(reader));
    }

    @NotNull
    public static XmlFileHeader parseHeader(PsiFile file) {
        return NanoXmlUtil.doParseHeader(NanoXmlUtil.createReader(file));
    }

    @NotNull
    private static XmlFileHeader doParseHeader(MyXMLReader r) {
        RootTagInfoBuilder builder = new RootTagInfoBuilder();
        NanoXmlUtil.parse(r, (IXMLBuilder)builder);
        return new XmlFileHeader(builder.getRootTagName(), builder.getNamespace(), r.publicId, r.systemId);
    }

    public static String createLocation(String ... tagNames) {
        StringBuilder result = new StringBuilder();
        for (String tagName : tagNames) {
            result.append(".");
            result.append(tagName);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHeaderWithException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyXMLReader
    extends StdXMLReader {
        private String publicId;
        private String systemId;

        MyXMLReader(@NotNull Reader documentReader) {
            if (documentReader == null) {
                MyXMLReader.$$$reportNull$$$0(0);
            }
            super(documentReader);
        }

        MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicId, String systemId) {
            this.publicId = Strings.isEmpty((String)publicId) ? null : publicId;
            this.systemId = Strings.isEmpty((String)systemId) ? null : systemId;
            return new StringReader(" ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentReader", "com/intellij/util/xml/NanoXmlUtil$MyXMLReader", "<init>"));
        }
    }

    public static class EmptyValidator
    extends NonValidator {
        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }
    }

    private static final class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(StdXMLReader xmlReader, String name) {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    public static final class ParserStoppedXmlException
    extends XMLException {
        public static final ParserStoppedXmlException INSTANCE = new ParserStoppedXmlException();

        private ParserStoppedXmlException() {
            super("Parsing stopped");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class RootTagInfoBuilder
    implements IXMLBuilder {
        private String myRootTagName;
        private String myNamespace;

        private RootTagInfoBuilder() {
        }

        public void startBuilding(String systemID, int lineNr) {
        }

        public void newProcessingInstruction(String target, Reader reader) {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myRootTagName = name;
            this.myNamespace = nsURI;
            throw ParserStoppedXmlException.INSTANCE;
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) {
        }

        public String getNamespace() {
            return this.myNamespace;
        }

        public String getRootTagName() {
            return this.myRootTagName;
        }

        public String getResult() {
            return this.myRootTagName;
        }
    }

    public static class BaseXmlBuilder
    implements NanoXmlBuilder {
        private final Stack<String> myLocation = new Stack();

        @Override
        public void startBuilding(String systemID, int lineNr) {
            this.myLocation.push((Object)"");
        }

        @Override
        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myLocation.push((Object)((String)this.myLocation.peek() + "." + name));
        }

        @Override
        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
            this.myLocation.pop();
        }

        protected static String readText(Reader reader) throws IOException {
            return new String(StreamUtil.readTextAndConvertSeparators((Reader)reader));
        }

        @NonNls
        protected String getLocation() {
            return (String)this.myLocation.peek();
        }
    }

    @Deprecated(forRemoval=true)
    public static abstract class IXMLBuilderAdapter
    implements NanoXmlBuilder {
    }
}

