/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexImplUtil;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexLookupTimingsReporting;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.VoidDataExternalizer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class StubIndexEx
extends StubIndex {
    private final Map<StubIndexKey<?, ?>, CachedValue<Map<KeyAndFileId<?>, StubIdList>>> myCachedStubIds = FactoryMap.createMap(k -> {
        UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> index = StubIndexEx.getStubUpdatingIndex();
        ModificationTracker tracker = index::getModificationStamp;
        return new CachedValueImpl(() -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{tracker}));
    }, ConcurrentHashMap::new);
    private final StubProcessingHelper myStubProcessingHelper = new StubProcessingHelper();

    static void initExtensions() {
        for (StubIndexExtension extension : StubIndexExtension.EP_NAME.getExtensionList()) {
            extension.getKey();
        }
    }

    @ApiStatus.Internal
    public abstract void initializeStubIndexes();

    @ApiStatus.Internal
    public abstract void initializationFailed(@NotNull Throwable var1);

    public <K> void updateIndex(@NotNull StubIndexKey<K, ?> stubIndexKey, int fileId, @NotNull Set<? extends K> oldKeys, @NotNull Set<? extends K> newKeys) {
        if (stubIndexKey == null) {
            StubIndexEx.$$$reportNull$$$0(0);
        }
        if (oldKeys == null) {
            StubIndexEx.$$$reportNull$$$0(1);
        }
        if (newKeys == null) {
            StubIndexEx.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                UpdatableIndex index;
                if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                    this.getLogger().info("stub index '" + String.valueOf(stubIndexKey) + "' update: " + fileId + " old = " + Arrays.toString(oldKeys.toArray()) + " new  = " + Arrays.toString(newKeys.toArray()) + " updated_id = " + System.identityHashCode(newKeys));
                }
                if ((index = this.getIndex(stubIndexKey)) == null) {
                    return;
                }
                index.updateWith(new UpdateData(fileId, index.getExtension().getName(), changedEntriesProcessor -> {
                    boolean modified = false;
                    for (Object oldKey : oldKeys) {
                        if (newKeys.contains(oldKey)) continue;
                        changedEntriesProcessor.removed(oldKey, fileId);
                        if (modified) continue;
                        modified = true;
                    }
                    for (Object newKey : newKeys) {
                        if (oldKeys.contains(newKey)) continue;
                        changedEntriesProcessor.added(newKey, null, fileId);
                        if (modified) continue;
                        modified = true;
                    }
                    if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                        this.getLogger().info("keys iteration finished updated_id = " + System.identityHashCode(newKeys) + "; modified = " + modified);
                    }
                    return modified;
                }, UpdateData.ForwardIndexUpdate.NOOP));
            }
            catch (StorageException e) {
                this.getLogger().info((Throwable)e);
                this.forceRebuild(e);
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public abstract Logger getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        UpdatableIndex<Key, Void, FileContent, Psi> index;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(3);
        }
        if (key == null) {
            StubIndexEx.$$$reportNull$$$0(4);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(5);
        }
        if (requiredClass == null) {
            StubIndexEx.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            StubIndexEx.$$$reportNull$$$0(7);
        }
        if ((index = this.getIndex(indexKey)) != null && !index.canUpdate() || !StubIndexEx.getStubUpdatingIndex().canUpdate()) {
            IllegalStateException exception = new IllegalStateException("Nesting processElements call under other stub index operation can lead to a deadlock.");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw exception;
            }
            this.getLogger().error((Throwable)exception);
        }
        IndexLookupTimingsReporting.IndexOperationFusCollector.LookupStubEntriesByKeyTrace trace = (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupStubEntriesByKeyTrace)IndexLookupTimingsReporting.IndexOperationFusCollector.lookupStubEntriesStarted(indexKey).withProject(project);
        try {
            boolean shouldHaveKeys;
            Iterator<VirtualFile> fileStream;
            Predicate keyFilter;
            boolean dumb = DumbService.isDumb((Project)project);
            if (dumb) {
                if (project instanceof LightEditCompatible) {
                    boolean bl = false;
                    return bl;
                }
                DumbModeAccessType accessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType(project);
                if (accessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
                    throw new AssertionError((Object)"raw index data access is not available for StubIndex");
                }
            }
            Processor processorWithKeyFilter = (keyFilter = StubIndexKeyDescriptorCache.INSTANCE.getKeyPsiMatcher(indexKey, key)) == null ? processor : o -> !keyFilter.test(o) || processor.process(o);
            PairProcessor stubProcessor = (file, list) -> this.myStubProcessingHelper.processStubsInFile(project, (VirtualFile)file, (StubIdList)list, processorWithKeyFilter, scope, requiredClass, (Computable<String>)((Computable)() -> "Looking for " + String.valueOf(key) + " in " + String.valueOf(indexKey)));
            Iterator<VirtualFile> singleFileInScope = FileBasedIndexEx.extractSingleFileOrEmpty(scope);
            if (singleFileInScope != null) {
                if (!singleFileInScope.hasNext()) {
                    boolean bl = true;
                    return bl;
                }
                FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, scope);
                fileStream = singleFileInScope;
                trace.lookupResultSize(1);
                shouldHaveKeys = false;
            } else {
                IntSet fileIds = this.getContainingIds(indexKey, key, project, idFilter, scope);
                if (fileIds == null) {
                    trace.lookupResultSize(0);
                    boolean bl = true;
                    return bl;
                }
                trace.lookupResultSize(fileIds.size());
                IntPredicate accessibleFileFilter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).getAccessibleFileIdFilter(project);
                IntIterator idIterator = fileIds.iterator();
                fileStream = StubIndexImplUtil.mapIdIterator(idIterator, accessibleFileFilter);
                shouldHaveKeys = true;
            }
            trace.stubTreesDeserializingStarted();
            try {
                while (fileStream.hasNext()) {
                    VirtualFile file2 = fileStream.next();
                    assert (file2 != null);
                    if (scope != null && !scope.contains(file2)) continue;
                    int id = ((VirtualFileWithId)file2).getId();
                    StubIdList list2 = ((Map)this.myCachedStubIds.get(indexKey).getValue()).computeIfAbsent(new KeyAndFileId<Key>(key, id), __ -> this.myStubProcessingHelper.retrieveStubIdList(indexKey, key, file2, project, shouldHaveKeys));
                    if (list2 == null || stubProcessor.process((Object)file2, (Object)list2)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (RuntimeException e) {
                trace.lookupFailed();
                Throwable cause = FileBasedIndexEx.extractCauseToRebuildIndex(e);
                if (cause == null) throw e;
                this.forceRebuild(cause);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            trace.lookupFailed();
            throw t;
        }
        finally {
            this.tryFixIndexesForProblemFiles(indexKey, key, project);
            trace.close();
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    protected abstract <Key> UpdatableIndex<Key, Void, FileContent, ?> getIndex(@NotNull StubIndexKey<Key, ?> var1);

    private <Key> void tryFixIndexesForProblemFiles(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull Project project) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(8);
        }
        if (key == null) {
            StubIndexEx.$$$reportNull$$$0(9);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(10);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            List fileNames = ContainerUtil.map(filesWithProblems, f -> f.getName());
            String fileNamesStr = StringUtil.first((String)StringUtil.join((Collection)fileNames, (String)","), (int)300, (boolean)true);
            this.getLogger().info("Data for " + fileNamesStr + " will be re-indexed because of internal stub processing error. Recomputing index request");
            ((FileBasedIndexEx)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                int fileId;
                UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> index = StubIndexEx.getStubUpdatingIndex();
                for (VirtualFile file : filesWithProblems) {
                    fileId = FileBasedIndex.getFileId((VirtualFile)file);
                    index.mapInputAndPrepareUpdate(fileId, null).update();
                }
                for (VirtualFile file : filesWithProblems) {
                    fileId = FileBasedIndex.getFileId((VirtualFile)file);
                    this.updateIndex(indexKey, fileId, Collections.singleton(key), Collections.emptySet());
                }
                index.cleanupMemoryStorage();
            });
            for (VirtualFile file : filesWithProblems) {
                FileBasedIndex.getInstance().requestReindex(file);
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                psiManager.dropPsiCaches();
                psiManager.dropResolveCaches();
            }), project.getDisposed());
        }
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(11);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(12);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor(allKeys));
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            StubIndexEx.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            StubIndexEx.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(16);
        }
        UpdatableIndex index = this.getIndex(indexKey);
        FileBasedIndexEx fileBasedIndexEx = (FileBasedIndexEx)FileBasedIndex.getInstance();
        if (index == null || !fileBasedIndexEx.ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope, null)) {
            return true;
        }
        if (idFilter == null) {
            idFilter = fileBasedIndexEx.extractIdFilter(scope, scope.getProject());
        }
        try {
            @Nullable IdFilter finalIdFilter = idFilter;
            return (Boolean)FileBasedIndexEx.disableUpToDateCheckIn(() -> index.processAllKeys(processor, scope, finalIdFilter));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> Iterator<VirtualFile> getContainingFilesIterator(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(17);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(18);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(20);
        }
        IntSet result = this.getContainingIds(indexKey, dataKey, project, null, scope);
        Iterator<VirtualFile> iterator = FileBasedIndexEx.createLazyFileIterator(result, scope);
        if (iterator == null) {
            StubIndexEx.$$$reportNull$$$0(21);
        }
        return iterator;
    }

    public <Key> int getMaxContainingFileCount(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        IntSet result;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(22);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(23);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(25);
        }
        return (result = this.getContainingIds(indexKey, dataKey, project, null, scope)) == null ? 0 : result.size();
    }

    @Nullable
    private <Key> IntSet getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable IdFilter idFilter, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(26);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(27);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(28);
        }
        IndexLookupTimingsReporting.IndexOperationFusCollector.LookupStubEntriesByKeyTrace trace = IndexLookupTimingsReporting.IndexOperationFusCollector.TRACE_OF_STUB_ENTRIES_LOOKUP.get();
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        UpdatableIndex index = this.getIndex(indexKey);
        if (index == null || !fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope, null)) {
            return null;
        }
        trace.indexValidationFinished();
        final IdFilter finalIdFilter = idFilter != null ? idFilter : ((FileBasedIndexEx)FileBasedIndex.getInstance()).extractIdFilter(scope, project);
        UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            var action = new ValueContainer.ContainerAction<Void>(){
                IntSet result = null;

                public boolean perform(int id, Void value) {
                    if (finalIdFilter == null || finalIdFilter.containsFileId(id)) {
                        if (this.result == null) {
                            this.result = new IntLinkedOpenHashSet();
                        }
                        this.result.add(id);
                    }
                    return true;
                }
            };
            trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible(index));
            FileBasedIndexEx.disableUpToDateCheckIn(() -> {
                index.withData(dataKey, container -> container.forEach((ValueContainer.ContainerAction)action));
                return null;
            });
            return action.result == null ? IntSets.EMPTY_SET : action.result;
        }
        catch (StorageException e) {
            trace.lookupFailed();
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            trace.lookupFailed();
            Throwable cause = FileBasedIndexEx.extractCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        return null;
    }

    @ApiStatus.Internal
    protected void clearState() {
        StubIndexKeyDescriptorCache.INSTANCE.clear();
        ((SerializationManagerImpl)SerializationManagerEx.getInstanceEx()).dropSerializerData();
        this.myCachedStubIds.clear();
    }

    @ApiStatus.Internal
    public void setDataBufferingEnabled(boolean enabled) {
    }

    @ApiStatus.Internal
    public void cleanupMemoryStorage() {
    }

    @ApiStatus.Internal
    @NotNull
    public static <K> FileBasedIndexExtension<K, Void> wrapStubIndexExtension(final StubIndexExtension<K, ?> extension) {
        return new FileBasedIndexExtension<K, Void>(){

            @NotNull
            public ID<K, Void> getName() {
                StubIndexKey key;
                StubIndexKey stubIndexKey = key = extension.getKey();
                if (stubIndexKey == null) {
                    2.$$$reportNull$$$0(0);
                }
                return stubIndexKey;
            }

            @NotNull
            public FileBasedIndex.InputFilter getInputFilter() {
                FileBasedIndex.InputFilter inputFilter = f -> {
                    throw new UnsupportedOperationException();
                };
                if (inputFilter == null) {
                    2.$$$reportNull$$$0(1);
                }
                return inputFilter;
            }

            public boolean dependsOnFileContent() {
                return true;
            }

            public boolean needsForwardIndexWhenSharing() {
                return false;
            }

            @NotNull
            public DataIndexer<K, Void, FileContent> getIndexer() {
                DataIndexer dataIndexer = i -> {
                    throw new AssertionError();
                };
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(2);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
                if (keyDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    2.$$$reportNull$$$0(4);
                }
                return voidDataExternalizer;
            }

            public int getVersion() {
                return extension.getVersion();
            }

            public boolean traceKeyHashToVirtualFileMapping() {
                return extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/stubs/StubIndexEx$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputFilter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    static UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> getStubUpdatingIndex() {
        return ((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
    }

    @TestOnly
    public boolean areAllProblemsProcessedInTheCurrentThread() {
        return this.myStubProcessingHelper.areAllProblemsProcessedInTheCurrentThread();
    }

    @ApiStatus.Internal
    public void cleanCaches() {
        this.myCachedStubIds.clear();
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public abstract FileUpdateProcessor getPerFileElementTypeModificationTrackerUpdateProcessor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeys";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newKeys";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexEx";
                break;
            }
            case 16: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexEx";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFilesIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryFixIndexesForProblemFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 13: 
            case 21: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilesIterator";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMaxContainingFileCount";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 21 -> new IllegalStateException(string);
        };
    }

    private record KeyAndFileId<K>(@NotNull K key, int fileId) {
        @NotNull
        private final K key;

        private KeyAndFileId(@NotNull K key, int fileId) {
            if (key == null) {
                KeyAndFileId.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public K key() {
            K k = this.key;
            if (k == null) {
                KeyAndFileId.$$$reportNull$$$0(1);
            }
            return k;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubIndexEx$KeyAndFileId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubIndexEx$KeyAndFileId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static interface FileUpdateProcessor {
        public void processUpdate(@NotNull VirtualFile var1);

        default public void endUpdatesBatch() {
        }
    }
}

