/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.impl.cache.impl.id.IdEntryToScopeMapImpl;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexFilter;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileTypeSpecificSubIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    private static final Logger LOG = Logger.getInstance(IdIndex.class);
    private static final ThrottledLogger THROTTLED_LOGGER = new ThrottledLogger(LOG, TimeUnit.MINUTES.toMillis(1L));
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private static final FileBasedIndex.InputFilter INPUT_FILES_FILTER = new IdIndexFilter();
    private static final KeyDescriptor<IdIndexEntry> KEY_DESCRIPTOR = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };
    private static final DataExternalizer<Integer> VALUE_EXTERNALIZER = new DataExternalizer<Integer>(){

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            if (out == null) {
                2.$$$reportNull$$$0(0);
            }
            out.write((int)(value & 0xFF));
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                2.$$$reportNull$$$0(1);
            }
            return in.readByte() & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public int getVersion() {
        return 21 + IdIndexEntry.getUsedHashAlgorithmVersion();
    }

    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        ID<IdIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            IdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILES_FILTER;
        if (inputFilter == null) {
            IdIndex.$$$reportNull$$$0(1);
        }
        return inputFilter;
    }

    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return new CompositeDataIndexer<IdIndexEntry, Integer, FileTypeSpecificSubIndexer<IdIndexer>, String>(this){

            @Nullable
            public FileTypeSpecificSubIndexer<IdIndexer> calculateSubIndexer(@NotNull IndexedFile file) {
                FileType type;
                IdIndexer indexer;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (indexer = IdTableBuilding.getFileTypeIndexer(type = file.getFileType())) == null ? null : new FileTypeSpecificSubIndexer((Object)indexer, file.getFileType());
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                if (indexer == null) {
                    3.$$$reportNull$$$0(1);
                }
                String string = ((IdIndexer)indexer.getSubIndexerType()).getClass().getName() + ":" + ((IdIndexer)indexer.getSubIndexerType()).getVersion() + ":" + indexer.getFileType().getName();
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                return enumeratorStringDescriptor;
            }

            @NotNull
            public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) throws MapReduceIndexMappingException {
                Map<IdIndexEntry, Integer> map;
                if (inputData == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (indexer == null) {
                    3.$$$reportNull$$$0(5);
                }
                IdIndexer subIndexerType = (IdIndexer)indexer.getSubIndexerType();
                try {
                    Map<IdIndexEntry, Integer> idsMap = subIndexerType.map(inputData);
                    if (!(idsMap instanceof IdEntryToScopeMapImpl) && !idsMap.isEmpty()) {
                        THROTTLED_LOGGER.warn(() -> String.valueOf(subIndexerType.getClass()) + " for [" + inputData.getFile().getPath() + "] returned non-IdEntryToScopeMapImpl map (" + String.valueOf(idsMap.getClass()) + ").This is not incorrect, but ineffective -- it is strongly recommended to use com.intellij.psi.impl.cache.impl.id.IdDataConsumer helper class to collect IDs and occurrence masks (instead of plain Map impl) in your IdIndexer implementation ");
                        return new IdEntryToScopeMapImpl(idsMap);
                    }
                    map = idsMap;
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    throw new MapReduceIndexMappingException((Throwable)e, subIndexerType.getClass());
                }
                if (map == null) {
                    3.$$$reportNull$$$0(6);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        KeyDescriptor<IdIndexEntry> keyDescriptor = KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            IdIndex.$$$reportNull$$$0(2);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = VALUE_EXTERNALIZER;
        if (dataExternalizer == null) {
            IdIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    public int getCacheSize() {
        return 64 * super.getCacheSize();
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

