/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexConfiguration {
    private final Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent, ?>, FileBasedIndex.InputFilter>> myIndices = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Throwable> myInitializationProblems = new Int2ObjectOpenHashMap();
    private final List<ID<?, ?>> myIndexIds = new ArrayList();
    private final Object2IntMap<ID<?, ?>> myIndexIdToVersionMap = new Object2IntOpenHashMap();
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo = new ArrayList();
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap = CollectionFactory.createSmallMemoryFootprintMap();
    private volatile boolean myFreezed;

    @ApiStatus.Internal
    @Nullable
    public <K, V> UpdatableIndex<K, V, FileContent, ?> getIndex(@NotNull ID<K, V> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(0);
        }
        assert (this.myFreezed);
        Pair pair = (Pair)this.myIndices.get(indexId.getUniqueId());
        return (UpdatableIndex)Pair.getFirst((Pair)pair);
    }

    @Nullable
    @ApiStatus.Internal
    public Throwable getInitializationProblem(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(1);
        }
        return (Throwable)this.myInitializationProblems.get(indexId.getUniqueId());
    }

    @ApiStatus.Internal
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(2);
        }
        assert (this.myFreezed);
        Pair pair = (Pair)this.myIndices.get(indexId.getUniqueId());
        assert (pair != null) : "Index data is absent for index " + String.valueOf(indexId);
        FileBasedIndex.InputFilter inputFilter = (FileBasedIndex.InputFilter)pair.getSecond();
        if (inputFilter == null) {
            IndexConfiguration.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    @ApiStatus.Internal
    public void freeze() {
        this.myFreezed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void registerIndexInitializationProblem(@NotNull ID<?, ?> indexId, @NotNull Throwable problemTrace) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(4);
        }
        if (problemTrace == null) {
            IndexConfiguration.$$$reportNull$$$0(5);
        }
        assert (!this.myFreezed);
        Int2ObjectMap<Throwable> int2ObjectMap = this.myInitializationProblems;
        synchronized (int2ObjectMap) {
            this.myInitializationProblems.put(indexId.getUniqueId(), (Object)problemTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public <K, V> void registerIndex(@NotNull ID<K, V> indexId, @NotNull UpdatableIndex<K, V, FileContent, ?> index, @NotNull FileBasedIndex.InputFilter inputFilter, int version) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(6);
        }
        if (index == null) {
            IndexConfiguration.$$$reportNull$$$0(7);
        }
        if (inputFilter == null) {
            IndexConfiguration.$$$reportNull$$$0(8);
        }
        assert (!this.myFreezed);
        Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent, ?>, FileBasedIndex.InputFilter>> int2ObjectMap = this.myIndices;
        synchronized (int2ObjectMap) {
            this.myIndexIds.add(indexId);
            this.myIndexIdToVersionMap.put(indexId, version);
            Collection<FileType> associatedFileTypes = IndexConfiguration.getAssociatedFileTypes(inputFilter);
            if (associatedFileTypes != null) {
                for (FileType fileType : associatedFileTypes) {
                    List ids = this.myFileType2IndicesWithFileTypeInfoMap.computeIfAbsent(fileType, __ -> new ArrayList(5));
                    ids.add(indexId);
                }
            } else {
                this.myIndicesWithoutFileTypeInfo.add(indexId);
            }
            Pair old = (Pair)this.myIndices.put(indexId.getUniqueId(), (Object)new Pair(index, (Object)inputFilter));
            if (old != null) {
                throw new IllegalStateException("Index " + String.valueOf(old.first) + " already registered for the name '" + String.valueOf(indexId) + "'");
            }
        }
    }

    @Nullable
    private static Collection<FileType> getAssociatedFileTypes(@NotNull FileBasedIndex.InputFilter inputFilter) {
        HashSet<FileType> addedTypes;
        if (inputFilter == null) {
            IndexConfiguration.$$$reportNull$$$0(9);
        }
        if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
            addedTypes = new HashSet<FileType>();
            ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(type -> {
                if (type != null) {
                    addedTypes.add((FileType)type);
                }
            });
        } else {
            addedTypes = null;
        }
        return addedTypes;
    }

    @ApiStatus.Internal
    @NotNull
    public List<ID<?, ?>> getFileTypesForIndex(@NotNull FileType fileType) {
        if (fileType == null) {
            IndexConfiguration.$$$reportNull$$$0(10);
        }
        assert (this.myFreezed);
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        List<ID<?, ?>> list = ids;
        if (list == null) {
            IndexConfiguration.$$$reportNull$$$0(11);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void finalizeFileTypeMappingForIndices() {
        assert (!this.myFreezed);
        Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent, ?>, FileBasedIndex.InputFilter>> int2ObjectMap = this.myIndices;
        synchronized (int2ObjectMap) {
            for (List<ID<?, ?>> value : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                value.addAll(this.myIndicesWithoutFileTypeInfo);
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Collection<ID<?, ?>> getIndexIDs() {
        assert (this.myFreezed);
        List<ID<?, ?>> list = this.myIndexIds;
        if (list == null) {
            IndexConfiguration.$$$reportNull$$$0(12);
        }
        return list;
    }

    @ApiStatus.Internal
    public int getIndexVersion(@NotNull ID<?, ?> id) {
        if (id == null) {
            IndexConfiguration.$$$reportNull$$$0(13);
        }
        assert (this.myFreezed);
        return this.myIndexIdToVersionMap.getInt(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemTrace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesForIndex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexIDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitializationProblem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexInitializationProblem";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedFileTypes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypesForIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndexVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 12 -> new IllegalStateException(string);
        };
    }
}

