/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.impl.LanguageInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.LowLevelSearchUtilKt;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringSearcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007B'\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0018\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00070\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/psi/impl/search/InjectionAwareOccurrenceProcessor;", "Lkotlin/Function1;", "Lcom/intellij/model/search/LeafOccurrence;", "Lkotlin/ParameterName;", "name", "occurrence", "", "Lcom/intellij/psi/impl/search/OccurrenceProcessor;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processors", "Lcom/intellij/psi/impl/search/RequestProcessors;", "manager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "searcher", "Lcom/intellij/util/text/StringSearcher;", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/psi/impl/search/RequestProcessors;Lcom/intellij/lang/injection/InjectedLanguageManager;Lcom/intellij/util/text/StringSearcher;)V", "processedInjections", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/HashSet;", "invoke", "(Lcom/intellij/model/search/LeafOccurrence;)Ljava/lang/Boolean;", "getLanguageProcessors", "", "injectionLanguage", "Lcom/intellij/lang/Language;", "findInjectionAtOffset", "processHost", "intellij.platform.indexing.impl"})
public final class InjectionAwareOccurrenceProcessor
implements Function1<LeafOccurrence, Boolean> {
    @NotNull
    private final ProgressIndicator progress;
    @NotNull
    private final RequestProcessors processors;
    @NotNull
    private final InjectedLanguageManager manager;
    @NotNull
    private final StringSearcher searcher;
    @NotNull
    private final HashSet<PsiElement> processedInjections;

    public InjectionAwareOccurrenceProcessor(@NotNull ProgressIndicator progress, @NotNull RequestProcessors processors, @NotNull InjectedLanguageManager manager, @NotNull StringSearcher searcher) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        this.progress = progress;
        this.processors = processors;
        this.manager = manager;
        this.searcher = searcher;
        this.processedInjections = new HashSet();
    }

    @NotNull
    public Boolean invoke(@NotNull LeafOccurrence occurrence) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        if (this.processors.getInjectionProcessors().isEmpty()) {
            return this.processHost(occurrence);
        }
        PsiElement injected = this.findInjectionAtOffset(occurrence);
        if (injected == null) {
            return this.processHost(occurrence);
        }
        if (!this.processedInjections.add(injected)) {
            return true;
        }
        Language language = injected.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Collection<Function1<LeafOccurrence, Boolean>> injectionProcessors = this.getLanguageProcessors(language);
        if (injectionProcessors.isEmpty()) {
            return true;
        }
        int[] nArray = LowLevelSearchUtil.getTextOccurrencesInScope(injected, this.searcher);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTextOccurrencesInScope(...)");
        int[] offsets = nArray;
        int patternLength = this.searcher.getPatternLength();
        return LowLevelSearchUtilKt.processOffsets(injected, offsets, patternLength, this.progress, LowLevelSearchUtilKt.compound(injectionProcessors, this.progress));
    }

    private final Collection<Function1<LeafOccurrence, Boolean>> getLanguageProcessors(Language injectionLanguage) {
        Map<LanguageInfo, Collection<Function1<LeafOccurrence, Boolean>>> injectionProcessors = this.processors.getInjectionProcessors();
        SmartList result = new SmartList();
        for (Map.Entry<LanguageInfo, Collection<Function1<LeafOccurrence, Boolean>>> entry : injectionProcessors.entrySet()) {
            LanguageInfo languageInfo = entry.getKey();
            Collection<Function1<LeafOccurrence, Boolean>> processors = entry.getValue();
            if (!Intrinsics.areEqual((Object)languageInfo, (Object)LanguageInfo.NoLanguage.INSTANCE) && (!(languageInfo instanceof LanguageInfo.InLanguage) || !((LanguageInfo.InLanguage)languageInfo).getMatcher().matchesLanguage(injectionLanguage))) continue;
            CollectionsKt.addAll((Collection)((Collection)result), (Iterable)processors);
        }
        return (Collection)result;
    }

    private final PsiElement findInjectionAtOffset(LeafOccurrence occurrence) {
        Iterator<kotlin.Pair<PsiElement, Integer>> iterator = LowLevelSearchUtilKt.elementsUp(occurrence);
        while (iterator.hasNext()) {
            List injectedFiles;
            kotlin.Pair<PsiElement, Integer> pair = iterator.next();
            PsiElement currentElement = (PsiElement)pair.component1();
            int currentOffset = ((Number)pair.component2()).intValue();
            this.progress.checkCanceled();
            if (this.manager.getInjectedPsiFiles(currentElement) == null) continue;
            for (Pair pair2 : injectedFiles) {
                PsiElement injected = (PsiElement)ExtensionsKt.component1((Pair)pair2);
                TextRange range = (TextRange)ExtensionsKt.component2((Pair)pair2);
                if (!range.containsRange(currentOffset, currentOffset + this.searcher.getPatternLength())) continue;
                return injected;
            }
        }
        return null;
    }

    private final boolean processHost(LeafOccurrence occurrence) {
        return LowLevelSearchUtilKt.runProcessors(this.processors.getHostProcessors(), this.progress, occurrence);
    }
}

