/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.impl.InjectionInfo;
import com.intellij.model.search.impl.LanguageInfo;
import com.intellij.model.search.impl.QueryRequest;
import com.intellij.model.search.impl.QueryResult;
import com.intellij.model.search.impl.RequestsKt;
import com.intellij.model.search.impl.ValueResult;
import com.intellij.model.search.impl.WordRequest;
import com.intellij.model.search.impl.XResult;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.LayerResult;
import com.intellij.psi.impl.search.MyBulkOccurrenceProcessor;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.search.RequestAndProcessors;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.impl.search.WordRequestInfoImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchSession;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u0013H\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\bH\u0002J*\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001e0\u00130\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\bH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0\u00132\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0016\u0010!\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\bH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/psi/impl/search/Layer;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "queryRequests", "", "Lcom/intellij/model/search/impl/QueryRequest;", "wordRequests", "Lcom/intellij/model/search/impl/WordRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/Collection;Ljava/util/Collection;)V", "myHelper", "Lcom/intellij/psi/impl/search/PsiSearchHelperImpl;", "runLayer", "Lcom/intellij/psi/impl/search/LayerResult;", "processor", "Lcom/intellij/util/Processor;", "processWordRequests", "", "Lcom/intellij/model/search/impl/XResult;", "distributeWordRequests", "Lcom/intellij/psi/impl/search/RequestAndProcessors;", "processGlobalRequests", "globals", "scopeProcessors", "", "Lcom/intellij/psi/impl/search/WordRequestInfo;", "Lcom/intellij/psi/impl/search/PsiSearchHelperImpl$CandidateFileInfo;", "scopeProcessor", "requestAndProcessors", "processLocalRequests", "locals", "processSingleRequest", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nhelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 helper.kt\ncom/intellij/psi/impl/search/Layer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n382#2,7:322\n382#2,7:329\n382#2,7:344\n126#3:336\n153#3,3:337\n1504#4:340\n1534#4,3:341\n1537#4,3:351\n*S KotlinDebug\n*F\n+ 1 helper.kt\ncom/intellij/psi/impl/search/Layer\n*L\n196#1:322,7\n210#1:329,7\n229#1:344,7\n214#1:336\n214#1:337,3\n229#1:340\n229#1:341,3\n229#1:351,3\n*E\n"})
final class Layer<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final ProgressIndicator progress;
    @NotNull
    private final Collection<QueryRequest<?, T>> queryRequests;
    @NotNull
    private final Collection<WordRequest<T>> wordRequests;
    @NotNull
    private final PsiSearchHelperImpl myHelper;

    public Layer(@NotNull Project project, @NotNull ProgressIndicator progress, @NotNull Collection<? extends QueryRequest<?, ? extends T>> queryRequests, @NotNull Collection<? extends WordRequest<? extends T>> wordRequests) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter(queryRequests, (String)"queryRequests");
        Intrinsics.checkNotNullParameter(wordRequests, (String)"wordRequests");
        this.project = project;
        this.progress = progress;
        this.queryRequests = queryRequests;
        this.wordRequests = wordRequests;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)psiSearchHelper, (String)"null cannot be cast to non-null type com.intellij.psi.impl.search.PsiSearchHelperImpl");
        this.myHelper = (PsiSearchHelperImpl)psiSearchHelper;
    }

    @NotNull
    public final LayerResult<T> runLayer(@NotNull Processor<? super T> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        List subQueries = Collections.synchronizedList(new ArrayList());
        Processor xProcessor = arg_0 -> Layer.runLayer$lambda$0(processor, subQueries, arg_0);
        if (!HelperKt.access$processQueryRequests(this.progress, this.queryRequests, xProcessor)) {
            return LayerResult.Stop.INSTANCE;
        }
        if (!this.processWordRequests(xProcessor)) {
            return LayerResult.Stop.INSTANCE;
        }
        Intrinsics.checkNotNull(subQueries);
        return new LayerResult.Ok(subQueries);
    }

    private final boolean processWordRequests(Processor<? super XResult<? extends T>> processor) {
        if (this.wordRequests.isEmpty()) {
            return true;
        }
        Collection<RequestAndProcessors> allRequests = this.distributeWordRequests(processor);
        SmartList globals = new SmartList();
        SmartList locals = new SmartList();
        for (RequestAndProcessors requestAndProcessor : allRequests) {
            if (requestAndProcessor.getRequest().getSearchScope() instanceof LocalSearchScope) {
                ((Collection)locals).add(requestAndProcessor);
                continue;
            }
            ((Collection)globals).add(requestAndProcessor);
        }
        return this.processGlobalRequests((Collection)globals) && this.processLocalRequests((Collection)locals);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<RequestAndProcessors> distributeWordRequests(Processor<? super XResult<? extends T>> processor) {
        void $this$mapTo$iv$iv;
        Function1<LeafOccurrence, Boolean> occurrenceProcessor;
        LinkedHashMap theMap = new LinkedHashMap();
        for (WordRequest<T> wordRequest : this.wordRequests) {
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            void $this$getOrPut$iv2;
            this.progress.checkCanceled();
            occurrenceProcessor = RequestsKt.occurrenceProcessor(wordRequest, processor);
            Map map = theMap;
            WordRequestInfoImpl key$iv = wordRequest.getSearchWordRequest();
            boolean $i$f$getOrPut22 = false;
            Object value$iv = $this$getOrPut$iv2.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Pair answer$iv = new Pair((Object)new SmartList(), new LinkedHashMap());
                $this$getOrPut$iv2.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Pair byRequest = (Pair)object2;
            InjectionInfo injectionInfo = wordRequest.getInjectionInfo();
            if (Intrinsics.areEqual((Object)injectionInfo, (Object)InjectionInfo.NoInjection.INSTANCE) || Intrinsics.areEqual((Object)injectionInfo, (Object)InjectionInfo.IncludeInjections.INSTANCE)) {
                ((Collection)byRequest.getFirst()).add(occurrenceProcessor);
            }
            if (!(injectionInfo instanceof InjectionInfo.InInjection) && !Intrinsics.areEqual((Object)injectionInfo, (Object)InjectionInfo.IncludeInjections.INSTANCE)) continue;
            LanguageInfo languageInfo = injectionInfo instanceof InjectionInfo.InInjection ? ((InjectionInfo.InInjection)injectionInfo).getLanguageInfo() : (LanguageInfo)LanguageInfo.NoLanguage.INSTANCE;
            Map $i$f$getOrPut22 = (Map)byRequest.getSecond();
            LanguageInfo key$iv2 = languageInfo;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl = false;
                Collection answer$iv = (Collection)new SmartList();
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            ((Collection)object).add(occurrenceProcessor);
        }
        Function1<LeafOccurrence, Boolean> $this$map$iv = (Function1<LeafOccurrence, Boolean>)theMap;
        boolean $i$f$map = false;
        occurrenceProcessor = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WordRequestInfo wordRequest = (WordRequestInfo)entry.getKey();
            Pair byRequest = (Pair)entry.getValue();
            this.progress.checkCanceled();
            Collection hostProcessors = (Collection)byRequest.component1();
            Map injectionProcessors = (Map)byRequest.component2();
            collection.add(new RequestAndProcessors(wordRequest, new RequestProcessors(hostProcessors, injectionProcessors)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processGlobalRequests(Collection<RequestAndProcessors> globals) {
        void $this$groupByTo$iv$iv;
        if (globals.isEmpty()) {
            return true;
        }
        if (globals.size() == 1) {
            return this.processSingleRequest((RequestAndProcessors)CollectionsKt.first((Iterable)globals));
        }
        Iterable $this$groupBy$iv = globals;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            PsiSearchHelperImpl.TextIndexQuery key$iv$iv;
            RequestAndProcessors requestAndProcessors = (RequestAndProcessors)element$iv$iv;
            boolean bl = false;
            WordRequestInfo request = requestAndProcessors.component1();
            Intrinsics.checkNotNullExpressionValue((Object)PsiSearchHelperImpl.TextIndexQuery.fromWord(request.getWord(), request.isCaseSensitive(), (short)-1), (String)"fromWord(...)");
            Map map = destination$iv$iv;
            PsiSearchHelperImpl.TextIndexQuery key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            requestAndProcessors = (RequestAndProcessors)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            request = requestAndProcessors.component1();
            this.progress.checkCanceled();
            list.add(request);
        }
        Map globalsIds = destination$iv$iv;
        return this.myHelper.processGlobalRequests(globalsIds, this.progress, this.scopeProcessors(globals));
    }

    private final Map<WordRequestInfo, Processor<? super PsiSearchHelperImpl.CandidateFileInfo>> scopeProcessors(Collection<RequestAndProcessors> globals) {
        HashMap result = new HashMap();
        for (RequestAndProcessors requestAndProcessors : globals) {
            this.progress.checkCanceled();
            ((Map)result).put(requestAndProcessors.getRequest(), this.scopeProcessor(requestAndProcessors));
        }
        return result;
    }

    private final Processor<? super PsiSearchHelperImpl.CandidateFileInfo> scopeProcessor(RequestAndProcessors requestAndProcessors) {
        WordRequestInfo request = requestAndProcessors.component1();
        RequestProcessors processors = requestAndProcessors.component2();
        StringSearcher searcher = new StringSearcher(request.getWord(), request.isCaseSensitive(), true, false);
        MyBulkOccurrenceProcessor adapted = new MyBulkOccurrenceProcessor(this.project, processors);
        Processor<? super PsiSearchHelperImpl.CandidateFileInfo> processor = PsiSearchHelperImpl.localProcessor(searcher, adapted);
        Intrinsics.checkNotNullExpressionValue(processor, (String)"localProcessor(...)");
        return processor;
    }

    private final boolean processLocalRequests(Collection<RequestAndProcessors> locals) {
        if (locals.isEmpty()) {
            return true;
        }
        for (RequestAndProcessors requestAndProcessors : locals) {
            this.progress.checkCanceled();
            if (this.processSingleRequest(requestAndProcessors)) continue;
            return false;
        }
        return true;
    }

    private final boolean processSingleRequest(RequestAndProcessors requestAndProcessors) {
        WordRequestInfo request = requestAndProcessors.component1();
        RequestProcessors processors = requestAndProcessors.component2();
        EnumSet<Enum> options = EnumSet.of((Enum)PsiSearchHelperImpl.Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (request.isCaseSensitive()) {
            options.add(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH);
        }
        return this.myHelper.bulkProcessElementsWithWord(request.getSearchScope(), request.getWord(), request.getSearchContext(), options, request.getContainerName(), new SearchSession(), new MyBulkOccurrenceProcessor(this.project, processors));
    }

    private static final boolean runLayer$lambda$0(Processor $processor, List $subQueries, XResult result) {
        boolean bl;
        XResult xResult = result;
        if (xResult instanceof ValueResult) {
            bl = $processor.process(((ValueResult)result).getValue());
        } else if (xResult instanceof QueryResult) {
            $subQueries.add(((QueryResult)result).getQuery());
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

