/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.indexing.BinaryFileSourceProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileRankerMlService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    public static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        return PsiSearchHelperImpl.getUseScope(element, false);
    }

    @NotNull
    public SearchScope getCodeUsageScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return PsiSearchHelperImpl.getUseScope(element, true);
    }

    @NotNull
    private static SearchScope getUseScope(@NotNull PsiElement element, boolean restrictToCodeUsageScope) {
        SearchScope scope;
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        if ((scope = (SearchScope)PsiSearchScopeUtil.USE_SCOPE_KEY.get((UserDataHolder)element.getContainingFile())) != null) {
            SearchScope searchScope = scope;
            if (searchScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(3);
            }
            return searchScope;
        }
        scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : UseScopeEnlarger.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = null;
            try {
                additionalScope = enlarger.getAdditionalUseScope(element);
            }
            catch (IndexNotReadyException pce) {
                LOG.debug("ProcessCanceledException thrown while getUseScope() calculation", (Throwable)pce);
            }
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        scope = PsiSearchHelperImpl.restrictScope(scope, USE_SCOPE_OPTIMIZER_EP_NAME.getExtensionList(), element);
        if (restrictToCodeUsageScope) {
            scope = PsiSearchHelperImpl.restrictScope(scope, CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME.getExtensionList(), element);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    @NotNull
    private static SearchScope restrictScope(@NotNull SearchScope baseScope, @NotNull List<? extends ScopeOptimizer> optimizers, @NotNull PsiElement element) {
        SearchScope scopeToRestrict;
        if (baseScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        if (optimizers == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if ((scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope(optimizers, (PsiElement)element)) != null) {
            SearchScope searchScope = baseScope.intersectWith(scopeToRestrict);
            if (searchScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(8);
            }
            return searchScope;
        }
        SearchScope searchScope = baseScope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        this.myManager = PsiManagerEx.getInstanceEx((Project)project);
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        List result = Collections.synchronizedList(new ArrayList());
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.processCommentsContainingIdentifier(identifier, searchScope, (Processor<? super PsiElement>)processor);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        TextOccurenceProcessor occurrenceProcessor = (element, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement((PsiElement)element) && element.findReferenceAt(offsetInElement) == null) {
                return processor.process((Object)element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        return this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        EnumSet<Options> options = PsiSearchHelperImpl.makeOptions(caseSensitive, processInjectedPsi);
        return this.processElementsWithWord(searchScope, text, searchContext, options, null, new SearchSession(), processor);
    }

    public boolean hasIdentifierInFile(@NotNull PsiFile psiFile, @NotNull String name) {
        if (psiFile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        PsiUtilCore.ensureValid((PsiElement)psiFile);
        if (psiFile.getVirtualFile() == null || DumbService.isDumb((Project)psiFile.getProject())) {
            return StringUtil.contains((CharSequence)psiFile.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)psiFile);
        IdIndexEntry key = new IdIndexEntry(name, true);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)key, fileScope).isEmpty();
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        boolean result = this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)result);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        return asyncFuture;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, @NotNull SearchSession session, @NotNull TextOccurenceProcessor processor) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options, containerName, session, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, @NotNull SearchSession session, final @NotNull BulkOccurrenceProcessor processor) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, session, progress, processor);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(this){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + String.valueOf(scopeElement) + " of class " + String.valueOf(scopeElement.getClass()) + " has null range");
                    return true;
                }
                return processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, (Processor)localProcessor);
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data, @NotNull TextIndexQuery query) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (data == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        if (query == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        TextIndexQuery commonNameQuery = TextIndexQuery.fromWord(commonName, caseSensitive, searchContext);
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        Processor processor = Processors.cancelableCollectProcessor(hashSet);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)processor, query, commonNameQuery);
        return hashSet;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, @Nullable PsiFile psiFileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        PsiSearchHelper.SearchCostResult searchCostResult = this.isCheapEnoughToSearch(name, scope, psiFileToIgnoreOccurrencesIn);
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        return searchCostResult;
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile psiFileToIgnoreOccurrencesIn) {
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        if (!((Boolean)ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty())).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(51);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor = new Processor<VirtualFile>(this){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = psiFileToIgnoreOccurrencesIn == null ? null : psiFileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                assert (file != null);
                long estimatedLength = file.isDirectory() ? 0L : file.getLength();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(estimatedLength);
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        TextIndexQuery query = TextIndexQuery.fromWord(name, true, (short)-1);
        boolean cheap = PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, (Processor<? super VirtualFile>)processor, query);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(52);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        return searchCostResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session, @NotNull ProgressIndicator progress, @NotNull BulkOccurrenceProcessor processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        progress.setIndeterminate(false);
        progress.pushState();
        try {
            progress.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            Processor<? super CandidateFileInfo> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, processor);
            List<List<VirtualFile>> priorities = this.computePriorities(scope, searcher, searchContext, caseSensitively, containerName, session);
            if (priorities.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            int totalSize = priorities.stream().mapToInt(l -> l.size()).sum();
            progress.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{searcher.getPattern(), totalSize}));
            int alreadyProcessedFiles = 0;
            for (List<VirtualFile> files : priorities) {
                if (!this.processPsiFileRoots(files, totalSize, alreadyProcessedFiles, progress, localProcessor)) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += files.size();
            }
        }
        finally {
            progress.popState();
        }
        return true;
    }

    @NotNull
    private List<List<VirtualFile>> computePriorities(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session) {
        List directories;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        String text = searcher.getPattern();
        HashSet allFiles = new HashSet();
        this.getFilesWithText(scope, searchContext, caseSensitively, text, allFiles);
        ArrayList<List<VirtualFile>> priorities = new ArrayList<List<VirtualFile>>();
        List targets = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)session.getTargetVirtualFiles(), arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)));
        if (targets.isEmpty()) {
            directories = Collections.emptyList();
        } else {
            priorities.add(targets);
            targets.forEach(allFiles::remove);
            directories = ContainerUtil.mapNotNull((Collection)targets, v -> v.getParent());
            DelegatingGlobalSearchScope directoryNearTargetScope = new DelegatingGlobalSearchScope(this, scope){

                public boolean contains(@NotNull VirtualFile file) {
                    if (file == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return super.contains(file) && directories.contains(file.getParent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiSearchHelperImpl$3", "contains"));
                }
            };
            List directoryNearTargetFiles = (List)ReadAction.compute(() -> PsiSearchHelperImpl.lambda$computePriorities$7(allFiles, (GlobalSearchScope)directoryNearTargetScope, targets));
            if (!directoryNearTargetFiles.isEmpty()) {
                priorities.add(directoryNearTargetFiles);
                directoryNearTargetFiles.forEach(allFiles::remove);
            }
        }
        if (containerName != null) {
            HashSet intersectionWithContainerFiles = new HashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, intersectionWithContainerFiles);
            targets.forEach(intersectionWithContainerFiles::remove);
            directories.forEach(intersectionWithContainerFiles::remove);
            if (!intersectionWithContainerFiles.isEmpty()) {
                priorities.add(new ArrayList(intersectionWithContainerFiles));
                allFiles.removeAll(intersectionWithContainerFiles);
            }
        }
        if (!allFiles.isEmpty()) {
            priorities.add(new ArrayList(allFiles));
        }
        ArrayList<List<VirtualFile>> arrayList = priorities;
        if (arrayList == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super CandidateFileInfo> localProcessor) {
        if (files == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        return (Boolean)this.myManager.runInBatchFilesMode(() -> {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            if (progress.isRunning()) {
                progress.setIndeterminate(false);
            }
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll((ProgressIndicator)progress);
            return PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files, progress, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                TooManyUsagesStatus.getFrom((ProgressIndicator)originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (IndexNotReadyException | CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress.isRunning() && !progress.isIndeterminate()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress.setFraction(fraction);
                }
                return !stopped.get();
            }));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files, @NotNull ProgressIndicator progress, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        if (files == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files.size()));
        while (true) {
            ProgressManager.checkCanceled();
            SensitiveProgressWrapper wrapper = new SensitiveProgressWrapper(progress);
            ApplicationListener listener = new ApplicationListener((ProgressIndicator)wrapper){
                final /* synthetic */ ProgressIndicator val$wrapper;
                {
                    this.val$wrapper = progressIndicator;
                }

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.val$wrapper.cancel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/search/PsiSearchHelperImpl$4", "beforeWriteActionStart"));
                }
            };
            processedFiles.clear();
            Disposable disposable = Disposer.newDisposable();
            app.addApplicationListener(listener, disposable);
            boolean processorCanceled = false;
            try {
                if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files);
                } else if (app.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor processor = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor.process(vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files, (ProgressIndicator)wrapper, processor);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)disposable);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files.size()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            HashSet<? extends VirtualFile> t = new HashSet<VirtualFile>(files);
            List<? extends VirtualFile> list = processedFiles;
            synchronized (list) {
                t.removeAll(processedFiles);
            }
            files = new ArrayList<VirtualFile>(t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super CandidateFileInfo> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        if (!vfile.isDirectory() && !vfile.getFileType().isBinary()) {
            try {
                vfile.contentsToByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
            boolean skipDefaultContext;
            List allContexts;
            if (!vfile.isValid()) {
                return;
            }
            if (CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.myManager.getProject())) {
                allContexts = CodeInsightContextManager.getInstance((Project)this.myManager.getProject()).getCodeInsightContexts(vfile);
                skipDefaultContext = ContainerUtil.find((Iterable)allContexts, c -> c != CodeInsightContexts.defaultContext()) != null;
            } else {
                allContexts = Collections.singletonList(CodeInsightContexts.defaultContext());
                skipDefaultContext = false;
            }
            block0: for (CodeInsightContext context : allContexts) {
                PsiBinaryFile binaryFile;
                PsiFile originalPsiFile;
                if (skipDefaultContext && context == CodeInsightContexts.defaultContext()) continue;
                PsiFile psiFile = this.myManager.findFile(vfile, context);
                if (psiFile instanceof PsiBinaryFile && (originalPsiFile = PsiSearchHelperImpl.findOriginalPsiFile(binaryFile = (PsiBinaryFile)psiFile)) != null) {
                    psiFile = originalPsiFile;
                }
                if (psiFile == null || psiFile instanceof PsiBinaryFile) continue;
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (!DumbUtil.getInstance((Project)project).mayUseIndices()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                FileViewProvider provider = psiFile.getViewProvider();
                List psiRoots = provider.getAllFiles();
                HashSet<PsiFile> processed = new HashSet<PsiFile>(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + String.valueOf(psiFile) + " is null. All roots: " + String.valueOf(psiRoots) + "; ViewProvider: " + String.valueOf(provider) + "; Virtual file: " + String.valueOf(provider.getVirtualFile());
                    if (!processed.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)new CandidateFileInfo(vfile, psiRoot))) continue;
                    stopped.set(true);
                    continue block0;
                }
            }
        })) {
            throw ApplicationUtil.CannotRunReadActionException.create();
        }
    }

    @Nullable
    private static PsiFile findOriginalPsiFile(@NotNull PsiBinaryFile psiFile) {
        if (psiFile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        List providers = BinaryFileSourceProvider.EP.getExtensionList();
        for (BinaryFileSourceProvider provider : providers) {
            PsiFile originalFile = provider.findSourceFile(psiFile);
            if (originalFile == null) continue;
            return originalFile;
        }
        return null;
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<? super VirtualFile> result) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        if (result == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        this.processCandidateFilesForText(scope, searchContext, caseSensitively, text, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(result));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, boolean useOnlyWordHashToSearch, @NotNull String text, @NotNull Processor<? super VirtualFile> processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, processor, TextIndexQuery.fromWord(text, caseSensitively, useOnlyWordHashToSearch, searchContext));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<? super VirtualFile> processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        return this.processCandidateFilesForText(scope, searchContext, caseSensitively, false, text, processor);
    }

    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        PsiFile[] psiFileArray = CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        return psiFileArray;
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope initialScope) {
        GlobalSearchScope theSearchScope;
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + String.valueOf(originalElement) + "; " + String.valueOf(originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        PsiFile[] files = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> this.lambda$processUsagesInNonJavaFiles$15(wordToSearch, theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        })));
        if (files.length == 0) {
            return true;
        }
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress.setText(IndexingBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            AtomicInteger i = new AtomicInteger();
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(files), progress, psiFile -> {
                if (psiFile instanceof PsiBinaryFile) {
                    return true;
                }
                CharSequence text = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTexts(text, 0, text.length(), searcher, index -> {
                    boolean isReferenceOK = (Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor.process(psiFile, index, index + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    return false;
                }
                progress.setFraction((double)i.incrementAndGet() / (double)files.length);
                return true;
            });
        }
        finally {
            progress.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor, word, (short)4, scope, true);
    }

    @NotNull
    private static EnumSet<Options> makeOptions(boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        EnumSet<Options> enumSet = options;
        if (enumSet == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        return enumSet;
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        QueryRequestsRunResult result;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<TextIndexQuery, Collection<RequestWithProcessor>> globals = new HashMap<TextIndexQuery, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            HashMap<RequestWithProcessor, Processor<? super CandidateFileInfo>> localProcessors = new HashMap<RequestWithProcessor, Processor<? super CandidateFileInfo>>();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress, localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress.checkCanceled();
                if (this.processSingleRequest(local.request, local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors);
            if (result != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        progress.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        return progressIndicator;
    }

    @NotNull
    static Processor<? super CandidateFileInfo> localProcessor(final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor) {
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        return new ReadActionProcessor<CandidateFileInfo>(){

            public boolean processInReadAction(CandidateFileInfo candidateFileInfo) {
                PsiFile scopeElement = candidateFileInfo.psiFile();
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor.execute((PsiElement)scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope((PsiElement)scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<? super CandidateFileInfo>> localProcessors) {
        Collection<RequestWithProcessor> requests;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull ProgressIndicator progress, @NotNull Map<T, Processor<? super CandidateFileInfo>> localProcessors) {
        boolean result;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        progress.pushState();
        progress.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            HashMap<VirtualFile, Collection<T>> targetFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> nearDirectoryFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> intersectionCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> restCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            int totalSize = this.collectFiles(singles, targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles);
            if (totalSize == 0) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.concat(allWords), totalSize}));
            int alreadyProcessedFiles = 0;
            FileRankerMlService fileRankerService = FileRankerMlService.getInstance();
            boolean useOldImpl = fileRankerService == null || fileRankerService.shouldUseOldImplementation();
            ArrayList<String> queryNames = new ArrayList<String>(allWords);
            List queryFiles = (List)ReadAction.compute(() -> ContainerUtil.flatMap(localProcessors.keySet(), requestInfo -> requestInfo.getSearchSession().getTargetVirtualFiles()));
            result = useOldImpl ? this.processCandidatesInChunks(progress, localProcessors, targetFiles, totalSize, alreadyProcessedFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles, fileRankerService, queryNames, queryFiles) : this.processCandidatesInOneCall(progress, localProcessors, targetFiles, totalSize, alreadyProcessedFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles, fileRankerService, queryNames, queryFiles);
        }
        finally {
            progress.popState();
        }
        return result;
    }

    private <T extends WordRequestInfo> Optional<Integer> processUnsortedCandidates(@NotNull Map<T, Processor<? super CandidateFileInfo>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        boolean result;
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(116);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        if (!candidateFiles.isEmpty() && !(result = this.processCandidates(localProcessors, candidateFiles, new ArrayList<VirtualFile>(candidateFiles.keySet()), progress, totalSize, alreadyProcessedFiles))) {
            return Optional.empty();
        }
        return Optional.of(alreadyProcessedFiles + candidateFiles.size());
    }

    private <T extends WordRequestInfo> boolean processCandidatesInChunks(@NotNull ProgressIndicator progress, @NotNull Map<T, Processor<? super CandidateFileInfo>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> targetFiles, int totalSize, int alreadyProcessedFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> intersectionCandidateFiles, @NotNull Map<VirtualFile, Collection<T>> restCandidateFiles, @Nullable FileRankerMlService fileRankerMlService, @NotNull List<String> queryNames, @NotNull List<? extends VirtualFile> queryFiles) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        if (intersectionCandidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        if (restCandidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        if (queryNames == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        if (queryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        if (fileRankerMlService != null) {
            ArrayList<VirtualFile> candidateFiles = new ArrayList<VirtualFile>(totalSize);
            candidateFiles.addAll(targetFiles.keySet());
            candidateFiles.addAll(nearDirectoryFiles.keySet());
            candidateFiles.addAll(intersectionCandidateFiles.keySet());
            candidateFiles.addAll(restCandidateFiles.keySet());
            fileRankerMlService.getFileOrder(queryNames, queryFiles, candidateFiles);
        }
        for (Map<VirtualFile, Collection<T>> files : List.of(targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles)) {
            Optional<Integer> resultProcessed = this.processUnsortedCandidates(localProcessors, files, progress, totalSize, alreadyProcessedFiles);
            if (resultProcessed.isEmpty()) {
                return false;
            }
            alreadyProcessedFiles = resultProcessed.get();
        }
        return true;
    }

    private <T extends WordRequestInfo> boolean processCandidatesInOneCall(@NotNull ProgressIndicator progress, @NotNull Map<T, Processor<? super CandidateFileInfo>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> targetFiles, int totalSize, int alreadyProcessedFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> intersectionCandidateFiles, @NotNull Map<VirtualFile, Collection<T>> restCandidateFiles, @Nullable FileRankerMlService fileRankerService, @NotNull List<String> queryNames, @NotNull List<? extends VirtualFile> queryFiles) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(127);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(128);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(129);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(130);
        }
        if (intersectionCandidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(131);
        }
        if (restCandidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(132);
        }
        if (queryNames == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(133);
        }
        if (queryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(134);
        }
        HashMap<VirtualFile, Collection<T>> allFiles = new HashMap<VirtualFile, Collection<T>>(totalSize);
        allFiles.putAll(targetFiles);
        allFiles.putAll(nearDirectoryFiles);
        allFiles.putAll(intersectionCandidateFiles);
        allFiles.putAll(restCandidateFiles);
        ArrayList<VirtualFile> allFilesList = new ArrayList<VirtualFile>(totalSize);
        allFilesList.addAll(targetFiles.keySet());
        allFilesList.addAll(nearDirectoryFiles.keySet());
        allFilesList.addAll(intersectionCandidateFiles.keySet());
        allFilesList.addAll(restCandidateFiles.keySet());
        List orderedFiles = fileRankerService.getFileOrder(queryNames, queryFiles, allFilesList);
        return this.processCandidates(localProcessors, allFiles, orderedFiles, progress, totalSize, alreadyProcessedFiles);
    }

    private <T> boolean processCandidates(@NotNull Map<T, Processor<? super CandidateFileInfo>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull List<? extends VirtualFile> orderedFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(135);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(136);
        }
        if (orderedFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(137);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(138);
        }
        return this.processPsiFileRoots(orderedFiles, totalSize, alreadyProcessedFiles, progress, (Processor<? super CandidateFileInfo>)((Processor)candidateInfo -> {
            VirtualFile vfile = candidateInfo.candidateVirtualFile();
            if (vfile instanceof BackedVirtualFile) {
                vfile = ((BackedVirtualFile)vfile).getOriginFile();
            }
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(candidateInfo)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(139);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(140);
        }
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            progress.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                progress.checkCanceled();
                if (!request.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(141);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, (Processor<? super PsiReference>)request.processor);
                queue.addLast(request.collector);
                changed = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(142);
        }
        return queryRequestsRunResult;
    }

    @NotNull
    private static CharSequence concat(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(143);
        }
        StringBuilder result = new StringBuilder(50);
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string.isEmpty()) continue;
            if (result.length() > 50) {
                result.append("...");
                break;
            }
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(string);
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(144);
        }
        return stringBuilder;
    }

    private <T extends WordRequestInfo> int collectFiles(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> targetFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> containerNameFiles, @NotNull Map<VirtualFile, Collection<T>> restFiles) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(145);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(146);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(147);
        }
        if (containerNameFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(148);
        }
        if (restFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(149);
        }
        for (Map.Entry<TextIndexQuery, Collection<T>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            TextIndexQuery key = entry.getKey();
            if (key.isEmpty()) continue;
            Collection<T> processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set thisTargetFiles = (Set)ReadAction.compute(() -> processors.stream().flatMap(p -> {
                List files = p.getSearchSession().getTargetVirtualFiles();
                return files.stream();
            }).filter(arg_0 -> ((GlobalSearchScope)commonScope).contains(arg_0)).collect(Collectors.toSet()));
            Set thisTargetDirectories = ContainerUtil.map2SetNotNull((Collection)thisTargetFiles, f -> f.getParent());
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, key);
            ArrayList allFilesForKeys = new ArrayList();
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(allFilesForKeys), key);
            Object2IntOpenHashMap file2Mask = new Object2IntOpenHashMap();
            file2Mask.defaultReturnValue(-1);
            IntRef maskRef = new IntRef();
            for (VirtualFile file : allFilesForKeys) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry idIndexEntry : key.myIdIndexEntries) {
                    ProgressManager.checkCanceled();
                    maskRef.set(0);
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file, (__, value) -> {
                        maskRef.set(value.intValue());
                        return true;
                    }, commonScope));
                    int oldMask = file2Mask.getOrDefault((Object)file, 255);
                    file2Mask.put((Object)file, oldMask & maskRef.get());
                }
            }
            for (Object2IntMap.Entry fileEntry : file2Mask.object2IntEntrySet()) {
                VirtualFile file = (VirtualFile)fileEntry.getKey();
                int n = fileEntry.getIntValue();
                this.myDumbService.runReadActionInSmartMode(() -> {
                    Map result = thisTargetFiles.contains(file) ? targetFiles : (thisTargetDirectories.contains(file.getParent()) ? nearDirectoryFiles : (intersectionWithContainerNameFiles != null && intersectionWithContainerNameFiles.contains(file) ? containerNameFiles : restFiles));
                    for (WordRequestInfo single : processors) {
                        ProgressManager.checkCanceled();
                        if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file)) continue;
                        result.computeIfAbsent(file, ___ -> new SmartList()).add(single);
                    }
                });
            }
        }
        return targetFiles.size() + nearDirectoryFiles.size() + containerNameFiles.size() + restFiles.size();
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(150);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(151);
        }
        final boolean ignoreInjectedPsi = (searchScope = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (searcher == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (offsetsInScope == null) {
                    6.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                    if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                        return true;
                    }
                    return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                });
            }

            public String toString() {
                return consumer.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "offsetsInScope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$6";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static Condition<Integer> matchContextCondition(short searchContext) {
        Condition condition = context -> (context & searchContext) != 0;
        if (condition == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(152);
        }
        return condition;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests) {
        if (requests == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(153);
        }
        Set scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)r.getSearchScope());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(154);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super CandidateFileInfo>> localProcessors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(155);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(156);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(157);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(158);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(159);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor);
                    continue;
                }
                TextIndexQuery key = TextIndexQuery.fromWord(primitive.word, primitive.caseSensitive, (short)-1);
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), primitive, processor);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor)));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<? super CandidateFileInfo> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, adapted);
                Processor<? super CandidateFileInfo> old = localProcessors.put(singleRequest, localProcessor);
                assert (old == null) : String.valueOf(old) + ";" + String.valueOf(localProcessor) + "; singleRequest=" + String.valueOf(singleRequest);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(160);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(161);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(162);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(163);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(164);
        }
        EnumSet<Options> options = PsiSearchHelperImpl.makeOptions(single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope));
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, single.getSearchSession(), PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor, TextIndexQuery ... textIndexQueries) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(165);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(166);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(167);
        }
        if (textIndexQueries == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(168);
        }
        if (ContainerUtil.all((Object[])textIndexQueries, query -> query.isEmpty())) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            List words = ContainerUtil.map((Object[])textIndexQueries, q -> StringUtil.join(q.getInitialWords(), (String)" "));
            LOG.trace("searching for words " + String.valueOf(words) + " in " + String.valueOf(scope));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed() && (!DumbService.isDumb((Project)project) || FileBasedIndex.getInstance().getCurrentDumbModeAccessType(project) != null)) {
            return PsiSearchHelperImpl.computeQueries(scope, processor, textIndexQueries);
        }
        return (Boolean)ReadAction.compute(() -> (Boolean)DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> PsiSearchHelperImpl.computeQueries(scope, processor, textIndexQueries)));
    }

    private static boolean computeQueries(@NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor, @NotNull @NotNull TextIndexQuery @NotNull [] textIndexQueries) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(169);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(170);
        }
        if (textIndexQueries == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(171);
        }
        List queries = ContainerUtil.concat((Object[])textIndexQueries, q -> q.toFileBasedIndexQueries());
        return FileBasedIndex.getInstance().processFilesContainingAllKeys((Collection)queries, scope, processor);
    }

    private /* synthetic */ PsiFile[] lambda$processUsagesInNonJavaFiles$15(String wordToSearch, GlobalSearchScope theSearchScope) {
        return CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true);
    }

    private static /* synthetic */ List lambda$computePriorities$7(Set allFiles, GlobalSearchScope directoryNearTargetScope, List targets) throws RuntimeException {
        return ContainerUtil.filter((Collection)allFiles, f -> directoryNearTargetScope.contains(f) && !targets.contains(f));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 13, 28, 31, 48, 51, 52, 53, 62, 85, 104, 107, 141, 142, 144, 152, 154 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 28: 
            case 31: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 85: 
            case 104: 
            case 107: 
            case 141: 
            case 142: 
            case 144: 
            case 152: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizers";
                break;
            }
            case 10: 
            case 66: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 32: 
            case 37: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 25: 
            case 30: 
            case 36: 
            case 41: 
            case 58: 
            case 80: 
            case 83: 
            case 87: 
            case 90: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 162: 
            case 167: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 22: 
            case 27: 
            case 33: 
            case 38: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 24: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 35: 
            case 40: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 45: 
            case 47: 
            case 50: 
            case 54: 
            case 59: 
            case 75: 
            case 78: 
            case 81: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 166: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 55: 
            case 60: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 57: 
            case 64: 
            case 68: 
            case 111: 
            case 114: 
            case 118: 
            case 119: 
            case 127: 
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 65: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 84: 
            case 92: 
            case 95: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 110: 
            case 113: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 112: 
            case 115: 
            case 116: 
            case 120: 
            case 128: 
            case 135: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 117: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 121: 
            case 129: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFiles";
                break;
            }
            case 122: 
            case 130: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearDirectoryFiles";
                break;
            }
            case 123: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionCandidateFiles";
                break;
            }
            case 124: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restCandidateFiles";
                break;
            }
            case 125: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryNames";
                break;
            }
            case 126: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryFiles";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedFiles";
                break;
            }
            case 140: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerNameFiles";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restFiles";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 151: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 168: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textIndexQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 48: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "computePriorities";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "makeOptions";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "matchContextCondition";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeUsageScope";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 28: 
            case 31: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 85: 
            case 104: 
            case 107: 
            case 141: 
            case 142: 
            case 144: 
            case 152: 
            case 154: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 46: 
            case 47: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "computePriorities";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalPsiFile";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateFilesForText";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequests";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "processUnsortedCandidates";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "processCandidatesInChunks";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "processCandidatesInOneCall";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "computeQueries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 13, 28, 31, 48, 51, 52, 53, 62, 85, 104, 107, 141, 142, 144, 152, 154 -> new IllegalStateException(string);
        };
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }

    @ApiStatus.Internal
    public static final class TextIndexQuery {
        @NotNull
        private final Collection<String> myInitialWords;
        @NotNull
        private final Set<? extends IdIndexEntry> myIdIndexEntries;
        @NotNull
        private final Set<? extends Integer> myTrigrams;
        private final short myContext;
        private static final short NO_SEARCH_CONTEXT = -1;
        private final boolean myUseOnlyWordHashToSearch;

        private TextIndexQuery(@NotNull Set<? extends IdIndexEntry> idIndexEntries, @NotNull Set<? extends Integer> trigrams, short searchContext, boolean useOnlyWordHashToSearch, @NotNull Collection<String> initialWords) {
            if (idIndexEntries == null) {
                TextIndexQuery.$$$reportNull$$$0(0);
            }
            if (trigrams == null) {
                TextIndexQuery.$$$reportNull$$$0(1);
            }
            if (initialWords == null) {
                TextIndexQuery.$$$reportNull$$$0(2);
            }
            this.myIdIndexEntries = idIndexEntries;
            this.myTrigrams = trigrams;
            this.myContext = searchContext;
            this.myUseOnlyWordHashToSearch = useOnlyWordHashToSearch;
            this.myInitialWords = initialWords;
        }

        @NotNull
        Collection<String> getInitialWords() {
            Collection<String> collection = this.myInitialWords;
            if (collection == null) {
                TextIndexQuery.$$$reportNull$$$0(3);
            }
            return collection;
        }

        public boolean isEmpty() {
            return this.myIdIndexEntries.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextIndexQuery query = (TextIndexQuery)o;
            return this.myIdIndexEntries.equals(query.myIdIndexEntries) && this.myTrigrams.equals(query.myTrigrams) && Objects.equals(this.myContext, query.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myIdIndexEntries, this.myTrigrams, this.myContext);
        }

        @NotNull
        public List<FileBasedIndex.AllKeysQuery<?, ?>> toFileBasedIndexQueries() {
            Condition<Integer> contextCondition = this.myContext == -1 ? null : PsiSearchHelperImpl.matchContextCondition(this.myContext);
            FileBasedIndex.AllKeysQuery idIndexQuery = new FileBasedIndex.AllKeysQuery(IdIndex.NAME, this.myIdIndexEntries, contextCondition);
            if (this.myUseOnlyWordHashToSearch || this.myTrigrams.isEmpty()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list = Collections.singletonList(idIndexQuery);
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (IdIndexEntry.useStrongerHash()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list = Collections.singletonList(idIndexQuery);
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(5);
                }
                return list;
            }
            FileBasedIndex.AllKeysQuery trigramIndexQuery = new FileBasedIndex.AllKeysQuery(TrigramIndex.INDEX_ID, this.myTrigrams, null);
            List<FileBasedIndex.AllKeysQuery<?, ?>> list = Arrays.asList(idIndexQuery, trigramIndexQuery);
            if (list == null) {
                TextIndexQuery.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        private static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, boolean useOnlyWordHashToSearch, short searchContext) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(7);
            }
            return TextIndexQuery.fromWords(Collections.singleton(word), caseSensitively, useOnlyWordHashToSearch, searchContext);
        }

        @NotNull
        static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, short searchContext) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(8);
            }
            return TextIndexQuery.fromWord(word, caseSensitively, false, searchContext);
        }

        @NotNull
        public static TextIndexQuery fromWords(@NotNull Collection<String> words, boolean caseSensitively, boolean useOnlyWordHashToSearch, short searchContext) {
            IntSets.EmptySet trigrams;
            if (words == null) {
                TextIndexQuery.$$$reportNull$$$0(9);
            }
            Set keys = CollectionFactory.createSmallMemoryFootprintSet((Collection)ContainerUtil.flatMap(words, w -> TextIndexQuery.getWordEntries(w, caseSensitively)));
            if (!useOnlyWordHashToSearch) {
                trigrams = new IntOpenHashSet();
                for (String word : words) {
                    trigrams.addAll((IntCollection)TrigramBuilder.getTrigrams((CharSequence)word));
                }
            } else {
                trigrams = IntSets.EMPTY_SET;
            }
            return new TextIndexQuery(keys, (Set<? extends Integer>)trigrams, searchContext, useOnlyWordHashToSearch, words);
        }

        private static @Unmodifiable @NotNull List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
            String trimmed;
            List<String> words;
            if (name == null) {
                TextIndexQuery.$$$reportNull$$$0(10);
            }
            if ((words = StringUtil.getWordsInStringLongestFirst((String)name)).isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name.trim()))) {
                words = Collections.singletonList(trimmed);
            }
            if (words.isEmpty()) {
                List<IdIndexEntry> list = Collections.emptyList();
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(11);
                }
                return list;
            }
            List list = ContainerUtil.map((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
            if (list == null) {
                TextIndexQuery.$$$reportNull$$$0(12);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idIndexEntries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigrams";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWords";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialWords";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFileBasedIndexQueries";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWord";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWords";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordEntries";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static final class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<? super PsiReference> processor) {
            if (request == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request;
            this.refProcessor = processor;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            String string = this.request.word;
            if (string == null) {
                RequestWithProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            SearchScope searchScope = this.request.searchScope;
            if (searchScope == null) {
                RequestWithProcessor.$$$reportNull$$$0(4);
            }
            return searchScope;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @NotNull
        public SearchSession getSearchSession() {
            SearchSession searchSession = this.request.getSearchSession();
            if (searchSession == null) {
                RequestWithProcessor.$$$reportNull$$$0(5);
            }
            return searchSession;
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    record CandidateFileInfo(@NotNull VirtualFile candidateVirtualFile, @NotNull PsiFile psiFile) {
        @NotNull
        private final VirtualFile candidateVirtualFile;
        @NotNull
        private final PsiFile psiFile;

        CandidateFileInfo(@NotNull VirtualFile candidateVirtualFile, @NotNull PsiFile psiFile) {
            if (candidateVirtualFile == null) {
                CandidateFileInfo.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                CandidateFileInfo.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public VirtualFile candidateVirtualFile() {
            VirtualFile virtualFile = this.candidateVirtualFile;
            if (virtualFile == null) {
                CandidateFileInfo.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public PsiFile psiFile() {
            PsiFile psiFile = this.psiFile;
            if (psiFile == null) {
                CandidateFileInfo.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidateVirtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$CandidateFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$CandidateFileInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "candidateVirtualFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

