/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SingleTargetRequestResultProcessor
extends RequestResultProcessor {
    private final PsiElement myTarget;
    private final PsiReferenceService myService;

    public SingleTargetRequestResultProcessor(@NotNull PsiElement target) {
        if (target == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(0);
        }
        super(target);
        this.myService = PsiReferenceService.getService();
        this.myTarget = target;
    }

    @Override
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        if (element == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(2);
        }
        if (!this.myTarget.isValid()) {
            return false;
        }
        PsiReferenceService.Hints hints = new PsiReferenceService.Hints(this.myTarget, Integer.valueOf(offsetInElement));
        List references = this.myService.getReferences(element, hints);
        for (int i = 0; i < references.size(); ++i) {
            PsiReference ref = (PsiReference)references.get(i);
            ProgressManager.checkCanceled();
            if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer.process((Object)ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SingleTarget: " + String.valueOf(this.myTarget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/SingleTargetRequestResultProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextOccurrence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

