/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexedFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public abstract class FileBasedIndex {
    @ApiStatus.Internal
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty((String)"idea.index.snapshot.mappings.enabled", (boolean)false);
    @ApiStatus.Internal
    public static final boolean USE_IN_MEMORY_INDEX = Boolean.getBoolean("idea.use.in.memory.file.based.index");
    @ApiStatus.Internal
    public static final boolean IGNORE_PLAIN_TEXT_FILES = Boolean.getBoolean("idea.ignore.plain.text.indexing");

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, @Nullable ProgressIndicator var3);

    @RequiresBackgroundThread
    @ApiStatus.Experimental
    public abstract boolean iterateNonIndexableFiles(@NotNull Project var1, @Nullable VirtualFileFilter var2, @NotNull ContentIterator var3);

    @Nullable
    public abstract VirtualFile getFileBeingCurrentlyIndexed();

    @ApiStatus.Internal
    @Nullable
    public abstract IndexWritingFile getFileWritingCurrentlyIndexes();

    @ApiStatus.Internal
    public void registerProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndex.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    @Nullable
    public abstract IdFilter projectIndexableFiles(@Nullable Project var1);

    @ApiStatus.Internal
    public void onProjectClosing(@NotNull Project project) {
        if (project == null) {
            FileBasedIndex.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        return this.getCurrentDumbModeAccessType(null);
    }

    @ApiStatus.Internal
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType(@Nullable Project project) {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    @NotNull
    public <T> Processor<? super T> inheritCurrentDumbAccessType(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(2);
        }
        Processor<? super T> processor2 = processor;
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(3);
        }
        return processor2;
    }

    public static FileBasedIndex getInstance() {
        return (FileBasedIndex)ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            FileBasedIndex.$$$reportNull$$$0(4);
        }
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)file).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + String.valueOf(file) + ", implementation class: " + file.getClass().getName());
    }

    @Deprecated(forRemoval=true)
    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(5);
        }
        this.requestRebuild(indexId, new RebuildRequestedByUserAction(PluginUtil.getInstance().findPluginId(new Throwable())));
    }

    @NotNull
    public abstract <K, V> @Unmodifiable List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> @Unmodifiable Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @ApiStatus.Experimental
    @NotNull
    public abstract <K, V> Iterator<VirtualFile> getContainingFilesIterator(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<? super V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(6);
        }
        if (dataKey == null) {
            FileBasedIndex.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            FileBasedIndex.$$$reportNull$$$0(9);
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> long getIndexModificationStamp(@NotNull ID<K, V> var1, @NotNull Project var2);

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<? super V> var4, @NotNull Processor<? super VirtualFile> var5);

    public abstract <K, V> boolean processFilesContainingAnyKey(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable IdFilter var4, @Nullable Condition<? super V> var5, @NotNull Processor<? super VirtualFile> var6);

    @NotNull
    public abstract <K> @Unmodifiable Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    @ApiStatus.Internal
    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, @NotNull Throwable var2);

    @Deprecated
    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<? extends K> var2, @NotNull Processor<? super VirtualFile> var3, @NotNull GlobalSearchScope var4);

    @ApiStatus.Experimental
    public void ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull Runnable command) {
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(10);
        }
        if (command == null) {
            FileBasedIndex.$$$reportNull$$$0(11);
        }
        this.ignoreDumbMode(dumbModeAccessType, () -> {
            command.run();
            return null;
        });
    }

    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            FileBasedIndex.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<? super K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FileBasedIndex.$$$reportNull$$$0(16);
        }
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    @NotNull
    public abstract <K, V> @Unmodifiable Map<K, V> getFileData(@NotNull ID<K, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    @Nullable
    public abstract <V> V getSingleEntryIndexData(@NotNull ID<Integer, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    public static void iterateRecursively(@NotNull VirtualFile root, @NotNull ContentIterator processor, @Nullable ProgressIndicator indicator, @Nullable Set<? super VirtualFile> visitedRoots, @Nullable ProjectFileIndex projectFileIndex) {
        if (root == null) {
            FileBasedIndex.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(18);
        }
        VirtualFileFilter acceptFilter = file -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (visitedRoots != null && !root.equals(file) && file.isDirectory() && !visitedRoots.add(file)) {
                return false;
            }
            return projectFileIndex == null || (Boolean)ReadAction.compute(() -> projectFileIndex.isExcluded(file)) == false;
        };
        VirtualFileFilter symlinkFilter = file -> {
            if (acceptFilter.accept(file)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    if (!Registry.is((String)"indexer.follows.symlinks")) {
                        return false;
                    }
                    VirtualFile canonicalFile = file.getCanonicalFile();
                    if (canonicalFile != null) {
                        return acceptFilter.accept(canonicalFile);
                    }
                }
                return true;
            }
            return false;
        };
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, (VirtualFileFilter)symlinkFilter, (ContentIterator)processor);
    }

    public void invalidateCaches() {
        throw new IncorrectOperationException();
    }

    @ApiStatus.Experimental
    public boolean processFilesContainingAllKeys(@NotNull Collection<? extends AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor) {
        if (queries == null) {
            FileBasedIndex.$$$reportNull$$$0(19);
        }
        if (filter == null) {
            FileBasedIndex.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public static boolean isIndexAccessDuringDumbModeEnabled() {
        return true;
    }

    @ApiStatus.Internal
    public static boolean isCompositeIndexer(@NotNull DataIndexer<?, ?, ?> indexer) {
        if (indexer == null) {
            FileBasedIndex.$$$reportNull$$$0(22);
        }
        return indexer instanceof CompositeDataIndexer && !USE_IN_MEMORY_INDEX;
    }

    @ApiStatus.Internal
    public void loadIndexes() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritCurrentDumbAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectFileSets";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inheritCurrentDumbAccessType";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateRecursively";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeIndexer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class RebuildRequestedByUserAction
    extends Throwable {
        @Nullable
        private final PluginId myRequestorPluginId;

        private RebuildRequestedByUserAction(@Nullable PluginId requestorPluginId) {
            this.myRequestorPluginId = requestorPluginId;
        }

        @Nullable
        public PluginId getRequestorPluginId() {
            return this.myRequestorPluginId;
        }
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }

    @ApiStatus.OverrideOnly
    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.OverrideOnly
    public static interface ProjectSpecificInputFilter
    extends InputFilter {
        @Override
        default public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                ProjectSpecificInputFilter.$$$reportNull$$$0(0);
            }
            PluginException.reportDeprecatedDefault(this.getClass(), (String)"acceptInput", (String)"`acceptInput(IndexedFile)` should be called");
            return false;
        }

        public boolean acceptInput(@NotNull IndexedFile var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndex$ProjectSpecificInputFilter", "acceptInput"));
        }
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @ApiStatus.Experimental
    public static final class AllKeysQuery<K, V> {
        @NotNull
        private final ID<K, V> indexId;
        @NotNull
        private final Collection<? extends K> dataKeys;
        @Nullable
        private final Condition<? super V> valueChecker;

        public AllKeysQuery(@NotNull ID<K, V> id, @NotNull @Unmodifiable Collection<? extends K> keys, @Nullable Condition<? super V> checker) {
            if (id == null) {
                AllKeysQuery.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                AllKeysQuery.$$$reportNull$$$0(1);
            }
            this.indexId = id;
            this.dataKeys = keys;
            this.valueChecker = checker;
        }

        @NotNull
        public ID<K, V> getIndexId() {
            ID<K, V> iD = this.indexId;
            if (iD == null) {
                AllKeysQuery.$$$reportNull$$$0(2);
            }
            return iD;
        }

        @NotNull
        public @Unmodifiable Collection<? extends K> getDataKeys() {
            Collection<? extends K> collection = this.dataKeys;
            if (collection == null) {
                AllKeysQuery.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Nullable
        public Condition<? super V> getValueChecker() {
            return this.valueChecker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/FileBasedIndex$AllKeysQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/FileBasedIndex$AllKeysQuery";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class IndexWritingFile {
        public final int fileId;

        public IndexWritingFile(int id) {
            this.fileId = id;
        }
    }
}

