/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.instanceContainer.internal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.instanceContainer.InstanceNotRegisteredException;
import com.intellij.platform.instanceContainer.internal.InitializedInstanceHolder;
import com.intellij.platform.instanceContainer.internal.InstanceAlreadyRegisteredException;
import com.intellij.platform.instanceContainer.internal.InstanceContainerInternal;
import com.intellij.platform.instanceContainer.internal.InstanceHolder;
import com.intellij.platform.instanceContainer.internal.PreparedHolders;
import com.intellij.platform.instanceContainer.internal.RegistrationAction;
import com.intellij.platform.instanceContainer.internal.StaticInstanceHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0007\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\r\u001a,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u0005H\u0000\u001aD\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003*$\b\u0000\u0010\u0004\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "InstanceHolders", "", "", "Lcom/intellij/platform/instanceContainer/internal/InstanceHolder;", "isStatic", "", "initializedInstances", "Lkotlin/sequences/Sequence;", "", "Lcom/intellij/platform/instanceContainer/internal/InstanceContainerInternal;", "prepareHolders", "Lcom/intellij/platform/instanceContainer/internal/PreparedHolders;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "additionalContext", "Lkotlin/coroutines/CoroutineContext;", "actions", "Lcom/intellij/platform/instanceContainer/internal/RegistrationAction;", "checkExistingRegistration", "", "state", "Lcom/intellij/platform/instanceContainer/internal/InstanceHolders;", "preparedHolders", "keyClassName", "existing", "new", "intellij.platform.instanceContainer"})
public final class UtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final boolean isStatic(@NotNull InstanceHolder $this$isStatic) {
        Intrinsics.checkNotNullParameter((Object)$this$isStatic, (String)"<this>");
        return $this$isStatic instanceof StaticInstanceHolder || $this$isStatic instanceof InitializedInstanceHolder;
    }

    @NotNull
    public static final Sequence<Object> initializedInstances(@NotNull InstanceContainerInternal $this$initializedInstances) {
        Intrinsics.checkNotNullParameter((Object)$this$initializedInstances, (String)"<this>");
        Collection<InstanceHolder> holders = $this$initializedInstances.instanceHolders();
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Object>, Continuation<? super Unit>, Object>(holders, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Collection<InstanceHolder> $holders;
            {
                this.$holders = $holders;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                InstanceHolder holder;
                Object instance2;
                Iterator iterator;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        iterator = this.$holders.iterator();
                        break;
                    }
                    case 1: {
                        instance2 = this.L$3;
                        holder = (InstanceHolder)this.L$2;
                        iterator = (Iterator)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator.hasNext()) {
                    holder = iterator.next();
                    try {
                        void $this$sequence;
                        if (holder.tryGetInstance() == null) continue;
                        this.L$0 = $this$sequence;
                        this.L$1 = iterator;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)holder);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)instance2);
                        this.label = 1;
                        object = $this$sequence.yield(instance2, (Continuation)this);
                        if (object != object2) continue;
                    }
                    catch (Throwable t) {
                        UtilKt.getLOG().warn(t);
                    }
                    return object2;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<Object> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public static final PreparedHolders prepareHolders(@NotNull CoroutineScope parentScope, @NotNull CoroutineContext additionalContext, @NotNull Map<String, ? extends RegistrationAction> actions) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)additionalContext, (String)"additionalContext");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        LinkedHashMap holders = new LinkedHashMap(actions.size());
        HashSet<String> keysToAdd = new HashSet<String>();
        HashSet<String> keysToRemove = new HashSet<String>();
        for (Map.Entry<String, ? extends RegistrationAction> entry : actions.entrySet()) {
            String keyClassName = entry.getKey();
            RegistrationAction action = entry.getValue();
            RegistrationAction registrationAction = action;
            if (registrationAction instanceof RegistrationAction.Register) {
                keysToAdd.add(keyClassName);
                ((Map)holders).put(keyClassName, new StaticInstanceHolder(parentScope, additionalContext, ((RegistrationAction.Register)action).getInitializer()));
                continue;
            }
            if (registrationAction instanceof RegistrationAction.Override) {
                ((Map)holders).put(keyClassName, new StaticInstanceHolder(parentScope, additionalContext, ((RegistrationAction.Override)action).getInitializer()));
                continue;
            }
            if (Intrinsics.areEqual((Object)registrationAction, (Object)RegistrationAction.Remove.INSTANCE)) {
                keysToRemove.add(keyClassName);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new PreparedHolders(holders, (Set<String>)keysToAdd, (Set<String>)keysToRemove);
    }

    public static final void checkExistingRegistration(@NotNull Map<String, ? extends InstanceHolder> state, @NotNull PreparedHolders preparedHolders, @NotNull String keyClassName, @Nullable InstanceHolder existing, @Nullable InstanceHolder instanceHolder) {
        IllegalStateException t;
        boolean override;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)preparedHolders, (String)"preparedHolders");
        Intrinsics.checkNotNullParameter((Object)keyClassName, (String)"keyClassName");
        boolean bl = override = !preparedHolders.getKeysToAdd().contains(keyClassName);
        if (override && existing == null) {
            Object object = instanceHolder;
            if (object == null || (object = object.instanceClassName()) == null) {
                object = "<removed>";
            }
            v2 = new InstanceNotRegisteredException(keyClassName + " -> " + (String)object);
        } else if (!override && existing != null) {
            InstanceHolder instanceHolder2 = instanceHolder;
            v2 = new InstanceAlreadyRegisteredException(keyClassName, existing.instanceClassName(), instanceHolder2 != null ? instanceHolder2.instanceClassName() : null);
        } else {
            v2 = t = null;
        }
        if (t != null) {
            LOG.debug(StringsKt.trimIndent((String)("  \n         --- State dump --- \n        " + state + "\n         --- To apply ---\n        " + preparedHolders.getHolders() + "\n         --- To register ---\n        " + preparedHolders.getKeysToAdd() + "\n         --- To remove --- \n        " + preparedHolders.getKeysToRemove() + "\n         --- End state dump ---\n      ")), (Throwable)t);
            throw t;
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.platform.instanceContainer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

