/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.impl.JpsEncodingProjectConfigurationImpl;

@ApiStatus.Internal
public final class JpsEncodingConfigurationServiceImpl
extends JpsEncodingConfigurationService {
    private static final JpsElementChildRoleBase<JpsSimpleElement<String>> ENCODING_ROLE = JpsElementChildRoleBase.create((String)"encoding");

    @Nullable
    public String getGlobalEncoding(@NotNull JpsGlobal global) {
        JpsSimpleElement encoding;
        if (global == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(0);
        }
        return (encoding = (JpsSimpleElement)global.getContainer().getChild(ENCODING_ROLE)) != null ? (String)encoding.getData() : null;
    }

    public void setGlobalEncoding(@NotNull JpsGlobal global, @Nullable String encoding) {
        if (global == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(1);
        }
        if (encoding != null) {
            global.getContainer().setChild(ENCODING_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)encoding));
        } else {
            global.getContainer().removeChild(ENCODING_ROLE);
        }
    }

    @Nullable
    public String getProjectEncoding(@NotNull JpsModel model) {
        String projectEncoding;
        JpsEncodingProjectConfiguration configuration;
        if (model == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(2);
        }
        if ((configuration = this.getEncodingConfiguration(model.getProject())) != null && (projectEncoding = configuration.getProjectEncoding()) != null) {
            return projectEncoding;
        }
        return this.getGlobalEncoding(model.getGlobal());
    }

    @Nullable
    public JpsEncodingProjectConfiguration getEncodingConfiguration(@NotNull JpsProject project) {
        if (project == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(3);
        }
        return (JpsEncodingProjectConfiguration)project.getContainer().getChild(JpsEncodingProjectConfigurationImpl.ROLE);
    }

    @NotNull
    public JpsEncodingProjectConfiguration setEncodingConfiguration(@NotNull JpsProject project, @Nullable String projectEncoding, @NotNull Map<String, String> urlToEncoding) {
        if (project == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(4);
        }
        if (urlToEncoding == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(5);
        }
        JpsEncodingProjectConfigurationImpl configuration = new JpsEncodingProjectConfigurationImpl(urlToEncoding, projectEncoding);
        JpsEncodingProjectConfiguration jpsEncodingProjectConfiguration = (JpsEncodingProjectConfiguration)project.getContainer().setChild(JpsEncodingProjectConfigurationImpl.ROLE, (JpsElement)configuration);
        if (jpsEncodingProjectConfiguration == null) {
            JpsEncodingConfigurationServiceImpl.$$$reportNull$$$0(6);
        }
        return jpsEncodingProjectConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlToEncoding";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setEncodingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setGlobalEncoding";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectEncoding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEncodingConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEncodingConfiguration";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

