/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootProcessing;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public final class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private static final ConcurrentMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>> rootRoles = new ConcurrentHashMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>>();
    private final JpsLibraryType<P> libraryType;

    public JpsLibraryImpl(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        if (name == null) {
            JpsLibraryImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JpsLibraryImpl.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            JpsLibraryImpl.$$$reportNull$$$0(2);
        }
        super(name);
        this.libraryType = type;
        this.myContainer.setChild(this.libraryType.getPropertiesRole(), properties);
    }

    private JpsLibraryImpl(@NotNull JpsLibraryImpl<P> original) {
        if (original == null) {
            JpsLibraryImpl.$$$reportNull$$$0(3);
        }
        super(original);
        this.libraryType = original.libraryType;
    }

    @NotNull
    public JpsLibraryType<P> getType() {
        JpsLibraryType<P> jpsLibraryType = this.libraryType;
        if (jpsLibraryType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(4);
        }
        return jpsLibraryType;
    }

    @Nullable
    public <T extends JpsElement> JpsTypedLibrary<T> asTyped(@NotNull JpsLibraryType<T> type) {
        if (type == null) {
            JpsLibraryImpl.$$$reportNull$$$0(5);
        }
        return this.libraryType.equals(type) ? this : null;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.libraryType.getPropertiesRole());
        if (jpsElement == null) {
            JpsLibraryImpl.$$$reportNull$$$0(6);
        }
        return (P)jpsElement;
    }

    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(7);
        }
        List list = (rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType))) != null ? rootsCollection.getElements() : Collections.emptyList();
        if (list == null) {
            JpsLibraryImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(9);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(10);
        }
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    public void addRoot(@NotNull Path path, @NotNull JpsOrderRootType rootType) {
        if (path == null) {
            JpsLibraryImpl.$$$reportNull$$$0(11);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(12);
        }
        this.addRoot(JpsPathUtil.getLibraryRootUrl((Path)path), rootType);
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(13);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(14);
        }
        if (options == null) {
            JpsLibraryImpl.$$$reportNull$$$0(15);
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild((JpsElement)new JpsLibraryRootImpl(url, rootType, options));
    }

    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(17);
        }
        if ((rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType))) != null) {
            for (JpsLibraryRoot root : rootsCollection.getElements()) {
                if (!root.getUrl().equals(url) || !root.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild((JpsElement)root);
                break;
            }
        }
    }

    @NotNull
    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(@NotNull JpsOrderRootType type) {
        if (type == null) {
            JpsLibraryImpl.$$$reportNull$$$0(18);
        }
        JpsElementCollectionRole jpsElementCollectionRole = rootRoles.computeIfAbsent(type, it -> JpsElementCollectionRole.create((JpsElementChildRole)new JpsLibraryRootRole((JpsOrderRootType)it)));
        if (jpsElementCollectionRole == null) {
            JpsLibraryImpl.$$$reportNull$$$0(19);
        }
        return jpsElementCollectionRole;
    }

    public void delete() {
        this.getParent().removeChild(this);
    }

    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    @NotNull
    public JpsLibraryImpl<P> createCopy() {
        return new JpsLibraryImpl<P>(this);
    }

    @NotNull
    public JpsLibraryReference createReference() {
        return new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)this.getParent().getParent()).createReference();
    }

    @NotNull
    public @Unmodifiable List<File> getFiles(@NotNull JpsOrderRootType rootType) {
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(20);
        }
        List<File> list = JpsLibraryRootProcessing.convertToFiles(this.getRoots(rootType));
        if (list == null) {
            JpsLibraryImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<Path> getPaths(@NotNull JpsOrderRootType rootType) {
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(22);
        }
        List<Path> list = JpsLibraryRootProcessing.convertToPaths(this.getRoots(rootType));
        if (list == null) {
            JpsLibraryImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    public List<String> getRootUrls(@NotNull JpsOrderRootType rootType) {
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(24);
        }
        return JpsLibraryRootProcessing.convertToUrls(this.getRoots(rootType));
    }

    public String toString() {
        return "JpsLibraryImpl: " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRole";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asTyped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeUrl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRole";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootUrls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

