/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public class JavaModuleIndexImpl
extends JpsElementBase<JavaModuleIndexImpl>
implements JavaModuleIndex {
    private static final String SOURCE_SUFFIX = ":S";
    private static final String TEST_SUFFIX = ":T";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private static final File NULL_FILE = new File("-");
    private final Map<String, File> myMapping;
    private final JpsCompilerExcludes myExcludes;

    public JavaModuleIndexImpl(@NotNull JpsCompilerExcludes excludes) {
        if (excludes == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(0);
        }
        this.myMapping = new ConcurrentHashMap<String, File>();
        this.myExcludes = excludes;
    }

    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module, boolean forTests) {
        if (module == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(1);
        }
        String key = module.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX);
        File file = this.myMapping.computeIfAbsent(key, __ -> this.findModuleInfoFile(module, forTests));
        return file == NULL_FILE ? null : file;
    }

    private File findModuleInfoFile(JpsModule module, boolean forTests) {
        JavaSourceRootType rootType = forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            File file;
            if (!rootType.equals(root.getRootType()) || !(file = new File(JpsPathUtil.urlToOsPath((String)root.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file)) continue;
            return file;
        }
        return NULL_FILE;
    }

    @TestOnly
    public void dropCache() {
        this.myMapping.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleInfoFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

