/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArchivePackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactOutputPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactRootElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsExtractedDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsFileCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsLibraryFilesPackagingElementImpl;
import org.jetbrains.jps.model.library.JpsLibraryReference;

@ApiStatus.Internal
public class JpsPackagingElementFactoryImpl
extends JpsPackagingElementFactory {
    @NotNull
    public JpsDirectoryCopyPackagingElement createDirectoryCopy(@NotNull String directoryPath) {
        if (directoryPath == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(0);
        }
        return new JpsDirectoryCopyPackagingElementImpl(directoryPath);
    }

    public JpsPackagingElement createParentDirectories(String relativeOutputPath, JpsPackagingElement element) {
        if ((relativeOutputPath = Strings.trimStart((String)relativeOutputPath, (String)"/")).isEmpty()) {
            return element;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        JpsDirectoryPackagingElement root = this.createDirectory(rootName);
        JpsCompositePackagingElement last = this.getOrCreateDirectoryOrArchive((JpsCompositePackagingElement)root, pathTail, true);
        last.addChild(element);
        return root;
    }

    public JpsCompositePackagingElement getOrCreateDirectory(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        if (root == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(1);
        }
        if (path == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return this.getOrCreateDirectoryOrArchive(root, path, true);
    }

    public JpsCompositePackagingElement getOrCreateArchive(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        if (root == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(3);
        }
        if (path == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(4);
        }
        return this.getOrCreateDirectoryOrArchive(root, path, false);
    }

    @NotNull
    private JpsCompositePackagingElement getOrCreateDirectoryOrArchive(@NotNull JpsCompositePackagingElement root, @NotNull @NonNls String path, boolean directory) {
        if (root == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(5);
        }
        if (path == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(6);
        }
        if ((path = Strings.trimStart((String)Strings.trimEnd((String)path, (String)"/"), (String)"/")).isEmpty()) {
            JpsCompositePackagingElement jpsCompositePackagingElement = root;
            if (jpsCompositePackagingElement == null) {
                JpsPackagingElementFactoryImpl.$$$reportNull$$$0(7);
            }
            return jpsCompositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        JpsCompositePackagingElement parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        JpsDirectoryPackagingElement last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        JpsCompositePackagingElement jpsCompositePackagingElement = (JpsCompositePackagingElement)parent.addChild((JpsPackagingElement)last);
        if (jpsCompositePackagingElement == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return jpsCompositePackagingElement;
    }

    @NotNull
    public JpsFileCopyPackagingElement createFileCopy(@NotNull String filePath, @Nullable String outputFileName) {
        if (filePath == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(9);
        }
        return new JpsFileCopyPackagingElementImpl(filePath, outputFileName);
    }

    @NotNull
    public JpsExtractedDirectoryPackagingElement createExtractedDirectory(@NotNull String jarPath, @NotNull String pathInJar) {
        if (jarPath == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(10);
        }
        if (pathInJar == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(11);
        }
        return new JpsExtractedDirectoryPackagingElementImpl(jarPath, pathInJar);
    }

    @NotNull
    public JpsDirectoryPackagingElement createDirectory(@NotNull String directoryName) {
        if (directoryName == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(12);
        }
        return new JpsDirectoryPackagingElementImpl(directoryName);
    }

    @NotNull
    public JpsArchivePackagingElement createArchive(@NotNull String archiveName) {
        if (archiveName == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(13);
        }
        return new JpsArchivePackagingElementImpl(archiveName);
    }

    @NotNull
    public JpsArtifactRootElement createArtifactRoot() {
        return new JpsArtifactRootElementImpl();
    }

    @NotNull
    public JpsLibraryFilesPackagingElement createLibraryElement(@NotNull JpsLibraryReference reference) {
        if (reference == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return new JpsLibraryFilesPackagingElementImpl(reference);
    }

    @NotNull
    public JpsArtifactOutputPackagingElement createArtifactOutput(@NotNull JpsArtifactReference reference) {
        if (reference == null) {
            JpsPackagingElementFactoryImpl.$$$reportNull$$$0(15);
        }
        return new JpsArtifactOutputPackagingElementImpl(reference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectoryOrArchive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryCopy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateArchive";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

