/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsLibraryRootProcessing {
    private static final Set<String> AR_EXTENSIONS = CollectionFactory.createFilePathSet(Arrays.asList("jar", "zip", "swc", "ane"));

    private JpsLibraryRootProcessing() {
    }

    @NotNull
    public static List<String> convertToUrls(@NotNull List<JpsLibraryRoot> roots) {
        if (roots == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(0);
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root : roots) {
            switch (root.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryRootProcessing.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryRootProcessing.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), true, urls);
                }
            }
        }
        ArrayList<String> arrayList = urls;
        if (arrayList == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<File> convertToFiles(@NotNull List<JpsLibraryRoot> roots) {
        if (roots == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(2);
        }
        List<String> urls = JpsLibraryRootProcessing.convertToUrls(roots);
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl((String)url)) continue;
            files.add(JpsPathUtil.urlToFile((String)url));
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static List<Path> convertToPaths(@NotNull List<JpsLibraryRoot> roots) {
        if (roots == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(4);
        }
        List<String> urls = JpsLibraryRootProcessing.convertToUrls(roots);
        ArrayList<Path> result = new ArrayList<Path>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl((String)url)) continue;
            result.add(Path.of(JpsPathUtil.urlToPath((String)url), new String[0]));
        }
        ArrayList<Path> arrayList = result;
        if (arrayList == null) {
            JpsLibraryRootProcessing.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void collectArchives(File file, boolean recursively, List<? super String> result) {
        Object[] children = file.listFiles();
        if (children != null) {
            Arrays.sort(children);
            for (Object child : children) {
                String extension = FileUtilRt.getExtension((String)((File)child).getName());
                if (((File)child).isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryRootProcessing.collectArchives((File)child, recursively, result);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension)) continue;
                result.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/library/impl/JpsLibraryRootProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/library/impl/JpsLibraryRootProcessing";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToUrls";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

