/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.library;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

@ApiStatus.Internal
public final class JpsSdkTableSerializer {
    private static final Logger LOG = Logger.getInstance(JpsSdkTableSerializer.class);
    public static final JpsLibraryRootTypeSerializer[] PREDEFINED_ROOT_TYPE_SERIALIZERS = new JpsLibraryRootTypeSerializer[]{new JpsLibraryRootTypeSerializer("classPath", JpsOrderRootType.COMPILED, true), new JpsLibraryRootTypeSerializer("sourcePath", JpsOrderRootType.SOURCES, true)};
    public static final JpsSdkPropertiesSerializer<JpsDummyElement> JPS_JAVA_SDK_PROPERTIES_LOADER = new JpsSdkPropertiesSerializer<JpsDummyElement>("JavaSDK", (JpsSdkType)JpsJavaSdkType.INSTANCE){

        @Override
        @NotNull
        public JpsDummyElement loadProperties(Element propertiesElement) {
            JpsDummyElement jpsDummyElement = JpsElementFactory.getInstance().createDummyElement();
            if (jpsDummyElement == null) {
                1.$$$reportNull$$$0(0);
            }
            return jpsDummyElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/library/JpsSdkTableSerializer$1", "loadProperties"));
        }
    };
    private static final String JDK_TAG = "jdk";
    private static final String NAME_TAG = "name";
    private static final String TYPE_TAG = "type";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String ROOTS_TAG = "roots";
    private static final String VERSION_TAG = "version";
    private static final String HOME_PATH_TAG = "homePath";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String COMPOSITE_TYPE = "composite";
    private static final String SIMPLE_TYPE = "simple";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ADDITIONAL_TAG = "additional";

    public static void loadSdks(@Nullable Element sdkListElement, JpsLibraryCollection result, @NotNull JpsPathMapper pathMapper) {
        if (pathMapper == null) {
            JpsSdkTableSerializer.$$$reportNull$$$0(0);
        }
        for (Element sdkElement : JDOMUtil.getChildren((Element)sdkListElement, (String)JDK_TAG)) {
            result.addLibrary(JpsSdkTableSerializer.loadSdk(sdkElement, pathMapper));
        }
    }

    private static JpsLibrary loadSdk(Element sdkElement, @NotNull JpsPathMapper pathMapper) {
        if (pathMapper == null) {
            JpsSdkTableSerializer.$$$reportNull$$$0(1);
        }
        String name = JpsSdkTableSerializer.getAttributeValue(sdkElement, NAME_TAG);
        String typeId = JpsSdkTableSerializer.getAttributeValue(sdkElement, "type");
        LOG.debug("Loading " + typeId + " SDK '" + name + "'");
        JpsSdkPropertiesSerializer<?> serializer = JpsSdkTableSerializer.getSdkPropertiesSerializer(typeId);
        JpsLibrary library = JpsSdkTableSerializer.createSdk(name, serializer, pathMapper, sdkElement);
        Element roots = sdkElement.getChild(ROOTS_TAG);
        for (Element rootTypeElement : JDOMUtil.getChildren((Element)roots)) {
            JpsLibraryRootTypeSerializer rootTypeSerializer = JpsSdkTableSerializer.getRootTypeSerializer(rootTypeElement.getName());
            if (rootTypeSerializer != null) {
                for (Element rootElement : rootTypeElement.getChildren()) {
                    JpsSdkTableSerializer.loadRoots(rootElement, library, rootTypeSerializer.getType(), pathMapper);
                }
                continue;
            }
            LOG.info("root type serializer not found for " + rootTypeElement.getName());
        }
        if (LOG.isDebugEnabled()) {
            List files = library.getFiles(JpsOrderRootType.COMPILED);
            LOG.debug(name + " SDK classpath (" + files.size() + " roots):");
            for (File file : files) {
                LOG.debug(" " + file.getAbsolutePath());
            }
        }
        return library;
    }

    private static void loadRoots(Element rootElement, JpsLibrary library, JpsOrderRootType rootType, @NotNull JpsPathMapper pathMapper) {
        String url;
        String type;
        if (pathMapper == null) {
            JpsSdkTableSerializer.$$$reportNull$$$0(2);
        }
        if ((type = rootElement.getAttributeValue("type")).equals(COMPOSITE_TYPE)) {
            for (Element element : rootElement.getChildren()) {
                JpsSdkTableSerializer.loadRoots(element, library, rootType, pathMapper);
            }
        } else if (type.equals(SIMPLE_TYPE) && (url = pathMapper.mapUrl(rootElement.getAttributeValue(URL_ATTRIBUTE))) != null) {
            library.addRoot(url, rootType);
        }
    }

    @Nullable
    private static JpsLibraryRootTypeSerializer getRootTypeSerializer(String typeId) {
        for (JpsLibraryRootTypeSerializer serializer : PREDEFINED_ROOT_TYPE_SERIALIZERS) {
            if (!serializer.getTypeId().equals(typeId)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsLibraryRootTypeSerializer serializer : extension.getSdkRootTypeSerializers()) {
                if (!serializer.getTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static <P extends JpsElement> JpsLibrary createSdk(String name, JpsSdkPropertiesSerializer<P> loader, @NotNull JpsPathMapper pathMapper, Element sdkElement) {
        if (pathMapper == null) {
            JpsSdkTableSerializer.$$$reportNull$$$0(3);
        }
        String versionString = JpsSdkTableSerializer.getAttributeValue(sdkElement, VERSION_TAG);
        String homePath = pathMapper.mapUrl(JpsSdkTableSerializer.getAttributeValue(sdkElement, HOME_PATH_TAG));
        Element propertiesTag = sdkElement.getChild(ADDITIONAL_TAG);
        P properties = loader.loadProperties(propertiesTag);
        return JpsElementFactory.getInstance().createSdk(name, homePath, versionString, (JpsSdkType)loader.getType(), properties);
    }

    public static JpsSdkPropertiesSerializer<?> getSdkPropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsSdkPropertiesSerializer<?> loader : extension.getSdkPropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return JPS_JAVA_SDK_PROPERTIES_LOADER;
    }

    @Nullable
    private static String getAttributeValue(Element element, String childName) {
        Element child = element.getChild(childName);
        return child != null ? child.getAttributeValue(VALUE_ATTRIBUTE) : null;
    }

    public static JpsSdkType<?> getSdkType(@Nullable String typeId) {
        return (JpsSdkType)JpsSdkTableSerializer.getSdkPropertiesSerializer(typeId).getType();
    }

    public static JpsSdkPropertiesSerializer<?> getLoader(JpsSdkType<?> type) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsSdkPropertiesSerializer<?> loader : extension.getSdkPropertiesSerializers()) {
                if (!((JpsSdkType)loader.getType()).equals(type)) continue;
                return loader;
            }
        }
        return JPS_JAVA_SDK_PROPERTIES_LOADER;
    }

    public static <P extends JpsElement> void setSdkReference(JpsSdkReferencesTable table, String sdkName, JpsSdkType<P> sdkType) {
        JpsSdkReference reference = JpsElementFactory.getInstance().createSdkReference(sdkName, sdkType);
        table.setSdkReference(sdkType, reference);
        if (sdkType instanceof JpsJavaSdkTypeWrapper) {
            JpsSdkReference wrapperRef = JpsElementFactory.getInstance().createSdkReference(sdkName, sdkType);
            table.setSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE, JpsJavaExtensionService.getInstance().createWrappedJavaSdkReference((JpsJavaSdkTypeWrapper)sdkType, wrapperRef));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "pathMapper";
        objectArray2[1] = "org/jetbrains/jps/model/serialization/library/JpsSdkTableSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSdks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createSdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

